/*****************************************************************************
 *  $Id: fullscan_plan_mock.hpp 646372 2022-03-07 16:41:20Z saprykin $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 *  Mock object for Cassandra Fullscan Execution plan.
 *
 */

#ifndef OBJTOOLS__PUBSEQ_GATEWAY__IMPL__CASSANDRA__TEST__UNIT__FULLSCAN_PLAN_MOCK_HPP_
#define OBJTOOLS__PUBSEQ_GATEWAY__IMPL__CASSANDRA__TEST__UNIT__FULLSCAN_PLAN_MOCK_HPP_

#include <gmock/gmock.h>

#include <objtools/pubseq_gateway/impl/cassandra/fullscan/plan.hpp>
#include <objtools/pubseq_gateway/impl/cassandra/fullscan/seg_plan.hpp>

BEGIN_IDBLOB_SCOPE
USING_NCBI_SCOPE;

class MockCassandraFullscanPlan
    : public ICassandraFullscanPlan
{
 public:
    MOCK_METHOD0(GetNextQuery, TQueryPtr());
    MOCK_CONST_METHOD0(GetQueryCount, size_t());
    MOCK_METHOD0(Generate, void());
};

class CCassandraFullscanPlanExpose
    : public CCassandraFullscanPlan
{
 public:
    CCassConnection::TTokenRanges CopyRanges()
    {
        return GetTokenRanges();
    }
};

class CCassandraSegmentedPlanExpose
    : public CCassandraSegscanPlan
{
 public:
    CCassConnection::TTokenRanges CopyRanges()
    {
        return GetTokenRanges();
    }
};

END_IDBLOB_SCOPE


#endif  // OBJTOOLS__PUBSEQ_GATEWAY__IMPL__CASSANDRA__TEST__UNIT__FULLSCAN_PLAN_MOCK_HPP_
