/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl.terrain;

import java.util.ArrayList;
import java.util.Arrays;
import javax.vecmath.Vector2f;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValue;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.ExperimentUtil;
import org.tigr.microarray.mev.cluster.algorithm.impl.terrain.FDGLAlgoT;
import org.tigr.microarray.mev.cluster.algorithm.impl.terrain.InterfaceToObjects;
import org.tigr.microarray.mev.cluster.algorithm.impl.terrain.MergeJoinBag;
import org.tigr.microarray.mev.cluster.algorithm.impl.util.FloatArray;
import org.tigr.microarray.mev.cluster.algorithm.impl.util.IntArray;
import org.tigr.util.FloatMatrix;

public class Terrain
extends AbstractAlgorithm
implements InterfaceToObjects {
    private FloatMatrix experiment;
    private IntArray[] links;
    private FloatArray[] distances;
    private float[][] coords;
    private boolean stop = false;

    public AlgorithmData execute(AlgorithmData algorithmData) throws AlgorithmException {
        Object object;
        int n;
        int n2;
        int n3;
        int n4;
        AlgorithmParameters algorithmParameters = algorithmData.getParams();
        int n5 = algorithmParameters.getInt("distance-function", 1);
        float f = algorithmParameters.getFloat("distance-factor", 1.0f);
        boolean bl = algorithmParameters.getBoolean("distance-absolute", false);
        int n6 = algorithmParameters.getInt("neighbors");
        this.experiment = algorithmData.getMatrix("experiment");
        if (!algorithmParameters.getBoolean("use-genes")) {
            FloatMatrix floatMatrix = new FloatMatrix(this.experiment.getColumnDimension(), this.experiment.getRowDimension());
            for (n4 = 0; n4 < this.experiment.getRowDimension(); ++n4) {
                for (n3 = 0; n3 < this.experiment.getColumnDimension(); ++n3) {
                    floatMatrix.set(n3, n4, this.experiment.get(n4, n3));
                }
            }
            this.experiment = floatMatrix;
        }
        int n7 = this.experiment.getRowDimension();
        n4 = n7 * (n7 + 1) / 2;
        n3 = n4 / 100 + 1;
        MergeJoinBag mergeJoinBag = new MergeJoinBag(n7, Math.min(n6, n7));
        AlgorithmEvent algorithmEvent = new AlgorithmEvent(this, 1, 100, "Analyzing Links...");
        this.fireValueChanged(algorithmEvent);
        algorithmEvent.setId(2);
        int n8 = 0;
        for (n2 = 0; n2 < n7; ++n2) {
            if (this.stop) {
                throw new AbortException();
            }
            ++n8;
            for (n = n2 + 1; n < n7; ++n) {
                float f2 = ExperimentUtil.geneDistance(this.experiment, null, n2, n, n5, f, bl);
                mergeJoinBag.Assert(n2, n, f2);
                if (++n8 % n3 != 0) continue;
                algorithmEvent.setIntValue(n8 / n3);
                algorithmEvent.setDescription("Analysing Links...");
                this.fireValueChanged(algorithmEvent);
            }
        }
        mergeJoinBag.Normalize(0.01f);
        this.links = new IntArray[n7];
        this.distances = new FloatArray[n7];
        for (n2 = 0; n2 < this.links.length; ++n2) {
            this.links[n2] = new IntArray();
            this.links[n2].add(n2);
            this.distances[n2] = new FloatArray();
            this.distances[n2].add(0.0f);
        }
        n2 = mergeJoinBag.getRowCount();
        n = mergeJoinBag.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            object = mergeJoinBag.getIndVector(i);
            float[] fArray = mergeJoinBag.getValVector(i);
            for (int j = 0; j < n; ++j) {
                if (object[j] < 0 || !(fArray[j] > 0.0f)) continue;
                this.links[i].add((int)object[j]);
                this.distances[i].add(fArray[j]);
                this.links[object[j]].add(i);
                this.distances[object[j]].add(fArray[j]);
            }
        }
        Cluster cluster = new Cluster();
        object = cluster.getNodeList();
        ((NodeList)object).ensureCapacity(n7);
        for (int i = 0; i < n7; ++i) {
            NodeValueList nodeValueList = new NodeValueList(1);
            nodeValueList.addNodeValue(new NodeValue("weights", this.distances[i].toArray()));
            Node node = new Node(this.links[i].toArray());
            node.setValues(nodeValueList);
            ((NodeList)object).addNode(node);
        }
        int[][] nArrayArray = new int[this.links.length][];
        for (int i = 0; i < nArrayArray.length; ++i) {
            nArrayArray[i] = this.links[i].toArray();
        }
        this.coords = this.doCircularLayout(nArrayArray);
        FDGLAlgoT fDGLAlgoT = new FDGLAlgoT(this);
        fDGLAlgoT.InitFromInterface();
        algorithmEvent.setId(1);
        algorithmEvent.setIntValue(100);
        algorithmEvent.setDescription("Layouting...");
        this.fireValueChanged(algorithmEvent);
        algorithmEvent.setId(2);
        while (!fDGLAlgoT.shouldStop()) {
            if (this.stop) {
                throw new AbortException();
            }
            fDGLAlgoT.CalculateForceField();
            fDGLAlgoT.MoveSystem();
            fDGLAlgoT.UpdateSource();
            algorithmEvent.setIntValue((int)fDGLAlgoT.getPercentage());
            algorithmEvent.setDescription("Layouting...");
            this.fireValueChanged(algorithmEvent);
        }
        float f3 = this.normalize(this.coords);
        float f4 = 0.02f;
        AlgorithmData algorithmData2 = new AlgorithmData();
        algorithmData2.addCluster("links", cluster);
        algorithmData2.addMatrix("locations", new FloatMatrix(this.coords));
        algorithmData2.addParam("sigma", String.valueOf(f4));
        return algorithmData2;
    }

    public void abort() {
        this.stop = true;
    }

    private float[][] doCircularLayout(int[][] nArray) {
        float[][] fArray = new float[nArray.length][2];
        int[][] nArray2 = this.formRelevanceNetworks(nArray);
        int n = (int)Math.ceil(Math.sqrt(nArray2.length));
        int n2 = (int)Math.ceil((float)nArray2.length / (float)n);
        for (int i = 0; i < n2; ++i) {
            int n3;
            for (int j = 0; j < n && (n3 = i * n + j) < nArray2.length; ++j) {
                this.arrangeGraph(nArray2[n3], fArray, j, i);
            }
        }
        return fArray;
    }

    private void arrangeGraph(int[] nArray, float[][] fArray, int n, int n2) {
        for (int i = 0; i < nArray.length; ++i) {
            fArray[nArray[i]][0] = (float)(1000.0 * Math.cos(Math.PI * 2 * (double)i / (double)nArray.length) + (double)(1500 * (n + 1)));
            fArray[nArray[i]][1] = (float)(1000.0 * Math.sin(Math.PI * 2 * (double)i / (double)nArray.length) + (double)(1500 * (n2 + 1)));
        }
    }

    private float normalize(float[][] fArray) {
        int n;
        float f = 0.0f;
        float f2 = Float.MAX_VALUE;
        float f3 = Float.MAX_VALUE;
        for (n = 0; n < fArray.length; ++n) {
            f2 = Math.min(f2, fArray[n][0]);
            f3 = Math.min(f3, fArray[n][1]);
        }
        for (n = 0; n < fArray.length; ++n) {
            fArray[n][0] = fArray[n][0] - f2;
            fArray[n][1] = fArray[n][1] - f3;
        }
        for (n = 0; n < fArray.length; ++n) {
            f = Math.max(f, Math.max(fArray[n][0], fArray[n][1]));
        }
        for (n = 0; n < fArray.length; ++n) {
            fArray[n][0] = fArray[n][0] / f;
            fArray[n][1] = fArray[n][1] / f;
        }
        return f;
    }

    private void normalize(float[][] fArray, int[][] nArray) {
        int n;
        int n2;
        float f = 0.0f;
        float f2 = Float.MAX_VALUE;
        float f3 = Float.MAX_VALUE;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (nArray[n2].length <= 1) continue;
            for (n = 0; n < nArray[n2].length; ++n) {
                f2 = Math.min(f2, fArray[nArray[n2][n]][0]);
                f3 = Math.min(f3, fArray[nArray[n2][n]][1]);
            }
        }
        for (n2 = 0; n2 < fArray.length; ++n2) {
            fArray[n2][0] = fArray[n2][0] - f2;
            fArray[n2][1] = fArray[n2][1] - f3;
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (nArray[n2].length <= 1) continue;
            for (n = 0; n < nArray[n2].length; ++n) {
                f = Math.max(f, Math.max(fArray[nArray[n2][n]][0], fArray[nArray[n2][n]][1]));
            }
        }
        for (n2 = 0; n2 < fArray.length; ++n2) {
            fArray[n2][0] = fArray[n2][0] / f;
            fArray[n2][1] = fArray[n2][1] / f;
        }
    }

    public int[][] formRelevanceNetworks(int[][] nArray) {
        int n;
        int n2 = nArray.length;
        boolean[] blArray = new boolean[n2];
        Arrays.fill(blArray, false);
        ArrayList<IntArray> arrayList = new ArrayList<IntArray>();
        for (n = 0; n < n2; ++n) {
            if (blArray[n]) continue;
            arrayList.add(this.fillSubnet(new IntArray(), n, blArray, nArray));
        }
        n = arrayList.size();
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            if (((IntArray)arrayList.get(i)).getSize() <= 1) continue;
            ++n3;
        }
        int[][] nArrayArray = new int[n3][];
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            IntArray intArray = (IntArray)arrayList.get(i);
            if (intArray.getSize() <= 1) continue;
            nArrayArray[n4] = intArray.toArray();
            ++n4;
        }
        return nArrayArray;
    }

    private IntArray fillSubnet(IntArray intArray, int n, boolean[] blArray, int[][] nArray) {
        intArray.add(n);
        blArray[n] = true;
        int[] nArray2 = nArray[n];
        for (int i = 1; i < nArray2.length; ++i) {
            int n2 = nArray2[i];
            if (blArray[n2]) continue;
            this.fillSubnet(intArray, n2, blArray, nArray);
        }
        return intArray;
    }

    public int[] GetAllObjectsIds() {
        int n = this.experiment.getRowDimension();
        int[] nArray = new int[n];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        return nArray;
    }

    public void GetObjectGeom(int n, Vector2f vector2f) {
        vector2f.set(this.coords[n][0], this.coords[n][1]);
    }

    public int GetAdjCountFor(int n) {
        return this.links[n].getSize() - 1;
    }

    public void GetAdjInfoFor(int n, IntArray intArray, FloatArray floatArray) {
        int n2 = this.links[n].getSize();
        intArray.clear();
        floatArray.clear();
        for (int i = 1; i < n2; ++i) {
            intArray.add(this.links[n].get(i));
            floatArray.add(this.distances[n].get(i));
        }
    }

    public void SetObjectGeom(Vector2f[] vector2fArray) {
        for (int i = 0; i < vector2fArray.length; ++i) {
            this.coords[i][0] = vector2fArray[i].x;
            this.coords[i][1] = vector2fArray[i].y;
        }
    }
}

