/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import JSci.maths.statistics.TDistribution;
import java.io.Serializable;
import java.util.Random;
import java.util.Vector;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValue;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.HCL;
import org.tigr.util.Combinations;
import org.tigr.util.FloatMatrix;
import org.tigr.util.QSort;

public class Ttest
extends AbstractAlgorithm {
    private boolean stop = false;
    private int function;
    private float factor;
    private boolean absolute;
    private FloatMatrix expMatrix;
    boolean hierarchical_tree;
    int method_linkage;
    boolean calculate_genes;
    boolean calculate_experiments;
    private Vector[] clusters;
    private int k;
    private int numGenes;
    private int numExps;
    private float alpha;
    private int significanceMethod;
    private boolean isPermut;
    private boolean useWelchDf;
    int[] groupAssignments;
    private int numCombs;
    boolean useAllCombs;
    int tTestDesign;
    float oneClassMean = 0.0f;
    double currentP = 0.0;
    double currentT = 0.0;
    int currentIndex = 0;
    Vector sigTValues = new Vector();
    Vector sigPValues = new Vector();
    Vector nonSigTValues = new Vector();
    Vector nonSigPValues = new Vector();
    Vector tValuesVector = new Vector();
    Vector pValuesVector = new Vector();
    int validN;

    public AlgorithmData execute(AlgorithmData algorithmData) throws AlgorithmException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n;
        Object object5;
        FloatMatrix floatMatrix;
        this.groupAssignments = algorithmData.getIntArray("group-assignments");
        AlgorithmParameters algorithmParameters = algorithmData.getParams();
        this.function = algorithmParameters.getInt("distance-function", 4);
        this.factor = algorithmParameters.getFloat("distance-factor", 1.0f);
        this.absolute = algorithmParameters.getBoolean("distance-absolute", false);
        this.hierarchical_tree = algorithmParameters.getBoolean("hierarchical-tree", false);
        this.method_linkage = algorithmParameters.getInt("method-linkage", 0);
        this.calculate_genes = algorithmParameters.getBoolean("calculate-genes", false);
        this.calculate_experiments = algorithmParameters.getBoolean("calculate-experiments", false);
        this.expMatrix = algorithmData.getMatrix("experiment");
        this.numGenes = this.expMatrix.getRowDimension();
        this.numExps = this.expMatrix.getColumnDimension();
        this.tTestDesign = algorithmParameters.getInt("tTestDesign", 7);
        if (this.tTestDesign == 8) {
            this.oneClassMean = algorithmParameters.getFloat("oneClassMean", 0.0f);
        }
        this.alpha = algorithmParameters.getFloat("alpha", 0.01f);
        this.significanceMethod = algorithmParameters.getInt("significance-method", 4);
        this.isPermut = algorithmParameters.getBoolean("is-permut", false);
        this.useWelchDf = algorithmParameters.getBoolean("useWelchDf", true);
        this.numCombs = algorithmParameters.getInt("num-combs", 100);
        this.useAllCombs = algorithmParameters.getBoolean("use-all-combs", false);
        if (this.significanceMethod == 10) {
            return this.executeMinP();
        }
        if (this.significanceMethod == 9) {
            return this.executeMaxT();
        }
        Vector vector = new Vector();
        if (this.tTestDesign == 7) {
            vector = this.isPermut ? this.sortGenesByPermutationSignificance() : this.sortGenesBySignificance();
        } else if (this.tTestDesign == 8) {
            vector = this.sortGenesForOneClassDesign();
        }
        this.k = vector.size();
        FloatMatrix floatMatrix2 = new FloatMatrix(this.numGenes, 1);
        for (int i = 0; i < floatMatrix2.getRowDimension(); ++i) {
            floatMatrix2.A[i][0] = 0.0f;
        }
        Vector vector2 = (Vector)vector.get(0);
        for (int i = 0; i < vector2.size(); ++i) {
            int n2 = (Integer)vector2.get(i);
            floatMatrix2.A[n2][0] = 1.0f;
        }
        Vector<Float> vector3 = new Vector<Float>();
        Vector<Float> vector4 = new Vector<Float>();
        Vector<Float> vector5 = new Vector<Float>();
        if (this.tTestDesign == 8) {
            floatMatrix = null;
            this.tValuesVector = new Vector();
            vector3 = new Vector();
            for (int i = 0; i < this.numGenes; ++i) {
                object5 = this.getOneClassGeneValues(i);
                float f = (float)this.getOneClassTValue((float[])object5);
                this.tValuesVector.add(new Float(f));
                float f2 = this.getOneClassDFValue((float[])object5);
                vector3.add(new Float(f2));
                float f3 = this.getMean((float[])object5);
                vector4.add(new Float(f3));
                float f4 = (float)Math.sqrt(this.getVar((float[])object5));
                vector5.add(new Float(f4));
            }
        }
        floatMatrix = new FloatMatrix(this.tValuesVector.size(), 1);
        FloatMatrix floatMatrix3 = new FloatMatrix(this.pValuesVector.size(), 1);
        object5 = new FloatMatrix(this.numGenes, 1);
        FloatMatrix floatMatrix4 = new FloatMatrix(this.numGenes, 1);
        FloatMatrix floatMatrix5 = new FloatMatrix(this.numGenes, 1);
        if (this.tTestDesign == 7) {
            for (int i = 0; i < this.tValuesVector.size(); ++i) {
                floatMatrix.A[i][0] = Math.abs(((Float)this.tValuesVector.get(i)).floatValue());
            }
        } else if (this.tTestDesign == 8) {
            for (int i = 0; i < this.tValuesVector.size(); ++i) {
                floatMatrix.A[i][0] = ((Float)this.tValuesVector.get(i)).floatValue();
            }
        }
        for (n = 0; n < this.pValuesVector.size(); ++n) {
            floatMatrix3.A[n][0] = ((Float)this.pValuesVector.get(n)).floatValue();
        }
        if (this.tTestDesign == 7) {
            for (n = 0; n < this.numGenes; ++n) {
                object5.A[n][0] = this.getDF(n);
            }
        } else if (this.tTestDesign == 8) {
            for (n = 0; n < this.numGenes; ++n) {
                object5.A[n][0] = ((Float)vector3.get(n)).floatValue();
                floatMatrix4.A[n][0] = ((Float)vector4.get(n)).floatValue();
                floatMatrix5.A[n][0] = ((Float)vector5.get(n)).floatValue();
            }
        }
        FloatMatrix floatMatrix6 = new FloatMatrix(this.numGenes, 1);
        FloatMatrix floatMatrix7 = new FloatMatrix(this.numGenes, 1);
        FloatMatrix floatMatrix8 = new FloatMatrix(this.numGenes, 1);
        FloatMatrix floatMatrix9 = new FloatMatrix(this.numGenes, 1);
        if (this.tTestDesign == 7) {
            Vector vector6 = this.getMeansAndSDs();
            object4 = (float[])vector6.get(0);
            object3 = (float[])vector6.get(1);
            object2 = (float[])vector6.get(2);
            object = (float[])vector6.get(3);
            for (int i = 0; i < this.numGenes; ++i) {
                floatMatrix6.A[i][0] = object4[i];
                floatMatrix7.A[i][0] = (float)object3[i];
                floatMatrix8.A[i][0] = (float)object2[i];
                floatMatrix9.A[i][0] = (float)object[i];
            }
        }
        this.clusters = new Vector[this.k];
        for (int i = 0; i < this.k; ++i) {
            this.clusters[i] = (Vector)vector.get(i);
        }
        FloatMatrix floatMatrix10 = this.getMeans(this.clusters);
        object4 = this.getVariances(this.clusters, floatMatrix10);
        object3 = null;
        if (this.hierarchical_tree) {
            object3 = new AlgorithmEvent(this, 1, this.clusters.length, "Calculate Hierarchical Trees");
            this.fireValueChanged((AlgorithmEvent)object3);
            ((AlgorithmEvent)object3).setIntValue(0);
            ((AlgorithmEvent)object3).setId(2);
            this.fireValueChanged((AlgorithmEvent)object3);
        }
        object2 = new Cluster();
        object = ((Cluster)object2).getNodeList();
        for (int i = 0; i < this.clusters.length; ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            int[] nArray = this.convert2int(this.clusters[i]);
            Node node = new Node(nArray);
            ((NodeList)object).addNode(node);
            if (!this.hierarchical_tree) continue;
            node.setValues(this.calculateHierarchicalTree(nArray, this.method_linkage, this.calculate_genes, this.calculate_experiments));
            ((AlgorithmEvent)object3).setIntValue(i + 1);
            this.fireValueChanged((AlgorithmEvent)object3);
        }
        AlgorithmData algorithmData2 = new AlgorithmData();
        algorithmData2.addCluster("cluster", (Cluster)object2);
        algorithmData2.addParam("number-of-clusters", String.valueOf(this.clusters.length));
        algorithmData2.addMatrix("clusters_means", floatMatrix10);
        algorithmData2.addMatrix("clusters_variances", (FloatMatrix)object4);
        algorithmData2.addMatrix("pValues", floatMatrix3);
        algorithmData2.addMatrix("tValues", floatMatrix);
        algorithmData2.addMatrix("dfValues", (FloatMatrix)object5);
        algorithmData2.addMatrix("meansAMatrix", floatMatrix6);
        algorithmData2.addMatrix("meansBMatrix", floatMatrix7);
        algorithmData2.addMatrix("sdAMatrix", floatMatrix8);
        algorithmData2.addMatrix("sdBMatrix", floatMatrix9);
        algorithmData2.addMatrix("isSigMatrix", floatMatrix2);
        algorithmData2.addMatrix("oneClassMeansMatrix", floatMatrix4);
        algorithmData2.addMatrix("oneClassSDsMatrix", floatMatrix5);
        return algorithmData2;
    }

    public AlgorithmData executeMaxT() throws AlgorithmException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n;
        int n2;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        int n3;
        QSort qSort;
        double[] dArray = new double[this.numGenes];
        double[] dArray2 = new double[this.numGenes];
        int[] nArray = new int[this.numGenes];
        double[] dArray3 = new double[this.numGenes];
        double[][] dArray4 = new double[this.numCombs][this.numGenes];
        double[][] dArray5 = new double[this.numGenes][this.numCombs];
        AlgorithmEvent algorithmEvent = new AlgorithmEvent(this, 1, this.numCombs);
        this.fireValueChanged(algorithmEvent);
        algorithmEvent.setId(2);
        if (this.tTestDesign == 7) {
            for (int i = 0; i < this.numGenes; ++i) {
                dArray[i] = Math.abs(this.getTValue(i));
            }
            qSort = new QSort(dArray, 2);
            dArray2 = qSort.getSortedDouble();
            nArray = qSort.getOrigIndx();
            if (!this.useAllCombs) {
                for (n3 = 0; n3 < this.numCombs; ++n3) {
                    if (this.stop) {
                        throw new AbortException();
                    }
                    algorithmEvent.setIntValue(n3);
                    algorithmEvent.setDescription("Permuting matrix: Current permutation = " + (n3 + 1));
                    this.fireValueChanged(algorithmEvent);
                    object8 = new int[1];
                    Vector<Integer> vector = new Vector<Integer>();
                    for (int i = 0; i < this.groupAssignments.length; ++i) {
                        if (this.groupAssignments[i] == 3) continue;
                        vector.add(new Integer(i));
                    }
                    int[] nArray2 = new int[vector.size()];
                    for (int i = 0; i < nArray2.length; ++i) {
                        nArray2[i] = (Integer)vector.get(i);
                    }
                    object8 = this.getPermutedValues(this.numExps, nArray2);
                    object7 = this.getPermutedMatrix(this.expMatrix, (int[])object8);
                    double[] dArray6 = this.getTwoClassUnpairedTValues((FloatMatrix)object7);
                    dArray5[this.numGenes - 1][n3] = Double.isNaN(dArray6[nArray[this.numGenes - 1]]) ? Double.NEGATIVE_INFINITY : dArray6[nArray[this.numGenes - 1]];
                    for (int i = this.numGenes - 2; i >= 0; --i) {
                        dArray5[i][n3] = Double.isNaN(dArray6[nArray[i]]) ? dArray5[i + 1][n3] : Math.max(dArray5[i + 1][n3], dArray6[nArray[i]]);
                    }
                }
            } else {
                int n4;
                int[] nArray3 = new int[this.numExps];
                for (int i = 0; i < this.numExps; ++i) {
                    nArray3[i] = i;
                }
                object8 = new Vector();
                int n5 = 0;
                for (int i = 0; i < this.groupAssignments.length; ++i) {
                    if (this.groupAssignments[i] != 3) {
                        ((Vector)object8).add(new Integer(i));
                    }
                    if (this.groupAssignments[i] != 1) continue;
                    ++n5;
                }
                int[] nArray4 = new int[((Vector)object8).size()];
                for (int i = 0; i < nArray4.length; ++i) {
                    nArray4[i] = (Integer)((Vector)object8).get(i);
                }
                object7 = new int[n5];
                for (n4 = 0; n4 < ((int[])object7).length; ++n4) {
                    object7[n4] = -1;
                }
                n4 = nArray4.length - n5;
                int n6 = 0;
                while (Combinations.enumerateCombinations((int)nArray4.length, (int)n5, (int[])object7)) {
                    int n7;
                    if (this.stop) {
                        throw new AbortException();
                    }
                    algorithmEvent.setIntValue(n6);
                    algorithmEvent.setDescription("Permuting matrix: Current permutation = " + (n6 + 1));
                    this.fireValueChanged(algorithmEvent);
                    object6 = new int[n4];
                    int n8 = 0;
                    for (n7 = 0; n7 < nArray4.length; ++n7) {
                        if (this.belongsInArray(n7, (int[])object7)) continue;
                        object6[n8] = n7;
                        ++n8;
                    }
                    for (n7 = 0; n7 < ((int[])object7).length; ++n7) {
                        nArray3[nArray4[n7]] = nArray4[object7[n7]];
                    }
                    for (n7 = 0; n7 < ((int[])object6).length; ++n7) {
                        nArray3[nArray4[((int[])object7).length + n7]] = nArray4[object6[n7]];
                    }
                    FloatMatrix floatMatrix = this.getPermutedMatrix(this.expMatrix, nArray3);
                    object5 = this.getTwoClassUnpairedTValues(floatMatrix);
                    dArray5[this.numGenes - 1][n6] = Double.isNaN((double)object5[nArray[this.numGenes - 1]]) ? Double.NEGATIVE_INFINITY : (double)object5[nArray[this.numGenes - 1]];
                    for (int i = this.numGenes - 2; i >= 0; --i) {
                        dArray5[i][n6] = Double.isNaN((double)object5[nArray[i]]) ? dArray5[i + 1][n6] : Math.max(dArray5[i + 1][n6], (double)object5[nArray[i]]);
                    }
                    ++n6;
                }
            }
        } else if (this.tTestDesign == 8) {
            for (int i = 0; i < this.numGenes; ++i) {
                dArray[i] = Math.abs(this.getOneClassTValue(i));
            }
            qSort = new QSort(dArray, 2);
            dArray2 = qSort.getSortedDouble();
            nArray = qSort.getOrigIndx();
            if (!this.useAllCombs) {
                int n9;
                boolean[] blArray = new boolean[1];
                object8 = new Random();
                long[] lArray = new long[this.numCombs];
                for (n9 = 0; n9 < this.numCombs; ++n9) {
                    lArray[n9] = ((Random)object8).nextLong();
                }
                for (n9 = 0; n9 < this.numCombs; ++n9) {
                    if (this.stop) {
                        throw new AbortException();
                    }
                    algorithmEvent.setIntValue(n9);
                    algorithmEvent.setDescription("Permuting matrix: Current permutation = " + (n9 + 1));
                    this.fireValueChanged(algorithmEvent);
                    object7 = new int[1];
                    Vector<Integer> vector = new Vector<Integer>();
                    for (int i = 0; i < this.groupAssignments.length; ++i) {
                        if (this.groupAssignments[i] != 1) continue;
                        vector.add(new Integer(i));
                    }
                    int[] nArray5 = new int[vector.size()];
                    for (int i = 0; i < nArray5.length; ++i) {
                        nArray5[i] = (Integer)vector.get(i);
                    }
                    blArray = this.getOneClassChangeSignArray(lArray[n9], nArray5);
                    object6 = this.getOneClassPermMatrix(this.expMatrix, blArray);
                    double[] dArray7 = this.getOneClassTValues((FloatMatrix)object6);
                    dArray5[this.numGenes - 1][n9] = Double.isNaN(dArray7[nArray[this.numGenes - 1]]) ? Double.NEGATIVE_INFINITY : dArray7[nArray[this.numGenes - 1]];
                    for (int i = this.numGenes - 2; i >= 0; --i) {
                        dArray5[i][n9] = Double.isNaN(dArray7[nArray[i]]) ? dArray5[i + 1][n9] : Math.max(dArray5[i + 1][n9], dArray7[nArray[i]]);
                    }
                }
            } else {
                for (int i = 0; i < this.numCombs; ++i) {
                    if (this.stop) {
                        throw new AbortException();
                    }
                    algorithmEvent.setIntValue(i);
                    algorithmEvent.setDescription("Permuting matrix: Current permutation = " + (i + 1));
                    this.fireValueChanged(algorithmEvent);
                    object8 = new Vector<Integer>();
                    for (int j = 0; j < this.groupAssignments.length; ++j) {
                        if (this.groupAssignments[j] != 1) continue;
                        ((Vector)object8).add(new Integer(j));
                    }
                    int[] nArray6 = new int[((Vector)object8).size()];
                    for (int j = 0; j < nArray6.length; ++j) {
                        nArray6[j] = (Integer)((Vector)object8).get(j);
                    }
                    boolean[] blArray = this.getOneClassChangeSignArrayAllUniquePerms(i, nArray6);
                    object7 = this.getOneClassPermMatrix(this.expMatrix, blArray);
                    double[] dArray8 = this.getOneClassTValues((FloatMatrix)object7);
                    dArray5[this.numGenes - 1][i] = Double.isNaN(dArray8[nArray[this.numGenes - 1]]) ? Double.NEGATIVE_INFINITY : dArray8[nArray[this.numGenes - 1]];
                    for (int j = this.numGenes - 2; j >= 0; --j) {
                        dArray5[j][i] = Double.isNaN(dArray8[nArray[j]]) ? dArray5[j + 1][i] : Math.max(dArray5[j + 1][i], dArray8[nArray[j]]);
                    }
                }
            }
        }
        dArray3 = new double[this.numGenes];
        for (n2 = 0; n2 < this.numGenes; ++n2) {
            n3 = 0;
            for (int i = 0; i < this.numCombs; ++i) {
                if (!(dArray5[n2][i] >= dArray2[n2])) continue;
                ++n3;
            }
            dArray3[nArray[n2]] = (double)n3 / (double)this.numCombs;
        }
        n2 = 0;
        for (n3 = 0; n3 < this.numGenes; ++n3) {
            if (!Double.isNaN(dArray[n3])) continue;
            dArray3[n3] = Double.NaN;
            ++n2;
        }
        for (n3 = 1; n3 < this.numGenes - n2; ++n3) {
            dArray3[nArray[n3]] = Math.max(dArray3[nArray[n3]], dArray3[nArray[n3 - 1]]);
        }
        Vector vector = new Vector();
        Vector<Integer> vector2 = new Vector<Integer>();
        Vector<Integer> vector3 = new Vector<Integer>();
        for (int i = 0; i < this.numGenes; ++i) {
            if (Double.isNaN(dArray3[i])) {
                vector3.add(new Integer(i));
                continue;
            }
            if ((float)dArray3[i] <= this.alpha) {
                vector2.add(new Integer(i));
                continue;
            }
            vector3.add(new Integer(i));
        }
        vector.add(vector2);
        vector.add(vector3);
        this.k = vector.size();
        FloatMatrix floatMatrix = new FloatMatrix(this.numGenes, 1);
        for (n = 0; n < floatMatrix.getRowDimension(); ++n) {
            floatMatrix.A[n][0] = 0.0f;
        }
        for (n = 0; n < vector2.size(); ++n) {
            int n10 = (Integer)vector2.get(n);
            floatMatrix.A[n10][0] = 1.0f;
        }
        FloatMatrix floatMatrix2 = new FloatMatrix(this.numGenes, 1);
        FloatMatrix floatMatrix3 = new FloatMatrix(this.numGenes, 1);
        FloatMatrix floatMatrix4 = new FloatMatrix(this.numGenes, 1);
        object6 = new FloatMatrix(this.numGenes, 1);
        FloatMatrix floatMatrix5 = new FloatMatrix(this.numGenes, 1);
        FloatMatrix floatMatrix6 = new FloatMatrix(this.numGenes, 1);
        object5 = new FloatMatrix(this.numGenes, 1);
        FloatMatrix floatMatrix7 = new FloatMatrix(this.numGenes, 1);
        FloatMatrix floatMatrix8 = new FloatMatrix(this.numGenes, 1);
        if (this.tTestDesign == 7) {
            for (int i = 0; i < this.numGenes; ++i) {
                floatMatrix2.A[i][0] = (float)dArray[i];
                floatMatrix3.A[i][0] = (float)dArray3[i];
                floatMatrix4.A[i][0] = this.getDF(i);
            }
            Vector vector4 = this.getMeansAndSDs();
            object4 = (float[])vector4.get(0);
            object3 = (float[])vector4.get(1);
            object2 = (float[])vector4.get(2);
            object = (float[])vector4.get(3);
            for (int i = 0; i < this.numGenes; ++i) {
                object6.A[i][0] = object4[i];
                floatMatrix5.A[i][0] = (float)object3[i];
                floatMatrix6.A[i][0] = (float)object2[i];
                ((FloatMatrix)object5).A[i][0] = (float)object[i];
            }
        } else if (this.tTestDesign == 8) {
            for (int i = 0; i < this.numGenes; ++i) {
                object4 = this.getOneClassGeneValues(i);
                floatMatrix2.A[i][0] = (float)dArray[i];
                floatMatrix3.A[i][0] = (float)dArray3[i];
                floatMatrix4.A[i][0] = this.getOneClassDFValue((float[])object4);
                floatMatrix7.A[i][0] = this.getMean((float[])object4);
                floatMatrix8.A[i][0] = (float)Math.sqrt(this.getVar((float[])object4));
            }
        }
        this.clusters = new Vector[this.k];
        for (int i = 0; i < this.k; ++i) {
            this.clusters[i] = (Vector)vector.get(i);
        }
        FloatMatrix floatMatrix9 = this.getMeans(this.clusters);
        object4 = this.getVariances(this.clusters, floatMatrix9);
        object3 = null;
        if (this.hierarchical_tree) {
            object3 = new AlgorithmEvent(this, 1, this.clusters.length, "Calculate Hierarchical Trees");
            this.fireValueChanged((AlgorithmEvent)object3);
            ((AlgorithmEvent)object3).setIntValue(0);
            ((AlgorithmEvent)object3).setId(2);
            this.fireValueChanged((AlgorithmEvent)object3);
        }
        object2 = new Cluster();
        object = ((Cluster)object2).getNodeList();
        for (int i = 0; i < this.clusters.length; ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            int[] nArray7 = this.convert2int(this.clusters[i]);
            Node node = new Node(nArray7);
            ((NodeList)object).addNode(node);
            if (!this.hierarchical_tree) continue;
            node.setValues(this.calculateHierarchicalTree(nArray7, this.method_linkage, this.calculate_genes, this.calculate_experiments));
            ((AlgorithmEvent)object3).setIntValue(i + 1);
            this.fireValueChanged((AlgorithmEvent)object3);
        }
        AlgorithmData algorithmData = new AlgorithmData();
        algorithmData.addCluster("cluster", (Cluster)object2);
        algorithmData.addParam("number-of-clusters", String.valueOf(this.clusters.length));
        algorithmData.addMatrix("clusters_means", floatMatrix9);
        algorithmData.addMatrix("clusters_variances", (FloatMatrix)object4);
        algorithmData.addMatrix("pValues", floatMatrix3);
        algorithmData.addMatrix("tValues", floatMatrix2);
        algorithmData.addMatrix("dfValues", floatMatrix4);
        algorithmData.addMatrix("meansAMatrix", (FloatMatrix)object6);
        algorithmData.addMatrix("meansBMatrix", floatMatrix5);
        algorithmData.addMatrix("sdAMatrix", floatMatrix6);
        algorithmData.addMatrix("sdBMatrix", (FloatMatrix)object5);
        algorithmData.addMatrix("isSigMatrix", floatMatrix);
        algorithmData.addMatrix("oneClassMeansMatrix", floatMatrix7);
        algorithmData.addMatrix("oneClassSDsMatrix", floatMatrix8);
        return algorithmData;
    }

    public AlgorithmData executeMinP() throws AlgorithmException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n;
        int n2;
        int n3;
        Object object5;
        Object object6;
        double[] dArray = new double[this.numGenes];
        double[] dArray2 = new double[this.numGenes];
        double[] dArray3 = new double[this.numGenes];
        double[] dArray4 = new double[1];
        double[][] dArray5 = new double[this.numGenes][this.numCombs];
        double[][] dArray6 = new double[this.numGenes + 1][this.numCombs];
        double[][] dArray7 = new double[this.numGenes][this.numCombs];
        double[][] dArray8 = new double[this.numGenes][this.numCombs];
        int[] nArray = new int[1];
        for (int i = 0; i < this.numCombs; ++i) {
            dArray6[this.numGenes][i] = 1.0;
        }
        AlgorithmEvent algorithmEvent = new AlgorithmEvent(this, 1, this.numCombs);
        this.fireValueChanged(algorithmEvent);
        algorithmEvent.setId(2);
        if (this.tTestDesign == 7) {
            int n4;
            Object object7;
            int[] nArray2;
            Object object8;
            int n5;
            for (n5 = 0; n5 < this.numGenes; ++n5) {
                dArray[n5] = Math.abs(this.getTValue(n5));
            }
            if (!this.useAllCombs) {
                for (n5 = 0; n5 < this.numCombs; ++n5) {
                    if (this.stop) {
                        throw new AbortException();
                    }
                    algorithmEvent.setIntValue(n5);
                    algorithmEvent.setDescription("Permuting matrix: Current permutation = " + (n5 + 1));
                    this.fireValueChanged(algorithmEvent);
                    object8 = new int[1];
                    Vector<Integer> vector = new Vector<Integer>();
                    for (int i = 0; i < this.groupAssignments.length; ++i) {
                        if (this.groupAssignments[i] == 3) continue;
                        vector.add(new Integer(i));
                    }
                    nArray2 = new int[vector.size()];
                    for (int i = 0; i < nArray2.length; ++i) {
                        nArray2[i] = (Integer)vector.get(i);
                    }
                    object8 = this.getPermutedValues(this.numExps, nArray2);
                    object7 = this.getPermutedMatrix(this.expMatrix, (int[])object8);
                    double[] dArray9 = this.getTwoClassUnpairedTValues((FloatMatrix)object7);
                    for (n4 = 0; n4 < this.numGenes; ++n4) {
                        dArray5[n4][n5] = dArray9[n4];
                    }
                }
            } else {
                int n6;
                int[] nArray3 = new int[this.numExps];
                for (int i = 0; i < this.numExps; ++i) {
                    nArray3[i] = i;
                }
                object8 = new Vector();
                int n7 = 0;
                for (int i = 0; i < this.groupAssignments.length; ++i) {
                    if (this.groupAssignments[i] != 3) {
                        ((Vector)object8).add(new Integer(i));
                    }
                    if (this.groupAssignments[i] != 1) continue;
                    ++n7;
                }
                nArray2 = new int[((Vector)object8).size()];
                for (int i = 0; i < nArray2.length; ++i) {
                    nArray2[i] = (Integer)((Vector)object8).get(i);
                }
                object7 = new int[n7];
                for (n6 = 0; n6 < ((int[])object7).length; ++n6) {
                    object7[n6] = -1;
                }
                n6 = nArray2.length - n7;
                n4 = 0;
                while (Combinations.enumerateCombinations((int)nArray2.length, (int)n7, (int[])object7)) {
                    int n8;
                    if (this.stop) {
                        throw new AbortException();
                    }
                    algorithmEvent.setIntValue(n4);
                    algorithmEvent.setDescription("Permuting matrix: Current permutation = " + (n4 + 1));
                    this.fireValueChanged(algorithmEvent);
                    object6 = new int[n6];
                    int n9 = 0;
                    for (n8 = 0; n8 < nArray2.length; ++n8) {
                        if (this.belongsInArray(n8, (int[])object7)) continue;
                        object6[n9] = n8;
                        ++n9;
                    }
                    for (n8 = 0; n8 < ((int[])object7).length; ++n8) {
                        nArray3[nArray2[n8]] = nArray2[object7[n8]];
                    }
                    for (n8 = 0; n8 < ((int[])object6).length; ++n8) {
                        nArray3[nArray2[((int[])object7).length + n8]] = nArray2[object6[n8]];
                    }
                    FloatMatrix floatMatrix = this.getPermutedMatrix(this.expMatrix, nArray3);
                    double[] dArray10 = this.getTwoClassUnpairedTValues(floatMatrix);
                    for (int i = 0; i < this.numGenes; ++i) {
                        dArray5[i][n4] = dArray10[i];
                    }
                    ++n4;
                }
            }
            for (int i = 0; i < this.numGenes; ++i) {
                double d = this.getTValue(i);
                if (Double.isNaN(d)) {
                    dArray2[i] = Double.NaN;
                    continue;
                }
                int n10 = 0;
                for (int j = 0; j < this.numCombs; ++j) {
                    if (!(dArray5[i][j] >= d)) continue;
                    ++n10;
                }
                dArray2[i] = (double)n10 / (double)this.numCombs;
            }
            object5 = new QSort(dArray2, 1);
            dArray4 = object5.getSortedDouble();
            nArray = object5.getOrigIndx();
            for (n3 = 0; n3 < this.numGenes; ++n3) {
                for (int i = 0; i < this.numCombs; ++i) {
                    dArray7[n3][i] = dArray5[nArray[n3]][i];
                }
            }
        } else if (this.tTestDesign == 8) {
            Object object9;
            Object object10;
            Object[] objectArray;
            Serializable serializable;
            int n11;
            for (n11 = 0; n11 < this.numGenes; ++n11) {
                dArray[n11] = Math.abs(this.getOneClassTValue(n11));
            }
            if (!this.useAllCombs) {
                int n12;
                boolean[] blArray = new boolean[1];
                serializable = new Random();
                objectArray = new long[this.numCombs];
                for (n12 = 0; n12 < this.numCombs; ++n12) {
                    objectArray[n12] = ((Random)serializable).nextLong();
                }
                for (n12 = 0; n12 < this.numCombs; ++n12) {
                    if (this.stop) {
                        throw new AbortException();
                    }
                    algorithmEvent.setIntValue(n12);
                    algorithmEvent.setDescription("Permuting matrix: Current permutation = " + (n12 + 1));
                    this.fireValueChanged(algorithmEvent);
                    object10 = new int[1];
                    object9 = new Vector();
                    for (int i = 0; i < this.groupAssignments.length; ++i) {
                        if (this.groupAssignments[i] != 1) continue;
                        ((Vector)object9).add(new Integer(i));
                    }
                    int[] nArray4 = new int[((Vector)object9).size()];
                    for (int i = 0; i < nArray4.length; ++i) {
                        nArray4[i] = (Integer)((Vector)object9).get(i);
                    }
                    blArray = this.getOneClassChangeSignArray(objectArray[n12], nArray4);
                    object6 = this.getOneClassPermMatrix(this.expMatrix, blArray);
                    double[] dArray11 = this.getOneClassTValues((FloatMatrix)object6);
                    for (int i = 0; i < this.numGenes; ++i) {
                        dArray5[i][n12] = dArray11[i];
                    }
                }
            } else {
                for (n11 = 0; n11 < this.numCombs; ++n11) {
                    if (this.stop) {
                        throw new AbortException();
                    }
                    algorithmEvent.setIntValue(n11);
                    algorithmEvent.setDescription("Permuting matrix: Current permutation = " + (n11 + 1));
                    this.fireValueChanged(algorithmEvent);
                    serializable = new Vector();
                    for (int i = 0; i < this.groupAssignments.length; ++i) {
                        if (this.groupAssignments[i] != 1) continue;
                        ((Vector)serializable).add(new Integer(i));
                    }
                    objectArray = new int[((Vector)serializable).size()];
                    for (int i = 0; i < objectArray.length; ++i) {
                        objectArray[i] = ((Integer)((Vector)serializable).get(i)).intValue();
                    }
                    boolean[] blArray = this.getOneClassChangeSignArrayAllUniquePerms(n11, (int[])objectArray);
                    object10 = this.getOneClassPermMatrix(this.expMatrix, blArray);
                    object9 = this.getOneClassTValues((FloatMatrix)object10);
                    for (int i = 0; i < this.numGenes; ++i) {
                        dArray5[i][n11] = (double)object9[i];
                    }
                }
            }
            for (int i = 0; i < this.numGenes; ++i) {
                double d = this.getOneClassTValue(i);
                if (Double.isNaN(d)) {
                    dArray2[i] = Double.NaN;
                    continue;
                }
                int n13 = 0;
                for (int j = 0; j < this.numCombs; ++j) {
                    if (!(dArray5[i][j] >= d)) continue;
                    ++n13;
                }
                dArray2[i] = (double)n13 / (double)this.numCombs;
            }
            object5 = new QSort(dArray2, 1);
            dArray4 = object5.getSortedDouble();
            nArray = object5.getOrigIndx();
            for (n3 = 0; n3 < this.numGenes; ++n3) {
                for (int i = 0; i < this.numCombs; ++i) {
                    dArray7[n3][i] = dArray5[nArray[n3]][i];
                }
            }
        }
        object5 = new double[this.numGenes];
        n3 = 0;
        AlgorithmEvent algorithmEvent2 = new AlgorithmEvent(this, 1, this.numGenes);
        this.fireValueChanged(algorithmEvent2);
        algorithmEvent2.setId(2);
        for (n2 = this.numGenes - 1; n2 >= 0; --n2) {
            int n14;
            algorithmEvent2.setIntValue(n3);
            algorithmEvent2.setDescription("Calculating p-values: Current gene = " + (n2 + 1));
            this.fireValueChanged(algorithmEvent2);
            double[] dArray12 = new double[this.numCombs];
            for (int i = 0; i < this.numCombs; ++i) {
                dArray12[i] = dArray7[n2][i];
            }
            QSort qSort = new QSort(dArray12, 2);
            double[] dArray13 = qSort.getSortedDouble();
            object6 = qSort.getOrigIndx();
            double[] dArray14 = this.getPValsFromOrderStats(dArray13);
            for (n14 = 0; n14 < dArray8[n2].length; ++n14) {
                dArray8[n2][n14] = dArray14[object6[n14]];
            }
            for (n14 = 0; n14 < dArray6[n2].length; ++n14) {
                dArray6[n2][n14] = Math.min(dArray6[n2 + 1][n14], dArray8[n2][n14]);
            }
            n14 = 0;
            for (int i = 0; i < dArray6[n2].length; ++i) {
                if (!(dArray6[n2][i] <= dArray4[n2])) continue;
                ++n14;
            }
            object5[n2] = (double)n14 / (double)this.numCombs;
            ++n3;
        }
        for (n2 = 1; n2 < ((double[])object5).length; ++n2) {
            object5[n2] = Math.max(object5[n2 - 1], object5[n2]);
        }
        for (n2 = 0; n2 < ((double[])object5).length; ++n2) {
            dArray3[n2] = object5[nArray[n2]];
            if (!Double.isNaN(dArray2[n2])) continue;
            dArray3[n2] = Double.NaN;
        }
        Vector vector = new Vector();
        Vector<Integer> vector2 = new Vector<Integer>();
        Vector<Integer> vector3 = new Vector<Integer>();
        for (int i = 0; i < this.numGenes; ++i) {
            if (Double.isNaN(dArray3[i])) {
                vector3.add(new Integer(i));
                continue;
            }
            if ((float)dArray3[i] <= this.alpha) {
                vector2.add(new Integer(i));
                continue;
            }
            vector3.add(new Integer(i));
        }
        vector.add(vector2);
        vector.add(vector3);
        this.k = vector.size();
        FloatMatrix floatMatrix = new FloatMatrix(this.numGenes, 1);
        for (n = 0; n < floatMatrix.getRowDimension(); ++n) {
            floatMatrix.A[n][0] = 0.0f;
        }
        for (n = 0; n < vector2.size(); ++n) {
            int n15 = (Integer)vector2.get(n);
            floatMatrix.A[n15][0] = 1.0f;
        }
        FloatMatrix floatMatrix2 = new FloatMatrix(this.numGenes, 1);
        FloatMatrix floatMatrix3 = new FloatMatrix(this.numGenes, 1);
        FloatMatrix floatMatrix4 = new FloatMatrix(this.numGenes, 1);
        FloatMatrix floatMatrix5 = new FloatMatrix(this.numGenes, 1);
        FloatMatrix floatMatrix6 = new FloatMatrix(this.numGenes, 1);
        FloatMatrix floatMatrix7 = new FloatMatrix(this.numGenes, 1);
        FloatMatrix floatMatrix8 = new FloatMatrix(this.numGenes, 1);
        FloatMatrix floatMatrix9 = new FloatMatrix(this.numGenes, 1);
        FloatMatrix floatMatrix10 = new FloatMatrix(this.numGenes, 1);
        if (this.tTestDesign == 7) {
            for (int i = 0; i < this.numGenes; ++i) {
                floatMatrix2.A[i][0] = (float)dArray[i];
                floatMatrix3.A[i][0] = (float)dArray3[i];
                floatMatrix4.A[i][0] = this.getDF(i);
            }
            Vector vector4 = this.getMeansAndSDs();
            object4 = (float[])vector4.get(0);
            object3 = (float[])vector4.get(1);
            object2 = (float[])vector4.get(2);
            object = (float[])vector4.get(3);
            for (int i = 0; i < this.numGenes; ++i) {
                floatMatrix5.A[i][0] = object4[i];
                floatMatrix6.A[i][0] = (float)object3[i];
                floatMatrix7.A[i][0] = (float)object2[i];
                floatMatrix8.A[i][0] = (float)object[i];
            }
        } else if (this.tTestDesign == 8) {
            for (int i = 0; i < this.numGenes; ++i) {
                object4 = this.getOneClassGeneValues(i);
                floatMatrix2.A[i][0] = (float)dArray[i];
                floatMatrix3.A[i][0] = (float)dArray3[i];
                floatMatrix4.A[i][0] = this.getOneClassDFValue((float[])object4);
                floatMatrix9.A[i][0] = this.getMean((float[])object4);
                floatMatrix10.A[i][0] = (float)Math.sqrt(this.getVar((float[])object4));
            }
        }
        this.clusters = new Vector[this.k];
        for (int i = 0; i < this.k; ++i) {
            this.clusters[i] = (Vector)vector.get(i);
        }
        FloatMatrix floatMatrix11 = this.getMeans(this.clusters);
        object4 = this.getVariances(this.clusters, floatMatrix11);
        object3 = null;
        if (this.hierarchical_tree) {
            object3 = new AlgorithmEvent(this, 1, this.clusters.length, "Calculate Hierarchical Trees");
            this.fireValueChanged((AlgorithmEvent)object3);
            ((AlgorithmEvent)object3).setIntValue(0);
            ((AlgorithmEvent)object3).setId(2);
            this.fireValueChanged((AlgorithmEvent)object3);
        }
        object2 = new Cluster();
        object = ((Cluster)object2).getNodeList();
        for (int i = 0; i < this.clusters.length; ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            int[] nArray5 = this.convert2int(this.clusters[i]);
            Node node = new Node(nArray5);
            ((NodeList)object).addNode(node);
            if (!this.hierarchical_tree) continue;
            node.setValues(this.calculateHierarchicalTree(nArray5, this.method_linkage, this.calculate_genes, this.calculate_experiments));
            ((AlgorithmEvent)object3).setIntValue(i + 1);
            this.fireValueChanged((AlgorithmEvent)object3);
        }
        AlgorithmData algorithmData = new AlgorithmData();
        algorithmData.addCluster("cluster", (Cluster)object2);
        algorithmData.addParam("number-of-clusters", String.valueOf(this.clusters.length));
        algorithmData.addMatrix("clusters_means", floatMatrix11);
        algorithmData.addMatrix("clusters_variances", (FloatMatrix)object4);
        algorithmData.addMatrix("pValues", floatMatrix3);
        algorithmData.addMatrix("tValues", floatMatrix2);
        algorithmData.addMatrix("dfValues", floatMatrix4);
        algorithmData.addMatrix("meansAMatrix", floatMatrix5);
        algorithmData.addMatrix("meansBMatrix", floatMatrix6);
        algorithmData.addMatrix("sdAMatrix", floatMatrix7);
        algorithmData.addMatrix("sdBMatrix", floatMatrix8);
        algorithmData.addMatrix("isSigMatrix", floatMatrix);
        algorithmData.addMatrix("oneClassMeansMatrix", floatMatrix9);
        algorithmData.addMatrix("oneClassSDsMatrix", floatMatrix10);
        return algorithmData;
    }

    public void abort() {
        this.stop = true;
    }

    private double[] getPValsFromOrderStats(double[] dArray) {
        int n;
        int n2;
        int n3;
        int n4;
        double[] dArray2 = new double[dArray.length];
        int[] nArray = new int[dArray.length];
        if (Double.isNaN(dArray[0])) {
            for (int i = 0; i < dArray2.length; ++i) {
                dArray2[i] = Double.NaN;
            }
            return dArray2;
        }
        Vector<Integer> vector = new Vector<Integer>();
        Vector<Integer> vector2 = new Vector<Integer>();
        vector.add(new Integer(1));
        nArray[0] = 1;
        for (n4 = 1; n4 < dArray.length; ++n4) {
            if (Double.isNaN(dArray[n4])) {
                nArray[n4] = -1;
                continue;
            }
            if (dArray[n4 - 1] > dArray[n4]) {
                nArray[n4] = nArray[n4 - 1] + 1;
                vector.add(new Integer(nArray[n4 - 1] + 1));
                continue;
            }
            nArray[n4] = nArray[n4 - 1];
        }
        n4 = 0;
        for (int i = 0; i < vector.size(); ++i) {
            n3 = (Integer)vector.get(i);
            n2 = 0;
            for (n = n4; n < nArray.length; ++n) {
                if (n3 == nArray[n]) {
                    ++n2;
                    ++n4;
                    continue;
                }
                vector2.add(new Integer(n2));
                break;
            }
            if (i != vector.size() - 1) continue;
            vector2.add(new Integer(n2));
        }
        int[] nArray2 = new int[nArray.length];
        n3 = 0;
        n2 = 0;
        for (n = 0; n < vector.size(); ++n) {
            n3 += ((Integer)vector2.get(n)).intValue();
            for (int i = n2; i < n3; ++i) {
                nArray2[i] = n3;
                ++n2;
            }
        }
        for (n = 0; n < nArray2.length; ++n) {
            dArray2[n] = Double.isNaN(dArray[n]) ? Double.NaN : (double)nArray2[n] / (double)this.numCombs;
        }
        return dArray2;
    }

    private double[] getTwoClassUnpairedTValues(FloatMatrix floatMatrix) {
        double[] dArray = new double[this.numGenes];
        for (int i = 0; i < this.numGenes; ++i) {
            dArray[i] = Math.abs(this.getTValue(i, floatMatrix));
        }
        return dArray;
    }

    private FloatMatrix getPermutedMatrix(FloatMatrix floatMatrix, int[] nArray) {
        FloatMatrix floatMatrix2 = new FloatMatrix(floatMatrix.getRowDimension(), floatMatrix.getColumnDimension());
        for (int i = 0; i < floatMatrix.getRowDimension(); ++i) {
            for (int j = 0; j < floatMatrix.getColumnDimension(); ++j) {
                floatMatrix2.A[i][j] = floatMatrix.A[i][nArray[j]];
            }
        }
        return floatMatrix2;
    }

    private FloatMatrix getOrderedByTMatrix(FloatMatrix floatMatrix, int[] nArray) {
        FloatMatrix floatMatrix2 = new FloatMatrix(floatMatrix.getRowDimension(), floatMatrix.getColumnDimension());
        for (int i = 0; i < floatMatrix.getRowDimension(); ++i) {
            for (int j = 0; j < floatMatrix.getColumnDimension(); ++j) {
                floatMatrix2.A[i][j] = floatMatrix.A[nArray[i]][j];
            }
        }
        return floatMatrix2;
    }

    private int[] getPermutedValues(int n, int[] nArray) {
        int n2;
        int[] nArray2 = new int[n];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = i;
        }
        int[] nArray3 = new int[nArray.length];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray3[n2] = nArray[n2];
        }
        for (n2 = nArray3.length; n2 > 1; --n2) {
            Random random = new Random();
            int n3 = random.nextInt(n2 - 1);
            int n4 = nArray3[n3];
            nArray3[n3] = nArray3[n2 - 1];
            nArray3[n2 - 1] = n4;
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray2[nArray[n2]] = nArray3[n2];
        }
        try {
            Thread.sleep(10L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return nArray2;
    }

    private NodeValueList calculateHierarchicalTree(int[] nArray, int n, boolean bl, boolean bl2) throws AlgorithmException {
        AlgorithmData algorithmData;
        NodeValueList nodeValueList = new NodeValueList();
        AlgorithmData algorithmData2 = new AlgorithmData();
        FloatMatrix floatMatrix = this.getSubExperiment(this.expMatrix, nArray);
        algorithmData2.addMatrix("experiment", floatMatrix);
        algorithmData2.addParam("distance-function", String.valueOf(this.function));
        algorithmData2.addParam("distance-absolute", String.valueOf(this.absolute));
        algorithmData2.addParam("method-linkage", String.valueOf(n));
        HCL hCL = new HCL();
        if (bl) {
            algorithmData2.addParam("calculate-genes", String.valueOf(true));
            algorithmData = hCL.execute(algorithmData2);
            this.validate(algorithmData);
            this.addNodeValues(nodeValueList, algorithmData);
        }
        if (bl2) {
            algorithmData2.addParam("calculate-genes", String.valueOf(false));
            algorithmData = hCL.execute(algorithmData2);
            this.validate(algorithmData);
            this.addNodeValues(nodeValueList, algorithmData);
        }
        return nodeValueList;
    }

    private void addNodeValues(NodeValueList nodeValueList, AlgorithmData algorithmData) {
        nodeValueList.addNodeValue(new NodeValue("child-1-array", algorithmData.getIntArray("child-1-array")));
        nodeValueList.addNodeValue(new NodeValue("child-2-array", algorithmData.getIntArray("child-2-array")));
        nodeValueList.addNodeValue(new NodeValue("node-order", algorithmData.getIntArray("node-order")));
        nodeValueList.addNodeValue(new NodeValue("height", algorithmData.getMatrix("height").getRowPackedCopy()));
    }

    private FloatMatrix getSubExperiment(FloatMatrix floatMatrix, int[] nArray) {
        FloatMatrix floatMatrix2 = new FloatMatrix(nArray.length, floatMatrix.getColumnDimension());
        for (int i = 0; i < nArray.length; ++i) {
            floatMatrix2.A[i] = floatMatrix.A[nArray[i]];
        }
        return floatMatrix2;
    }

    private void validate(AlgorithmData algorithmData) throws AlgorithmException {
        if (algorithmData.getIntArray("child-1-array") == null) {
            throw new AlgorithmException("parameter 'child-1-array' is null");
        }
        if (algorithmData.getIntArray("child-2-array") == null) {
            throw new AlgorithmException("parameter 'child-2-array' is null");
        }
        if (algorithmData.getIntArray("node-order") == null) {
            throw new AlgorithmException("parameter 'node-order' is null");
        }
        if (algorithmData.getMatrix("height") == null) {
            throw new AlgorithmException("parameter 'height' is null");
        }
    }

    private int[] convert2int(Vector vector) {
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)vector.get(i);
        }
        return nArray;
    }

    private FloatMatrix getMeans(Vector[] vectorArray) {
        FloatMatrix floatMatrix = new FloatMatrix(vectorArray.length, this.numExps);
        for (int i = 0; i < vectorArray.length; ++i) {
            FloatMatrix floatMatrix2 = this.getMean(vectorArray[i]);
            floatMatrix.A[i] = floatMatrix2.A[0];
        }
        return floatMatrix;
    }

    private FloatMatrix getMean(Vector vector) {
        FloatMatrix floatMatrix = new FloatMatrix(1, this.numExps);
        int n = vector.size();
        int n2 = 0;
        for (int i = 0; i < this.numExps; ++i) {
            float f = 0.0f;
            n2 = 0;
            for (int j = 0; j < n; ++j) {
                float f2 = this.expMatrix.get((Integer)vector.get(j), i);
                if (Float.isNaN(f2)) continue;
                f += f2;
                ++n2;
            }
            floatMatrix.set(0, i, f / (float)n2);
        }
        return floatMatrix;
    }

    private FloatMatrix getVariances(Vector[] vectorArray, FloatMatrix floatMatrix) {
        int n = floatMatrix.getRowDimension();
        int n2 = floatMatrix.getColumnDimension();
        FloatMatrix floatMatrix2 = new FloatMatrix(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                floatMatrix2.set(i, j, this.getSampleVariance(vectorArray[i], j, floatMatrix.get(i, j)));
            }
        }
        return floatMatrix2;
    }

    private float getSampleNormalizedSum(Vector vector, int n, float f) {
        int n2 = vector.size();
        float f2 = 0.0f;
        this.validN = 0;
        for (int i = 0; i < n2; ++i) {
            float f3 = this.expMatrix.get((Integer)vector.get(i), n);
            if (Float.isNaN(f3)) continue;
            f2 = (float)((double)f2 + Math.pow(f3 - f, 2.0));
            ++this.validN;
        }
        return f2;
    }

    private float getSampleVariance(Vector vector, int n, float f) {
        return (float)Math.sqrt(this.getSampleNormalizedSum(vector, n, f) / (float)(this.validN - 1));
    }

    private Vector sortGenesForOneClassDesign() throws AlgorithmException {
        Vector<Integer> vector = new Vector<Integer>();
        Vector<Integer> vector2 = new Vector<Integer>();
        AlgorithmEvent algorithmEvent = new AlgorithmEvent(this, 1, this.numGenes);
        this.fireValueChanged(algorithmEvent);
        algorithmEvent.setId(2);
        this.pValuesVector = new Vector();
        if (!this.isPermut) {
            if (this.significanceMethod == 4 || this.significanceMethod == 5) {
                for (int i = 0; i < this.numGenes; ++i) {
                    if (this.stop) {
                        throw new AbortException();
                    }
                    algorithmEvent.setIntValue(i);
                    algorithmEvent.setDescription("Current gene = " + (i + 1));
                    this.fireValueChanged(algorithmEvent);
                    if (this.isSigOneClass(i)) {
                        vector.add(new Integer(i));
                        continue;
                    }
                    vector2.add(new Integer(i));
                }
            } else if (this.significanceMethod == 6) {
                int n;
                float[] fArray = new float[this.numGenes];
                for (n = 0; n < this.numGenes; ++n) {
                    float f;
                    if (this.stop) {
                        throw new AbortException();
                    }
                    algorithmEvent.setIntValue(n);
                    algorithmEvent.setDescription("Current gene = " + (n + 1));
                    this.fireValueChanged(algorithmEvent);
                    float[] fArray2 = this.getOneClassGeneValues(n);
                    float f2 = (float)this.getOneClassTValue(fArray2);
                    float f3 = this.getOneClassDFValue(fArray2);
                    fArray[n] = f = this.getProb(f2, (int)f3);
                }
                for (n = 0; n < fArray.length; ++n) {
                    this.pValuesVector.add(new Float(fArray[n]));
                }
                n = this.numGenes;
                double d = (double)this.alpha / (double)n;
                QSort qSort = new QSort(fArray);
                float[] fArray3 = qSort.getSorted();
                int[] nArray = qSort.getOrigIndx();
                for (int i = fArray3.length - 1; i >= 0; --i) {
                    if ((double)fArray3[i] <= d) {
                        vector.add(new Integer(nArray[i]));
                    } else {
                        vector2.add(new Integer(nArray[i]));
                    }
                    if (i < fArray3.length - 1) {
                        if (fArray3[i] < fArray3[i + 1] && --n < 1) {
                            System.out.println("Warning: denomAlpha = " + n);
                        }
                    } else if (n < 1) {
                        System.out.println("Warning: denomAlpha = " + n);
                    }
                    d = this.alpha / (float)n;
                }
            }
        } else if (this.useAllCombs) {
            if (this.significanceMethod == 4 || this.significanceMethod == 5) {
                for (int i = 0; i < this.numGenes; ++i) {
                    float f;
                    if (this.stop) {
                        throw new AbortException();
                    }
                    algorithmEvent.setIntValue(i);
                    algorithmEvent.setDescription("Current gene = " + (i + 1));
                    this.fireValueChanged(algorithmEvent);
                    if (this.significanceMethod == 4) {
                        f = this.getAllCombsOneClassProb(i);
                        this.pValuesVector.add(new Float(f));
                        if (f <= this.alpha) {
                            vector.add(new Integer(i));
                            continue;
                        }
                        vector2.add(new Integer(i));
                        continue;
                    }
                    if (this.significanceMethod != 5) continue;
                    f = this.getAllCombsOneClassProb(i);
                    this.pValuesVector.add(new Float(f));
                    float f4 = (float)((double)this.alpha / (double)this.numGenes);
                    if (f <= f4) {
                        vector.add(new Integer(i));
                        continue;
                    }
                    vector2.add(new Integer(i));
                }
            } else if (this.significanceMethod == 6) {
                int n;
                float[] fArray = new float[this.numGenes];
                for (n = 0; n < this.numGenes; ++n) {
                    if (this.stop) {
                        throw new AbortException();
                    }
                    algorithmEvent.setIntValue(n);
                    algorithmEvent.setDescription("Current gene = " + (n + 1));
                    this.fireValueChanged(algorithmEvent);
                    fArray[n] = this.getAllCombsOneClassProb(n);
                }
                for (n = 0; n < fArray.length; ++n) {
                    this.pValuesVector.add(new Float(fArray[n]));
                }
                n = this.numGenes;
                double d = (double)this.alpha / (double)n;
                QSort qSort = new QSort(fArray);
                float[] fArray4 = qSort.getSorted();
                int[] nArray = qSort.getOrigIndx();
                for (int i = fArray4.length - 1; i >= 0; --i) {
                    if ((double)fArray4[i] <= d) {
                        vector.add(new Integer(nArray[i]));
                    } else {
                        vector2.add(new Integer(nArray[i]));
                    }
                    if (i < fArray4.length - 1) {
                        if (fArray4[i] < fArray4[i + 1] && --n < 1) {
                            System.out.println("Warning: denomAlpha = " + n);
                        }
                    } else if (n < 1) {
                        System.out.println("Warning: denomAlpha = " + n);
                    }
                    d = this.alpha / (float)n;
                }
            }
        } else if (this.significanceMethod == 4 || this.significanceMethod == 5) {
            for (int i = 0; i < this.numGenes; ++i) {
                if (this.stop) {
                    throw new AbortException();
                }
                algorithmEvent.setIntValue(i);
                algorithmEvent.setDescription("Current gene = " + (i + 1));
                this.fireValueChanged(algorithmEvent);
                float f = this.getSomeCombsOneClassProb(i);
                this.pValuesVector.add(new Float(f));
                if (this.significanceMethod == 4) {
                    if (f <= this.alpha) {
                        vector.add(new Integer(i));
                        continue;
                    }
                    vector2.add(new Integer(i));
                    continue;
                }
                if (this.significanceMethod != 5) continue;
                float f5 = (float)((double)this.alpha / (double)this.numGenes);
                if (f <= f5) {
                    vector.add(new Integer(i));
                    continue;
                }
                vector2.add(new Integer(i));
            }
        } else if (this.significanceMethod == 6) {
            int n;
            float[] fArray = new float[this.numGenes];
            for (n = 0; n < this.numGenes; ++n) {
                if (this.stop) {
                    throw new AbortException();
                }
                algorithmEvent.setIntValue(n);
                algorithmEvent.setDescription("Current gene = " + (n + 1));
                this.fireValueChanged(algorithmEvent);
                fArray[n] = this.getSomeCombsOneClassProb(n);
            }
            for (n = 0; n < fArray.length; ++n) {
                this.pValuesVector.add(new Float(fArray[n]));
            }
            n = this.numGenes;
            double d = (double)this.alpha / (double)n;
            QSort qSort = new QSort(fArray);
            float[] fArray5 = qSort.getSorted();
            int[] nArray = qSort.getOrigIndx();
            for (int i = fArray5.length - 1; i >= 0; --i) {
                if ((double)fArray5[i] <= d) {
                    vector.add(new Integer(nArray[i]));
                } else {
                    vector2.add(new Integer(nArray[i]));
                }
                if (i < fArray5.length - 1) {
                    if (fArray5[i] < fArray5[i + 1] && --n < 1) {
                        System.out.println("Warning: denomAlpha = " + n);
                    }
                } else if (n < 1) {
                    System.out.println("Warning: denomAlpha = " + n);
                }
                d = this.alpha / (float)n;
            }
        }
        Vector<Vector<Integer>> vector3 = new Vector<Vector<Integer>>();
        vector3.add(vector);
        vector3.add(vector2);
        return vector3;
    }

    private float getSomeCombsOneClassProb(int n) {
        int n2;
        int n3 = this.getNumValidOneClassExpts();
        float[] fArray = this.expMatrix.A[n];
        float[] fArray2 = this.getOneClassGeneValues(n);
        float f = (float)Math.abs(this.getOneClassTValue(fArray2));
        if (Float.isNaN(f)) {
            return Float.NaN;
        }
        Random random = new Random();
        long[] lArray = new long[this.numCombs];
        for (n2 = 0; n2 < this.numCombs; ++n2) {
            lArray[n2] = random.nextLong();
        }
        n2 = 0;
        for (int i = 0; i < this.numCombs; ++i) {
            boolean[] blArray = this.getSomeCombsPermutArray(lArray[i]);
            float[] fArray3 = new float[fArray2.length];
            for (int j = 0; j < blArray.length; ++j) {
                fArray3[j] = blArray[j] ? fArray2[j] - 2.0f * (fArray2[j] - this.oneClassMean) : fArray2[j];
            }
            double d = Math.abs(this.getOneClassTValue(fArray3));
            if (!(d > (double)f)) continue;
            ++n2;
        }
        double d = (double)n2 / (double)this.numCombs;
        return (float)d;
    }

    private boolean[] getSomeCombsPermutArray(long l) {
        boolean[] blArray = new boolean[this.getNumValidOneClassExpts()];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = false;
        }
        Random random = new Random(l);
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = random.nextBoolean();
        }
        return blArray;
    }

    private float getAllCombsOneClassProb(int n) {
        int n2 = this.getNumValidOneClassExpts();
        int n3 = (int)Math.pow(2.0, n2);
        float[] fArray = this.expMatrix.A[n];
        float[] fArray2 = this.getOneClassGeneValues(n);
        float f = (float)Math.abs(this.getOneClassTValue(fArray2));
        if (Float.isNaN(f)) {
            return Float.NaN;
        }
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            boolean[] blArray = this.getOneClassPermutArray(i);
            float[] fArray3 = new float[fArray.length];
            for (int j = 0; j < blArray.length; ++j) {
                fArray3[j] = blArray[j] ? fArray[j] - 2.0f * (fArray[j] - this.oneClassMean) : fArray[j];
            }
            float[] fArray4 = new float[n2];
            int n5 = 0;
            for (int j = 0; j < this.groupAssignments.length; ++j) {
                if (this.groupAssignments[j] != 1) continue;
                fArray4[n5] = fArray3[j];
                ++n5;
            }
            double d = Math.abs(this.getOneClassTValue(fArray4));
            if (!(d > (double)f)) continue;
            ++n4;
        }
        double d = (double)n4 / (double)n3;
        return (float)d;
    }

    private boolean[] getOneClassChangeSignArray(long l, int[] nArray) {
        boolean[] blArray = new boolean[this.numExps];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = false;
        }
        Random random = new Random(l);
        for (int i = 0; i < nArray.length; ++i) {
            blArray[nArray[i]] = random.nextBoolean();
        }
        return blArray;
    }

    private FloatMatrix getOneClassPermMatrix(FloatMatrix floatMatrix, boolean[] blArray) {
        FloatMatrix floatMatrix2 = new FloatMatrix(floatMatrix.getRowDimension(), floatMatrix.getColumnDimension());
        for (int i = 0; i < floatMatrix.getRowDimension(); ++i) {
            for (int j = 0; j < floatMatrix.getColumnDimension(); ++j) {
                floatMatrix2.A[i][j] = blArray[j] ? floatMatrix.A[i][j] - 2.0f * (floatMatrix.A[i][j] - this.oneClassMean) : floatMatrix.A[i][j];
            }
        }
        return floatMatrix2;
    }

    private boolean[] getOneClassChangeSignArrayAllUniquePerms(int n, int[] nArray) {
        int n2;
        boolean[] blArray = new boolean[this.numExps];
        for (n2 = 0; n2 < blArray.length; ++n2) {
            blArray[n2] = false;
        }
        n2 = nArray.length;
        String string = Integer.toBinaryString(n);
        char[] cArray = string.toCharArray();
        if (cArray.length < n2) {
            int n3;
            Vector<Character> vector = new Vector<Character>();
            for (n3 = 0; n3 < n2 - cArray.length; ++n3) {
                vector.add(new Character('0'));
            }
            for (n3 = 0; n3 < cArray.length; ++n3) {
                vector.add(new Character(cArray[n3]));
            }
            cArray = new char[vector.size()];
            for (n3 = 0; n3 < cArray.length; ++n3) {
                cArray[n3] = ((Character)vector.get(n3)).charValue();
            }
        }
        for (int i = 0; i < nArray.length; ++i) {
            blArray[nArray[i]] = cArray[i] == '1';
        }
        return blArray;
    }

    boolean[] getOneClassPermutArray(int n) {
        int n2;
        int n3;
        boolean[] blArray = new boolean[this.numExps];
        for (n3 = 0; n3 < blArray.length; ++n3) {
            blArray[n3] = false;
        }
        n3 = this.getNumValidOneClassExpts();
        String string = Integer.toBinaryString(n);
        char[] cArray = string.toCharArray();
        if (cArray.length < n3) {
            Vector<Character> vector = new Vector<Character>();
            for (n2 = 0; n2 < n3 - cArray.length; ++n2) {
                vector.add(new Character('0'));
            }
            for (n2 = 0; n2 < cArray.length; ++n2) {
                vector.add(new Character(cArray[n2]));
            }
            cArray = new char[vector.size()];
            for (n2 = 0; n2 < cArray.length; ++n2) {
                cArray[n2] = ((Character)vector.get(n2)).charValue();
            }
        }
        int n4 = 0;
        for (n2 = 0; n2 < blArray.length; ++n2) {
            if (this.groupAssignments[n2] != 1) continue;
            blArray[n2] = cArray[n4] == '1';
            ++n4;
        }
        return blArray;
    }

    public int getNumValidOneClassExpts() {
        int n = 0;
        for (int i = 0; i < this.groupAssignments.length; ++i) {
            if (this.groupAssignments[i] != 1) continue;
            ++n;
        }
        return n;
    }

    private float[] getOneClassGeneValues(int n) {
        Vector<Float> vector = new Vector<Float>();
        for (int i = 0; i < this.numExps; ++i) {
            if (this.groupAssignments[i] != 1) continue;
            vector.add(new Float(this.expMatrix.A[n][i]));
        }
        float[] fArray = new float[vector.size()];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = ((Float)vector.get(i)).floatValue();
        }
        return fArray;
    }

    private boolean isSigOneClass(int n) {
        int n2;
        boolean bl = false;
        Vector<Float> vector = new Vector<Float>();
        for (int i = 0; i < this.numExps; ++i) {
            if (this.groupAssignments[i] != 1) continue;
            vector.add(new Float(this.expMatrix.A[n][i]));
        }
        float[] fArray = new float[vector.size()];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = ((Float)vector.get(i)).floatValue();
        }
        double d = this.getOneClassTValue(fArray);
        if (Double.isNaN(d)) {
            this.pValuesVector.add(new Float(Float.NaN));
            return false;
        }
        int n3 = 0;
        for (n2 = 0; n2 < fArray.length; ++n2) {
            if (Float.isNaN(fArray[n2])) continue;
            ++n3;
        }
        n2 = n3 - 1;
        TDistribution tDistribution = new TDistribution(n2);
        double d2 = tDistribution.cumulative(Math.abs(d));
        double d3 = 2.0 * (1.0 - d2);
        if (d3 > 1.0) {
            d3 = 1.0;
        }
        this.pValuesVector.add(new Float((float)d3));
        if (this.significanceMethod == 4) {
            bl = d3 <= (double)this.alpha;
        } else if (this.significanceMethod == 5) {
            double d4 = (double)this.alpha / (double)this.numGenes;
            bl = d3 <= d4;
        }
        return bl;
    }

    private double getOneClassTValue(int n, FloatMatrix floatMatrix) {
        Vector<Float> vector = new Vector<Float>();
        for (int i = 0; i < this.numExps; ++i) {
            if (this.groupAssignments[i] != 1) continue;
            vector.add(new Float(floatMatrix.A[n][i]));
        }
        float[] fArray = new float[vector.size()];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = ((Float)vector.get(i)).floatValue();
        }
        return this.getOneClassTValue(fArray);
    }

    private double getOneClassTValue(int n) {
        float[] fArray = this.getOneClassGeneValues(n);
        return this.getOneClassTValue(fArray);
    }

    private double getOneClassTValue(float[] fArray) {
        float f = this.getMean(fArray);
        double d = Math.sqrt(this.getVar(fArray));
        int n = 0;
        for (int i = 0; i < fArray.length; ++i) {
            if (Float.isNaN(fArray[i])) continue;
            ++n;
        }
        double d2 = d / Math.sqrt(n);
        double d3 = (double)(f - this.oneClassMean) / d2;
        return Math.abs(d3);
    }

    double[] getOneClassTValues(FloatMatrix floatMatrix) {
        double[] dArray = new double[this.numGenes];
        for (int i = 0; i < this.numGenes; ++i) {
            dArray[i] = Math.abs(this.getOneClassTValue(i, floatMatrix));
        }
        return dArray;
    }

    private int getOneClassDFValue(float[] fArray) {
        int n;
        int n2 = 0;
        for (n = 0; n < fArray.length; ++n) {
            if (Float.isNaN(fArray[n])) continue;
            ++n2;
        }
        n = n2 - 1;
        return n;
    }

    private float getProb(float f, int n) {
        TDistribution tDistribution = new TDistribution(n);
        double d = tDistribution.cumulative(Math.abs((double)f));
        double d2 = 2.0 * (1.0 - d);
        if (d2 > 1.0) {
            d2 = 1.0;
        }
        return (float)d2;
    }

    private Vector sortGenesBySignificance() throws AlgorithmException {
        Vector<Integer> vector = new Vector<Integer>();
        Vector<Integer> vector2 = new Vector<Integer>();
        AlgorithmEvent algorithmEvent = new AlgorithmEvent(this, 1, this.numGenes);
        this.fireValueChanged(algorithmEvent);
        algorithmEvent.setId(2);
        if (this.significanceMethod == 4 || this.significanceMethod == 5) {
            vector = new Vector();
            vector2 = new Vector();
            for (int i = 0; i < this.numGenes; ++i) {
                if (this.stop) {
                    throw new AbortException();
                }
                algorithmEvent.setIntValue(i);
                algorithmEvent.setDescription("Current gene = " + (i + 1));
                this.fireValueChanged(algorithmEvent);
                if (this.isSignificant(i)) {
                    vector.add(new Integer(i));
                    this.sigTValues.add(new Float(this.currentT));
                    this.sigPValues.add(new Float(this.currentP));
                    this.tValuesVector.add(new Float(this.currentT));
                    this.pValuesVector.add(new Float(this.currentP));
                    continue;
                }
                vector2.add(new Integer(i));
                this.nonSigTValues.add(new Float(this.currentT));
                this.nonSigPValues.add(new Float(this.currentP));
                this.tValuesVector.add(new Float(this.currentT));
                this.pValuesVector.add(new Float(this.currentP));
            }
        } else if (this.significanceMethod == 6) {
            int n;
            vector = new Vector();
            vector2 = new Vector();
            float[] fArray = new float[this.numGenes];
            for (int i = 0; i < this.numGenes; ++i) {
                if (this.stop) {
                    throw new AbortException();
                }
                algorithmEvent.setIntValue(i);
                algorithmEvent.setDescription("Current gene = " + (i + 1));
                this.fireValueChanged(algorithmEvent);
                fArray[i] = Math.abs(this.getTValue(i));
            }
            QSort qSort = new QSort(fArray);
            float[] fArray2 = qSort.getSorted();
            int[] nArray = qSort.getOrigIndx();
            double d = this.alpha;
            int n2 = this.numGenes;
            int n3 = 0;
            double d2 = Double.POSITIVE_INFINITY;
            double[] dArray = new double[this.numGenes];
            double[] dArray2 = new double[this.numGenes];
            for (n = fArray2.length - 1; n > 0; --n) {
                n3 = this.getDF(nArray[n]);
                if (Float.isNaN(fArray2[n]) || Float.isNaN(new Integer(n3).floatValue()) || n3 <= 0) {
                    vector2.add(new Integer(nArray[n]));
                    this.nonSigTValues.add(new Float(fArray2[n]));
                    this.nonSigPValues.add(new Float(Float.NaN));
                    dArray[nArray[n]] = fArray2[n];
                    dArray2[nArray[n]] = Double.NaN;
                    continue;
                }
                TDistribution tDistribution = new TDistribution(n3);
                double d3 = tDistribution.cumulative((double)fArray2[n]);
                d2 = 2.0 * (1.0 - d3);
                if (d2 > 1.0) {
                    d2 = 1.0;
                }
                if (d2 <= (d = (double)this.alpha / (double)n2)) {
                    vector.add(new Integer(nArray[n]));
                    this.sigTValues.add(new Float(fArray2[n]));
                    this.sigPValues.add(new Float(d2));
                    dArray[nArray[n]] = fArray2[n];
                    dArray2[nArray[n]] = d2;
                } else {
                    vector2.add(new Integer(nArray[n]));
                    this.nonSigTValues.add(new Float(fArray2[n]));
                    this.nonSigPValues.add(new Float(d2));
                    dArray[nArray[n]] = fArray2[n];
                    dArray2[nArray[n]] = d2;
                }
                if (!(fArray2[n] > fArray2[n - 1]) || --n2 >= 1) continue;
                System.out.println("Warning: denomAlpha = " + n2);
            }
            n3 = this.getDF(nArray[0]);
            if (Float.isNaN(fArray2[0]) || Float.isNaN(new Integer(n3).floatValue()) || n3 <= 0) {
                vector2.add(new Integer(nArray[0]));
                this.nonSigTValues.add(new Float(fArray2[0]));
                this.nonSigPValues.add(new Float(Float.NaN));
                dArray[nArray[0]] = fArray2[0];
                dArray2[nArray[0]] = Double.NaN;
            } else {
                TDistribution tDistribution = new TDistribution(n3);
                double d4 = tDistribution.cumulative((double)fArray2[0]);
                d2 = 2.0 * (1.0 - d4);
                if (d2 > 1.0) {
                    d2 = 1.0;
                }
                if (d2 <= (d = (double)this.alpha / (double)n2)) {
                    vector.add(new Integer(nArray[0]));
                    this.sigTValues.add(new Float(fArray2[0]));
                    this.sigPValues.add(new Float(d2));
                    dArray[nArray[0]] = fArray2[0];
                    dArray2[nArray[0]] = d2;
                } else {
                    vector2.add(new Integer(nArray[0]));
                    this.nonSigTValues.add(new Float(fArray2[0]));
                    this.nonSigPValues.add(new Float(d2));
                    dArray[nArray[0]] = fArray2[0];
                    dArray2[nArray[0]] = d2;
                }
            }
            this.tValuesVector = new Vector();
            this.pValuesVector = new Vector();
            for (n = 0; n < dArray.length; ++n) {
                this.tValuesVector.add(new Float(dArray[n]));
                this.pValuesVector.add(new Float(dArray2[n]));
            }
        }
        Vector<Vector<Integer>> vector3 = new Vector<Vector<Integer>>();
        vector3.add(vector);
        vector3.add(vector2);
        return vector3;
    }

    private Vector sortGenesByPermutationSignificance() throws AlgorithmException {
        Vector<Integer> vector = new Vector<Integer>();
        Vector<Integer> vector2 = new Vector<Integer>();
        AlgorithmEvent algorithmEvent = new AlgorithmEvent(this, 1, this.numGenes);
        this.fireValueChanged(algorithmEvent);
        algorithmEvent.setId(2);
        if (this.significanceMethod == 4 || this.significanceMethod == 5) {
            vector = new Vector();
            vector2 = new Vector();
            for (int i = 0; i < this.numGenes; ++i) {
                if (this.stop) {
                    throw new AbortException();
                }
                algorithmEvent.setIntValue(i);
                algorithmEvent.setDescription("Current gene = " + (i + 1));
                this.fireValueChanged(algorithmEvent);
                if (this.isSignificantByPermutation(i)) {
                    vector.add(new Integer(i));
                    this.sigTValues.add(new Float(this.currentT));
                    this.sigPValues.add(new Float(this.currentP));
                    this.tValuesVector.add(new Float(this.currentT));
                    this.pValuesVector.add(new Float(this.currentP));
                    continue;
                }
                vector2.add(new Integer(i));
                this.nonSigTValues.add(new Float(this.currentT));
                this.nonSigPValues.add(new Float(this.currentP));
                this.tValuesVector.add(new Float(this.currentT));
                this.pValuesVector.add(new Float(this.currentP));
            }
        } else if (this.significanceMethod == 6) {
            int n;
            vector = new Vector();
            vector2 = new Vector();
            float[] fArray = new float[this.numGenes];
            for (int i = 0; i < this.numGenes; ++i) {
                if (this.stop) {
                    throw new AbortException();
                }
                algorithmEvent.setIntValue(i);
                algorithmEvent.setDescription("Current gene = " + (i + 1));
                this.fireValueChanged(algorithmEvent);
                fArray[i] = Math.abs(this.getTValue(i));
            }
            QSort qSort = new QSort(fArray);
            float[] fArray2 = qSort.getSorted();
            int[] nArray = qSort.getOrigIndx();
            double d = this.alpha;
            int n2 = this.numGenes;
            double d2 = Double.POSITIVE_INFINITY;
            double[] dArray = new double[this.numGenes];
            double[] dArray2 = new double[this.numGenes];
            for (n = fArray2.length - 1; n > 0; --n) {
                if (Float.isNaN(fArray2[n])) {
                    vector2.add(new Integer(nArray[n]));
                    this.nonSigTValues.add(new Float(fArray2[n]));
                    this.nonSigPValues.add(new Float(Float.NaN));
                    dArray[nArray[n]] = fArray2[n];
                    dArray2[nArray[n]] = Double.NaN;
                    continue;
                }
                d2 = this.getPermutedProb(nArray[n]);
                if (d2 <= (d = (double)this.alpha / (double)n2)) {
                    vector.add(new Integer(nArray[n]));
                    this.sigTValues.add(new Float(this.currentT));
                    this.sigPValues.add(new Float(d2));
                    dArray[nArray[n]] = fArray2[n];
                    dArray2[nArray[n]] = d2;
                } else {
                    vector2.add(new Integer(nArray[n]));
                    this.nonSigTValues.add(new Float(this.currentT));
                    this.nonSigPValues.add(new Float(d2));
                    dArray[nArray[n]] = fArray2[n];
                    dArray2[nArray[n]] = d2;
                }
                if (!(fArray2[n] > fArray2[n - 1]) || --n2 >= 1) continue;
                System.out.println("Warning: denomAlpha = " + n2);
            }
            if (Float.isNaN(fArray2[0])) {
                vector2.add(new Integer(nArray[0]));
                this.nonSigTValues.add(new Float(fArray2[0]));
                this.nonSigPValues.add(new Float(Float.NaN));
                dArray[nArray[0]] = fArray2[0];
                dArray2[nArray[0]] = Double.NaN;
            } else {
                d2 = this.getPermutedProb(nArray[0]);
                if (d2 <= (d = (double)this.alpha / (double)n2)) {
                    vector.add(new Integer(nArray[0]));
                    this.sigTValues.add(new Float(this.currentT));
                    this.sigPValues.add(new Float(d2));
                    dArray[nArray[0]] = fArray2[0];
                    dArray2[nArray[0]] = d2;
                } else {
                    vector2.add(new Integer(nArray[0]));
                    this.nonSigTValues.add(new Float(this.currentT));
                    this.nonSigPValues.add(new Float(d2));
                    dArray[nArray[0]] = fArray2[0];
                    dArray2[nArray[0]] = d2;
                }
            }
            this.tValuesVector = new Vector();
            this.pValuesVector = new Vector();
            for (n = 0; n < dArray.length; ++n) {
                this.tValuesVector.add(new Float(dArray[n]));
                this.pValuesVector.add(new Float(dArray2[n]));
            }
        }
        Vector<Vector<Integer>> vector3 = new Vector<Vector<Integer>>();
        vector3.add(vector);
        vector3.add(vector2);
        return vector3;
    }

    private double getPermutedProb(int n) {
        int n2;
        float[] fArray = new float[this.numExps];
        for (n2 = 0; n2 < this.numExps; ++n2) {
            fArray[n2] = this.expMatrix.A[n][n2];
        }
        n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.groupAssignments.length; ++i) {
            if (this.groupAssignments[i] == 1) {
                ++n2;
                continue;
            }
            if (this.groupAssignments[i] != 2) continue;
            ++n3;
        }
        float[] fArray2 = new float[n2];
        float[] fArray3 = new float[n3];
        int[] nArray = new int[n2 + n3];
        n2 = 0;
        n3 = 0;
        int n4 = 0;
        for (int i = 0; i < this.groupAssignments.length; ++i) {
            if (this.groupAssignments[i] == 1) {
                fArray2[n2] = fArray[i];
                ++n2;
                nArray[n4] = i;
                ++n4;
                continue;
            }
            if (this.groupAssignments[i] != 2) continue;
            fArray3[n3] = fArray[i];
            ++n3;
            nArray[n4] = i;
            ++n4;
        }
        float f = Math.abs(this.calculateTValue(fArray2, fArray3));
        this.currentT = f;
        double d = 0.0;
        if (this.useAllCombs) {
            int n5 = 0;
            int[] nArray2 = new int[fArray2.length];
            for (int i = 0; i < nArray2.length; ++i) {
                nArray2[i] = -1;
            }
            while (Combinations.enumerateCombinations((int)nArray.length, (int)fArray2.length, (int[])nArray2)) {
                int n6;
                float[] fArray4 = new float[fArray2.length];
                float[] fArray5 = new float[fArray3.length];
                int[] nArray3 = new int[fArray3.length];
                int n7 = 0;
                for (n6 = 0; n6 < nArray.length; ++n6) {
                    if (this.belongsInArray(n6, nArray2)) continue;
                    nArray3[n7] = n6;
                    ++n7;
                }
                for (n6 = 0; n6 < nArray2.length; ++n6) {
                    fArray4[n6] = fArray[nArray[nArray2[n6]]];
                }
                for (n6 = 0; n6 < nArray3.length; ++n6) {
                    fArray5[n6] = fArray[nArray[nArray3[n6]]];
                }
                float f2 = Math.abs(this.calculateTValue(fArray4, fArray5));
                if (f < f2) {
                    d += 1.0;
                }
                ++n5;
            }
            d /= (double)n5;
        } else {
            int n8 = 0;
            d = 0.0;
            for (int i = 0; i < this.numCombs; ++i) {
                float[][] fArray6 = this.randomlyPermute(fArray, nArray, fArray2.length, fArray3.length);
                float f3 = Math.abs(this.calculateTValue(fArray6[0], fArray6[1]));
                if (f < f3) {
                    d += 1.0;
                }
                ++n8;
            }
            d /= (double)n8;
        }
        this.currentP = d;
        return d;
    }

    private boolean isSignificantByPermutation(int n) {
        int n2;
        boolean bl = false;
        float[] fArray = new float[this.numExps];
        for (n2 = 0; n2 < this.numExps; ++n2) {
            fArray[n2] = this.expMatrix.A[n][n2];
        }
        n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.groupAssignments.length; ++i) {
            if (this.groupAssignments[i] == 1) {
                ++n2;
                continue;
            }
            if (this.groupAssignments[i] != 2) continue;
            ++n3;
        }
        float[] fArray2 = new float[n2];
        float[] fArray3 = new float[n3];
        int[] nArray = new int[n2 + n3];
        int n4 = 0;
        int n5 = 0;
        n2 = 0;
        n3 = 0;
        int n6 = 0;
        for (int i = 0; i < this.groupAssignments.length; ++i) {
            if (this.groupAssignments[i] == 1) {
                fArray2[n2] = fArray[i];
                if (!Float.isNaN(fArray[i])) {
                    ++n4;
                }
                ++n2;
                nArray[n6] = i;
                ++n6;
                continue;
            }
            if (this.groupAssignments[i] != 2) continue;
            fArray3[n3] = fArray[i];
            if (!Float.isNaN(fArray[i])) {
                ++n5;
            }
            ++n3;
            nArray[n6] = i;
            ++n6;
        }
        if (n4 < 2 || n5 < 2) {
            this.currentP = Double.NaN;
            this.currentT = Double.NaN;
            return false;
        }
        float f = Math.abs(this.calculateTValue(fArray2, fArray3));
        this.currentT = f;
        double d = 0.0;
        double d2 = 0.0;
        if (this.significanceMethod == 4) {
            d2 = this.alpha;
        } else if (this.significanceMethod == 5) {
            d2 = (double)this.alpha / (double)this.numGenes;
        }
        if (Float.isNaN(f)) {
            bl = false;
            this.currentP = Double.NaN;
            return bl;
        }
        if (this.useAllCombs) {
            int n7 = 0;
            int[] nArray2 = new int[fArray2.length];
            for (int i = 0; i < nArray2.length; ++i) {
                nArray2[i] = -1;
            }
            while (Combinations.enumerateCombinations((int)nArray.length, (int)fArray2.length, (int[])nArray2)) {
                int n8;
                float[] fArray4 = new float[fArray2.length];
                float[] fArray5 = new float[fArray3.length];
                int[] nArray3 = new int[fArray3.length];
                int n9 = 0;
                for (n8 = 0; n8 < nArray.length; ++n8) {
                    if (this.belongsInArray(n8, nArray2)) continue;
                    nArray3[n9] = n8;
                    ++n9;
                }
                for (n8 = 0; n8 < nArray2.length; ++n8) {
                    fArray4[n8] = fArray[nArray[nArray2[n8]]];
                }
                for (n8 = 0; n8 < nArray3.length; ++n8) {
                    fArray5[n8] = fArray[nArray[nArray3[n8]]];
                }
                float f2 = Math.abs(this.calculateTValue(fArray4, fArray5));
                if (f < f2) {
                    d += 1.0;
                }
                ++n7;
            }
            this.currentP = d /= (double)n7;
            if (d <= d2) {
                bl = true;
            }
            return bl;
        }
        int n10 = 0;
        d = 0.0;
        for (int i = 0; i < this.numCombs; ++i) {
            float[][] fArray6 = this.randomlyPermute(fArray, nArray, fArray2.length, fArray3.length);
            float f3 = Math.abs(this.calculateTValue(fArray6[0], fArray6[1]));
            if (f < f3) {
                d += 1.0;
            }
            ++n10;
        }
        this.currentP = d /= (double)n10;
        if (d <= d2) {
            bl = true;
        }
        return bl;
    }

    private float[][] randomlyPermute(float[] fArray, int[] nArray, int n, int n2) {
        int n3;
        int n4;
        float[][] fArrayArray = new float[][]{new float[n], new float[n2]};
        if (n > n2) {
            fArrayArray[0] = new float[n2];
            fArrayArray[1] = new float[n];
        }
        Vector<Integer> vector = new Vector<Integer>();
        for (n4 = 0; n4 < nArray.length; ++n4) {
            vector.add(new Integer(nArray[n4]));
        }
        for (n4 = 0; n4 < fArrayArray[0].length; ++n4) {
            n3 = (int)Math.round(Math.random() * (double)(vector.size() - 1));
            int n5 = (Integer)vector.remove(n3);
            fArrayArray[0][n4] = fArray[n5];
        }
        for (n4 = 0; n4 < fArrayArray[1].length; ++n4) {
            n3 = (Integer)vector.get(n4);
            fArrayArray[1][n4] = fArray[n3];
        }
        return fArrayArray;
    }

    private float[][] randomlyPermute2(float[] fArray, int[] nArray, int n, int n2) {
        int n3;
        float[][] fArrayArray = new float[][]{new float[n], new float[n2]};
        boolean[] blArray = new boolean[nArray.length];
        for (n3 = 0; n3 < blArray.length; ++n3) {
            blArray[n3] = false;
        }
        n3 = 0;
        int n4 = 0;
        while (n3 < n) {
            Random random = new Random();
            int n5 = random.nextInt(nArray.length);
            if (blArray[n5]) continue;
            fArrayArray[0][n3] = fArray[nArray[n5]];
            blArray[n5] = true;
            ++n3;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (blArray[i]) continue;
            fArrayArray[1][n4] = fArray[nArray[i]];
            ++n4;
        }
        return fArrayArray;
    }

    private boolean belongsInArray(int n, int[] nArray) {
        boolean bl = false;
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private float getTValue(int n, FloatMatrix floatMatrix) {
        int n2;
        float[] fArray = new float[this.numExps];
        for (n2 = 0; n2 < this.numExps; ++n2) {
            fArray[n2] = floatMatrix.A[n][n2];
        }
        n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.groupAssignments.length; ++i) {
            if (this.groupAssignments[i] == 1) {
                ++n2;
                continue;
            }
            if (this.groupAssignments[i] != 2) continue;
            ++n3;
        }
        float[] fArray2 = new float[n2];
        float[] fArray3 = new float[n3];
        n2 = 0;
        n3 = 0;
        for (int i = 0; i < this.groupAssignments.length; ++i) {
            if (this.groupAssignments[i] == 1) {
                fArray2[n2] = fArray[i];
                ++n2;
                continue;
            }
            if (this.groupAssignments[i] != 2) continue;
            fArray3[n3] = fArray[i];
            ++n3;
        }
        float f = this.calculateTValue(fArray2, fArray3);
        return f;
    }

    private float getTValue(int n) {
        int n2;
        float[] fArray = new float[this.numExps];
        for (n2 = 0; n2 < this.numExps; ++n2) {
            fArray[n2] = this.expMatrix.A[n][n2];
        }
        n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.groupAssignments.length; ++i) {
            if (this.groupAssignments[i] == 1) {
                ++n2;
                continue;
            }
            if (this.groupAssignments[i] != 2) continue;
            ++n3;
        }
        float[] fArray2 = new float[n2];
        float[] fArray3 = new float[n3];
        n2 = 0;
        n3 = 0;
        for (int i = 0; i < this.groupAssignments.length; ++i) {
            if (this.groupAssignments[i] == 1) {
                fArray2[n2] = fArray[i];
                ++n2;
                continue;
            }
            if (this.groupAssignments[i] != 2) continue;
            fArray3[n3] = fArray[i];
            ++n3;
        }
        float f = this.calculateTValue(fArray2, fArray3);
        return f;
    }

    private int getDF(int n) {
        int n2;
        int n3;
        float[] fArray = new float[this.numExps];
        for (n3 = 0; n3 < this.numExps; ++n3) {
            fArray[n3] = this.expMatrix.A[n][n3];
        }
        n3 = 0;
        int n4 = 0;
        for (int i = 0; i < this.groupAssignments.length; ++i) {
            if (this.groupAssignments[i] == 1) {
                ++n3;
                continue;
            }
            if (this.groupAssignments[i] != 2) continue;
            ++n4;
        }
        float[] fArray2 = new float[n3];
        float[] fArray3 = new float[n4];
        n3 = 0;
        n4 = 0;
        for (n2 = 0; n2 < this.groupAssignments.length; ++n2) {
            if (this.groupAssignments[n2] == 1) {
                fArray2[n3] = fArray[n2];
                ++n3;
                continue;
            }
            if (this.groupAssignments[n2] != 2) continue;
            fArray3[n4] = fArray[n2];
            ++n4;
        }
        n2 = this.calculateDf(fArray2, fArray3);
        return n2;
    }

    private Vector getMeansAndSDs() {
        float[] fArray = new float[this.numGenes];
        float[] fArray2 = new float[this.numGenes];
        float[] fArray3 = new float[this.numGenes];
        float[] fArray4 = new float[this.numGenes];
        for (int i = 0; i < this.numGenes; ++i) {
            int n;
            float[] fArray5 = new float[this.numExps];
            for (n = 0; n < this.numExps; ++n) {
                fArray5[n] = this.expMatrix.A[i][n];
            }
            n = 0;
            int n2 = 0;
            for (int j = 0; j < this.groupAssignments.length; ++j) {
                if (this.groupAssignments[j] == 1) {
                    ++n;
                    continue;
                }
                if (this.groupAssignments[j] != 2) continue;
                ++n2;
            }
            float[] fArray6 = new float[n];
            float[] fArray7 = new float[n2];
            n = 0;
            n2 = 0;
            for (int j = 0; j < this.groupAssignments.length; ++j) {
                if (this.groupAssignments[j] == 1) {
                    fArray6[n] = fArray5[j];
                    ++n;
                    continue;
                }
                if (this.groupAssignments[j] != 2) continue;
                fArray7[n2] = fArray5[j];
                ++n2;
            }
            fArray[i] = this.getMean(fArray6);
            fArray2[i] = this.getMean(fArray7);
            fArray3[i] = (float)Math.sqrt(this.getVar(fArray6));
            fArray4[i] = (float)Math.sqrt(this.getVar(fArray7));
        }
        Vector<float[]> vector = new Vector<float[]>();
        vector.add(fArray);
        vector.add(fArray2);
        vector.add(fArray3);
        vector.add(fArray4);
        return vector;
    }

    private boolean isSignificant(int n) {
        int n2;
        boolean bl = false;
        float[] fArray = new float[this.numExps];
        for (n2 = 0; n2 < this.numExps; ++n2) {
            fArray[n2] = this.expMatrix.A[n][n2];
        }
        n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.groupAssignments.length; ++i) {
            if (this.groupAssignments[i] == 1) {
                ++n2;
                continue;
            }
            if (this.groupAssignments[i] != 2) continue;
            ++n3;
        }
        float[] fArray2 = new float[n2];
        float[] fArray3 = new float[n3];
        int n4 = 0;
        int n5 = 0;
        n2 = 0;
        n3 = 0;
        for (int i = 0; i < this.groupAssignments.length; ++i) {
            if (this.groupAssignments[i] == 1) {
                fArray2[n2] = fArray[i];
                if (!Float.isNaN(fArray[i])) {
                    ++n4;
                }
                ++n2;
                continue;
            }
            if (this.groupAssignments[i] != 2) continue;
            fArray3[n3] = fArray[i];
            if (!Float.isNaN(fArray[i])) {
                ++n5;
            }
            ++n3;
        }
        if (n4 < 2 || n5 < 2) {
            this.currentP = Double.NaN;
            this.currentT = Double.NaN;
            return false;
        }
        float f = this.calculateTValue(fArray2, fArray3);
        this.currentT = f;
        int n6 = this.calculateDf(fArray2, fArray3);
        if (!this.isPermut) {
            if (Float.isNaN(f) || Float.isNaN(new Integer(n6).floatValue()) || n6 <= 0) {
                bl = false;
                this.currentP = Double.NaN;
            } else {
                TDistribution tDistribution = new TDistribution(n6);
                double d = tDistribution.cumulative((double)f);
                double d2 = 2.0 * (1.0 - d);
                if (d2 > 1.0) {
                    d2 = 1.0;
                }
                this.currentP = d2;
                if (this.significanceMethod == 4) {
                    bl = d2 <= (double)this.alpha;
                } else if (this.significanceMethod == 5) {
                    double d3 = (double)this.alpha / (double)this.numGenes;
                    bl = d2 <= d3;
                }
            }
        }
        return bl;
    }

    private float calculateTValue(float[] fArray, float[] fArray2) {
        int n;
        int n2 = fArray.length;
        int n3 = fArray2.length;
        float f = this.getMean(fArray);
        float f2 = this.getMean(fArray2);
        float f3 = this.getVar(fArray);
        float f4 = this.getVar(fArray2);
        int n4 = 0;
        int n5 = 0;
        for (n = 0; n < fArray.length; ++n) {
            if (Float.isNaN(fArray[n])) continue;
            ++n4;
        }
        for (n = 0; n < fArray2.length; ++n) {
            if (Float.isNaN(fArray2[n])) continue;
            ++n5;
        }
        if (n4 < 2 || n5 < 2) {
            return Float.NaN;
        }
        float f5 = (float)((double)(f - f2) / Math.sqrt(f3 / (float)n2 + f4 / (float)n3));
        return Math.abs(f5);
    }

    private int calculateDf(float[] fArray, float[] fArray2) {
        int n;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < fArray.length; ++n) {
            if (Float.isNaN(fArray[n])) continue;
            ++n2;
        }
        for (n = 0; n < fArray2.length; ++n) {
            if (Float.isNaN(fArray2[n])) continue;
            ++n3;
        }
        if (!this.useWelchDf) {
            n = n2 + n3 - 2;
            if (n < 0) {
                n = 0;
            }
            return n;
        }
        float f = this.getMean(fArray);
        float f2 = this.getMean(fArray2);
        float f3 = this.getVar(fArray);
        float f4 = this.getVar(fArray2);
        float f5 = (float)Math.pow(f3 / (float)n2 + f4 / (float)n3, 2.0);
        float f6 = (float)(Math.pow(f3 / (float)n2, 2.0) / (double)(n2 - 1) + Math.pow(f4 / (float)n3, 2.0) / (double)(n3 - 1));
        int n4 = (int)Math.floor(f5 / f6);
        return n4;
    }

    private float getMean(float[] fArray) {
        float f = 0.0f;
        int n = 0;
        for (int i = 0; i < fArray.length; ++i) {
            if (Float.isNaN(fArray[i])) continue;
            f += fArray[i];
            ++n;
        }
        if (n == 0) {
            return Float.NaN;
        }
        float f2 = f / (float)n;
        if (Float.isInfinite(f2)) {
            return Float.NaN;
        }
        return f2;
    }

    private float getVar(float[] fArray) {
        float f = this.getMean(fArray);
        int n = 0;
        float f2 = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            if (Float.isNaN(fArray[i])) continue;
            f2 = (float)((double)f2 + Math.pow(fArray[i] - f, 2.0));
            ++n;
        }
        if (n < 2) {
            return Float.NaN;
        }
        float f3 = f2 / (float)(n - 1);
        if (Float.isInfinite(f3)) {
            return Float.NaN;
        }
        return f3;
    }
}

