/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.aqua;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.aqua.BinaryPListParser;
import com.jidesoft.plaf.aqua.XMLElement;
import com.jidesoft.plaf.aqua.XMLParseException;
import com.jidesoft.utils.SecurityUtils;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;

class AquaPreferences {
    private static final Logger LOGGER = Logger.getLogger(AquaPreferences.class.getName());
    private static HashMap prefs;

    public static String getString(String string) {
        String string2 = UIDefaultsLookup.getString("AquaPreference." + string);
        if (string2 != null) {
            return string2;
        }
        return (String)AquaPreferences.get(string);
    }

    public static Object get(String string) {
        if (prefs == null) {
            prefs = new HashMap();
            AquaPreferences.loadGlobalPreferences();
        }
        return prefs.get(string);
    }

    private static void loadGlobalPreferences() {
        prefs.put("AppleAquaColorVariant", "1");
        prefs.put("AppleHighlightColor", "0.709800 0.835300 1.000000");
        prefs.put("AppleCollationOrder", "en");
        prefs.put("AppleScrollBarVariant", "DoubleMax");
        prefs.put("AppleScrollerPagingBehavior", "false");
        File file = new File(SecurityUtils.getProperty("user.home", "") + "/Library/Preferences/.GlobalPreferences.plist");
        try {
            XMLElement xMLElement = AquaPreferences.readPList(file);
            Iterator iterator = xMLElement.iterateChildren();
            while (iterator.hasNext()) {
                XMLElement xMLElement2 = (XMLElement)iterator.next();
                String string = null;
                Iterator iterator2 = xMLElement2.iterateChildren();
                while (iterator2.hasNext()) {
                    XMLElement xMLElement3 = (XMLElement)iterator2.next();
                    if (xMLElement3.getName().equals("key")) {
                        string = xMLElement3.getContent();
                        continue;
                    }
                    if (string != null) {
                        prefs.put(string, xMLElement3.getContent());
                    }
                    string = null;
                }
            }
        }
        catch (IOException iOException) {
            LOGGER.warning("AquaPreferences failed to load Mac OS X global system preferences - " + iOException.getLocalizedMessage());
        }
        catch (Exception exception) {
            LOGGER.warning("AquaPreferences failed to load Mac OS X global system preferences - " + exception.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static XMLElement readPList(File file) throws IOException {
        FileReader fileReader = null;
        XMLElement xMLElement = null;
        try {
            fileReader = new FileReader(file);
            xMLElement = new XMLElement(new HashMap(), false, false);
            try {
                xMLElement.parseFromReader(fileReader);
            }
            catch (XMLParseException xMLParseException) {
                xMLElement = new BinaryPListParser().parse(file);
            }
        }
        finally {
            if (fileReader != null) {
                fileReader.close();
            }
        }
        return xMLElement;
    }
}

