/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.AbstractFTPInputStream;
import com.enterprisedt.net.ftp.FTPASCIIInputStream;
import com.enterprisedt.net.ftp.FTPBinaryInputStream;
import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.FileTransferInputStream;
import java.io.IOException;

public class FTPInputStream
extends FileTransferInputStream {
    private AbstractFTPInputStream stream;

    public FTPInputStream(FTPClient client, String remoteFile) throws IOException, FTPException {
        this(client, remoteFile, 0L);
    }

    public FTPInputStream(FTPClient client, String remoteFile, long offset) throws IOException, FTPException {
        this.remoteFile = remoteFile;
        boolean isASCII = client.getType().equals(FTPTransferType.ASCII);
        if (isASCII) {
            if (offset > 0L) {
                throw new FTPException("Offset for ASCII transfers must be 0");
            }
            this.stream = new FTPASCIIInputStream(client, remoteFile, offset);
        } else {
            this.stream = new FTPBinaryInputStream(client, remoteFile, offset);
        }
    }

    public int read() throws IOException {
        return this.stream.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.stream.read(b, off, len);
    }

    public void close() throws IOException {
        this.stream.close();
    }

    public long skip(long n) throws IOException {
        return this.stream.skip(n);
    }

    public synchronized void mark(int readlimit) {
        this.stream.mark(readlimit);
    }

    public synchronized void reset() throws IOException {
        this.stream.reset();
    }

    public boolean markSupported() {
        return this.stream.markSupported();
    }
}

