/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.TLinkable;
import java.io.Serializable;
import java.util.AbstractSequentialList;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class TLinkedList
extends AbstractSequentialList
implements Serializable {
    static final long serialVersionUID = 8255356362445153793L;
    protected TLinkable _head;
    protected TLinkable _tail;
    protected int _size = 0;

    public ListIterator listIterator(int index) {
        return new IteratorImpl(index);
    }

    public int size() {
        return this._size;
    }

    public void add(int index, Object linkable) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("index:" + index);
        }
        this.insert(index, linkable);
    }

    public boolean add(Object linkable) {
        this.insert(this._size, linkable);
        return true;
    }

    public void addFirst(Object linkable) {
        this.insert(0, linkable);
    }

    public void addLast(Object linkable) {
        this.insert(this.size(), linkable);
    }

    public void clear() {
        if (null != this._head) {
            for (TLinkable link = this._head.getNext(); link != null; link = link.getNext()) {
                TLinkable prev = link.getPrevious();
                prev.setNext(null);
                link.setPrevious(null);
            }
            this._tail = null;
            this._head = null;
        }
        this._size = 0;
    }

    public Object[] toArray() {
        Object[] o = new Object[this._size];
        int i = 0;
        for (TLinkable link = this._head; link != null; link = link.getNext()) {
            o[i++] = link;
        }
        return o;
    }

    public Object[] toUnlinkedArray() {
        Object[] o = new Object[this._size];
        int i = 0;
        TLinkable link = this._head;
        TLinkable tmp = null;
        while (link != null) {
            o[i] = link;
            tmp = link;
            link = link.getNext();
            tmp.setNext(null);
            tmp.setPrevious(null);
            ++i;
        }
        this._size = 0;
        this._tail = null;
        this._head = null;
        return o;
    }

    public boolean contains(Object o) {
        for (TLinkable link = this._head; link != null; link = link.getNext()) {
            if (!o.equals(link)) continue;
            return true;
        }
        return false;
    }

    public Object getFirst() {
        return this._head;
    }

    public Object getLast() {
        return this._tail;
    }

    public Object removeFirst() {
        TLinkable o = this._head;
        TLinkable n = o.getNext();
        o.setNext(null);
        if (null != n) {
            n.setPrevious(null);
        }
        this._head = n;
        if (--this._size == 0) {
            this._tail = null;
        }
        return o;
    }

    public Object removeLast() {
        TLinkable o = this._tail;
        TLinkable prev = o.getPrevious();
        o.setPrevious(null);
        if (null != prev) {
            prev.setNext(null);
        }
        this._tail = prev;
        if (--this._size == 0) {
            this._head = null;
        }
        return o;
    }

    protected void insert(int index, Object linkable) {
        TLinkable newLink = (TLinkable)linkable;
        if (this._size == 0) {
            this._head = this._tail = newLink;
        } else if (index == 0) {
            newLink.setNext(this._head);
            this._head.setPrevious(newLink);
            this._head = newLink;
        } else if (index == this._size) {
            this._tail.setNext(newLink);
            newLink.setPrevious(this._tail);
            this._tail = newLink;
        } else {
            TLinkable prior = null;
            TLinkable post = null;
            if (index > this._size >> 1) {
                prior = this._tail;
                for (int pos = this._size - 1; pos > index; --pos) {
                    prior = prior.getPrevious();
                }
            } else {
                prior = this._head;
                for (int pos = 0; pos < index; ++pos) {
                    prior = prior.getNext();
                }
            }
            post = prior.getNext();
            newLink.setNext(post);
            newLink.setPrevious(prior);
            post.setPrevious(newLink);
            prior.setNext(newLink);
        }
        ++this._size;
    }

    public boolean remove(Object o) {
        if (o instanceof TLinkable) {
            TLinkable link = (TLinkable)o;
            TLinkable p = link.getPrevious();
            TLinkable n = link.getNext();
            if (n == null && p == null) {
                this._tail = null;
                this._head = null;
            } else if (n == null) {
                link.setPrevious(null);
                p.setNext(null);
                this._tail = p;
            } else if (p == null) {
                link.setNext(null);
                n.setPrevious(null);
                this._head = n;
            } else {
                p.setNext(n);
                n.setPrevious(p);
                link.setNext(null);
                link.setPrevious(null);
            }
            --this._size;
            return true;
        }
        return false;
    }

    public void addBefore(TLinkable current, TLinkable newElement) {
        if (current == this._head) {
            this.addFirst(newElement);
        } else if (current == null) {
            this.addLast(newElement);
        } else {
            TLinkable p = current.getPrevious();
            newElement.setNext(current);
            p.setNext(newElement);
            newElement.setPrevious(p);
            current.setPrevious(newElement);
            ++this._size;
        }
    }

    protected final class IteratorImpl
    implements ListIterator {
        private int _nextIndex = 0;
        private TLinkable _next;
        private TLinkable _lastReturned;

        IteratorImpl(int position) {
            if (position < 0 || position > TLinkedList.this._size) {
                throw new IndexOutOfBoundsException();
            }
            this._nextIndex = position;
            if (position == 0) {
                this._next = TLinkedList.this._head;
            } else if (position == TLinkedList.this._size) {
                this._next = null;
            } else if (position < TLinkedList.this._size >> 1) {
                this._next = TLinkedList.this._head;
                for (int pos = 0; pos < position; ++pos) {
                    this._next = this._next.getNext();
                }
            } else {
                this._next = TLinkedList.this._tail;
                for (int pos = TLinkedList.this._size - 1; pos > position; --pos) {
                    this._next = this._next.getPrevious();
                }
            }
        }

        public final void add(Object linkable) {
            this._lastReturned = null;
            ++this._nextIndex;
            if (TLinkedList.this._size == 0) {
                TLinkedList.this.add(linkable);
            } else {
                TLinkedList.this.addBefore(this._next, (TLinkable)linkable);
            }
        }

        public final boolean hasNext() {
            return this._nextIndex != TLinkedList.this._size;
        }

        public final boolean hasPrevious() {
            return this._nextIndex != 0;
        }

        public final Object next() {
            if (this._nextIndex == TLinkedList.this._size) {
                throw new NoSuchElementException();
            }
            this._lastReturned = this._next;
            this._next = this._next.getNext();
            ++this._nextIndex;
            return this._lastReturned;
        }

        public final int nextIndex() {
            return this._nextIndex;
        }

        public final Object previous() {
            if (this._nextIndex == 0) {
                throw new NoSuchElementException();
            }
            this._lastReturned = this._nextIndex == TLinkedList.this._size ? (this._next = TLinkedList.this._tail) : (this._next = this._next.getPrevious());
            --this._nextIndex;
            return this._lastReturned;
        }

        public final int previousIndex() {
            return this._nextIndex - 1;
        }

        public final void remove() {
            if (this._lastReturned == null) {
                throw new IllegalStateException("must invoke next or previous before invoking remove");
            }
            if (this._lastReturned != this._next) {
                --this._nextIndex;
            }
            this._next = this._lastReturned.getNext();
            TLinkedList.this.remove(this._lastReturned);
            this._lastReturned = null;
        }

        public final void set(Object linkable) {
            if (this._lastReturned == null) {
                throw new IllegalStateException();
            }
            TLinkable l = (TLinkable)linkable;
            if (this._lastReturned == TLinkedList.this._head) {
                TLinkedList.this._head = l;
            }
            if (this._lastReturned == TLinkedList.this._tail) {
                TLinkedList.this._tail = l;
            }
            this.swap(this._lastReturned, l);
            this._lastReturned = l;
        }

        private void swap(TLinkable from, TLinkable to) {
            TLinkable p = from.getPrevious();
            TLinkable n = from.getNext();
            if (null != p) {
                to.setPrevious(p);
                p.setNext(to);
            }
            if (null != n) {
                to.setNext(n);
                n.setPrevious(to);
            }
            from.setNext(null);
            from.setPrevious(null);
        }
    }
}

