/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.jetty;

import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.ujmp.jetty.handlers.FaviconHandler;
import org.ujmp.jetty.handlers.HomeHandler;
import org.ujmp.jetty.handlers.RobotsHandler;
import org.ujmp.jetty.handlers.StylesheetHandler;

public class UJMPJettyServer {
    public static final int DEFAULTPORT = 5555;
    private Server server = null;
    private final int port;

    public UJMPJettyServer(int port) {
        this.port = port;
    }

    public static void main(String[] args) throws Exception {
        int port = 5555;
        if (args != null && args.length == 1) {
            port = new Integer(args[0]);
        }
        UJMPJettyServer server = new UJMPJettyServer(port);
        server.start();
    }

    public boolean isConnected() {
        return this.server != null && this.server.isRunning();
    }

    public void start() throws Exception {
        this.server = new Server(this.port);
        ContextHandler homeHandler = new ContextHandler();
        homeHandler.setContextPath("/");
        homeHandler.setHandler((Handler)new HomeHandler());
        ContextHandler faviconHandler = new ContextHandler();
        faviconHandler.setContextPath("/favicon.ico");
        faviconHandler.setAllowNullPathInfo(true);
        faviconHandler.setHandler((Handler)new FaviconHandler());
        ContextHandler robotsHandler = new ContextHandler();
        robotsHandler.setContextPath("/robots.txt");
        robotsHandler.setAllowNullPathInfo(true);
        robotsHandler.setHandler((Handler)new RobotsHandler());
        ContextHandler stylesheetHandler = new ContextHandler();
        stylesheetHandler.setContextPath("/style.css");
        stylesheetHandler.setAllowNullPathInfo(true);
        stylesheetHandler.setHandler((Handler)new StylesheetHandler());
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        contexts.addHandler((Handler)homeHandler);
        contexts.addHandler((Handler)faviconHandler);
        contexts.addHandler((Handler)robotsHandler);
        contexts.addHandler((Handler)stylesheetHandler);
        this.server.setHandler((Handler)contexts);
        this.server.start();
    }

    public void stop() throws Exception {
        this.server.stop();
    }
}

