/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.jdbc.table;

import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.ujmp.jdbc.table.AbstractTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCTable
extends AbstractTable {
    private static final long serialVersionUID = 8283985768904867255L;
    protected String url = null;
    protected String username = null;
    protected String password = null;
    protected Set<String> columnsForKeys = null;
    protected String tableName = null;
    private boolean tableExists = false;
    private transient Connection connection = null;
    private transient PreparedStatement truncateTableStatement = null;
    protected transient Map<Set<String>, PreparedStatement> insertStatements = null;
    protected transient PreparedStatement updateStatement = null;
    private transient PreparedStatement deleteStatement = null;
    protected transient PreparedStatement selectStatement = null;
    private transient PreparedStatement countStatement = null;
    private transient PreparedStatement keyStatement = null;

    public JDBCTable(String url, String tableName, String userName, String password, String ... columnsForKeys) {
        this.url = url;
        this.username = userName;
        this.password = password;
        this.tableName = tableName;
        this.columnsForKeys = new TreeSet<String>(Arrays.asList(columnsForKeys));
        if (columnsForKeys.length == 0) {
            throw new RuntimeException("no key columns defined");
        }
        if (this.tableName == null) {
            this.tableName = "temp_table_" + System.currentTimeMillis();
        }
    }

    protected synchronized Connection getConnection() throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            this.connection = DriverManager.getConnection(this.url, this.username, this.password);
        }
        return this.connection;
    }

    public boolean tableExists() throws SQLException {
        if (!this.tableExists) {
            DatabaseMetaData dbm = this.getConnection().getMetaData();
            ResultSet tables = dbm.getTables(null, null, "%", null);
            while (tables.next()) {
                if (!this.tableName.equalsIgnoreCase(tables.getString(3))) continue;
                this.tableExists = true;
            }
            tables.close();
        }
        return this.tableExists;
    }

    private void initDatabase(Map<String, Object> fieldsAndValues) throws SQLException {
        if (!this.tableExists) {
            TreeSet<String> valueColumns = new TreeSet<String>();
            for (String field : fieldsAndValues.keySet()) {
                if (this.columnsForKeys.contains(field)) continue;
                valueColumns.add(field);
            }
            StringBuilder sql = new StringBuilder();
            sql.append("CREATE TABLE ");
            sql.append(this.tableName);
            sql.append(" (");
            for (String keyColumn : this.columnsForKeys) {
                sql.append(keyColumn);
                sql.append(" VARCHAR(255), ");
            }
            for (String valueColumn : valueColumns) {
                sql.append(valueColumn);
                sql.append(" TEXT, ");
            }
            sql.append("PRIMARY KEY (");
            int i = 0;
            for (String keyColumn : this.columnsForKeys) {
                sql.append(keyColumn);
                if (i++ >= this.columnsForKeys.size() - 1) continue;
                sql.append(", ");
            }
            sql.append("))");
            PreparedStatement statement = this.getConnection().prepareStatement(sql.toString());
            statement.execute();
            statement.close();
        }
    }

    public static JDBCTable connectToMySQL(String serverName, int port, String databaseName, String tableName, String username, String password, String ... columnsForKeys) throws SQLException {
        return new JDBCTable("jdbc:mysql://" + serverName + ":" + port + "/" + databaseName + "?useUnicode=true&characterEncoding=UTF-8&zeroDateTimeBehavior=convertToNull", tableName, username, password, columnsForKeys);
    }

    public static JDBCTable connectToMySQL(String serverName, int port, String databaseName, String tableName, String userName, String password) throws SQLException {
        return new JDBCTable("jdbc:mysql://" + serverName + ":" + port + "/" + databaseName + "?useUnicode=true&characterEncoding=UTF-8&zeroDateTimeBehavior=convertToNull", tableName, userName, password, new String[0]);
    }

    public static JDBCTable connectToHSQLDB(File filename, String tableName, String ... columnForKeys) {
        return new JDBCTable("jdbc:hsqldb:file:/" + filename, tableName, "SA", "", columnForKeys);
    }

    @Override
    public boolean add(Map<String, Object> fieldsAndValues) {
        try {
            PreparedStatement insertStatement;
            Set<String> keySet = fieldsAndValues.keySet();
            if (this.insertStatements == null) {
                this.insertStatements = new HashMap<Set<String>, PreparedStatement>();
            }
            if ((insertStatement = this.insertStatements.get(keySet)) == null || insertStatement.isClosed()) {
                this.initDatabase(fieldsAndValues);
                StringBuilder sql = new StringBuilder();
                sql.append("insert into " + this.tableName + " (");
                int i = 0;
                for (String key : keySet) {
                    sql.append(key);
                    if (i++ >= keySet.size() - 1) continue;
                    sql.append(", ");
                }
                sql.append(") values (");
                while (i > 0) {
                    sql.append("?");
                    if (i > 1) {
                        sql.append(", ");
                    }
                    --i;
                }
                sql.append(")");
                insertStatement = this.getConnection().prepareStatement(sql.toString());
            }
            int i = 1;
            for (Map.Entry<String, Object> entry : fieldsAndValues.entrySet()) {
                insertStatement.setString(i++, "" + entry.getValue());
            }
            int count = insertStatement.executeUpdate();
            return count != 0;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<String, Object> getFirst(Map<String, Object> keys) {
        return null;
    }

    @Override
    public List<Map<String, Object>> getAll(Map<String, Object> keys) {
        return null;
    }

    @Override
    public int size() {
        try {
            ResultSet rs;
            if (!this.tableExists()) {
                return 0;
            }
            int count = -1;
            if (this.countStatement == null || this.countStatement.isClosed()) {
                String sql = "select count(*) from " + this.tableName;
                this.countStatement = this.getConnection().prepareStatement(sql);
            }
            if ((rs = this.countStatement.executeQuery()).next()) {
                count = rs.getInt(1);
            }
            rs.close();
            return count;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean contains(Object o) {
        return false;
    }

    @Override
    public Iterator<Map<String, Object>> iterator() {
        return null;
    }

    @Override
    public boolean remove(Object o) {
        return false;
    }

    @Override
    public void clear() {
        try {
            if (this.truncateTableStatement == null || this.truncateTableStatement.isClosed()) {
                String sql = "truncate table " + this.tableName;
                this.truncateTableStatement = this.getConnection().prepareStatement(sql);
            }
            this.truncateTableStatement.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean update(Map<String, Object> keyFieldsAndValues, Map<String, Object> updatedFieldsAndValues) {
        return false;
    }
}

