/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.jblas.calculation;

import org.jblas.DoubleMatrix;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.MtimesCalculation;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.interfaces.HasColumnMajorDoubleArray1D;
import org.ujmp.core.util.MathUtil;
import org.ujmp.jblas.JBlasDenseDoubleMatrix2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mtimes
implements MtimesCalculation<Matrix, Matrix, Matrix> {
    @Override
    public void calc(Matrix source1, Matrix source2, Matrix target) {
        DoubleMatrix m1 = source1 instanceof JBlasDenseDoubleMatrix2D ? ((JBlasDenseDoubleMatrix2D)source1).getWrappedObject() : (source1 instanceof HasColumnMajorDoubleArray1D ? new JBlasDenseDoubleMatrix2D(MathUtil.longToInt(source1.getRowCount()), MathUtil.longToInt(source1.getColumnCount()), ((HasColumnMajorDoubleArray1D)((Object)source1)).getColumnMajorDoubleArray1D()).getWrappedObject() : new JBlasDenseDoubleMatrix2D(source1).getWrappedObject());
        DoubleMatrix m2 = source2 instanceof JBlasDenseDoubleMatrix2D ? ((JBlasDenseDoubleMatrix2D)source2).getWrappedObject() : (source2 instanceof HasColumnMajorDoubleArray1D ? new JBlasDenseDoubleMatrix2D(MathUtil.longToInt(source2.getRowCount()), MathUtil.longToInt(source2.getColumnCount()), ((HasColumnMajorDoubleArray1D)((Object)source2)).getColumnMajorDoubleArray1D()).getWrappedObject() : new JBlasDenseDoubleMatrix2D(source2).getWrappedObject());
        if (target instanceof JBlasDenseDoubleMatrix2D) {
            DoubleMatrix t = ((JBlasDenseDoubleMatrix2D)target).getWrappedObject();
            m1.mmuli(m2, t);
        } else if (target instanceof HasColumnMajorDoubleArray1D) {
            DoubleMatrix t = new DoubleMatrix((int)target.getRowCount(), (int)target.getColumnCount(), ((HasColumnMajorDoubleArray1D)((Object)target)).getColumnMajorDoubleArray1D());
            m1.mmuli(m2, t);
        } else if (target instanceof DenseDoubleMatrix2D) {
            DenseDoubleMatrix2D t = (DenseDoubleMatrix2D)target;
            DoubleMatrix r = new DoubleMatrix((int)source1.getRowCount(), (int)source2.getColumnCount());
            m1.mmuli(m2, r);
            for (long[] c : target.allCoordinates()) {
                t.setDouble(r.get((int)c[0], (int)c[1]), c[0], c[1]);
            }
        } else {
            DoubleMatrix r = new DoubleMatrix((int)source1.getRowCount(), (int)source2.getColumnCount());
            m1.mmuli(m2, r);
            for (long[] c : target.allCoordinates()) {
                target.setAsDouble(r.get((int)c[0], (int)c[1]), c);
            }
        }
    }
}

