/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.jblas;

import org.jblas.DoubleMatrix;
import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.doublematrix.stub.AbstractDenseDoubleMatrix2D;
import org.ujmp.core.interfaces.HasColumnMajorDoubleArray1D;
import org.ujmp.core.interfaces.HasRowMajorDoubleArray2D;
import org.ujmp.core.interfaces.Wrapper;
import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.jblas.JBlasDenseDoubleMatrix2DFactory;
import org.ujmp.jblas.calculation.Chol;
import org.ujmp.jblas.calculation.Eig;
import org.ujmp.jblas.calculation.Inv;
import org.ujmp.jblas.calculation.InvSPD;
import org.ujmp.jblas.calculation.LU;
import org.ujmp.jblas.calculation.SVD;
import org.ujmp.jblas.calculation.Solve;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBlasDenseDoubleMatrix2D
extends AbstractDenseDoubleMatrix2D
implements Wrapper<DoubleMatrix> {
    private static final long serialVersionUID = 4929284378405884509L;
    public static final JBlasDenseDoubleMatrix2DFactory Factory = new JBlasDenseDoubleMatrix2DFactory();
    private final DoubleMatrix matrix;

    public JBlasDenseDoubleMatrix2D(int rows, int columns) {
        super((long)rows, (long)columns);
        this.matrix = new DoubleMatrix(rows, columns);
    }

    public JBlasDenseDoubleMatrix2D(DoubleMatrix matrix) {
        super((long)matrix.getRows(), (long)matrix.getColumns());
        this.matrix = matrix;
    }

    public JBlasDenseDoubleMatrix2D(Matrix source) {
        super(source.getRowCount(), source.getColumnCount());
        if (source instanceof HasColumnMajorDoubleArray1D) {
            double[] data = ((HasColumnMajorDoubleArray1D)((Object)source)).getColumnMajorDoubleArray1D();
            this.matrix = new DoubleMatrix((int)source.getRowCount(), (int)source.getColumnCount(), data);
        } else if (source instanceof HasRowMajorDoubleArray2D) {
            double[][] data = ((HasRowMajorDoubleArray2D)((Object)source)).getRowMajorDoubleArray2D();
            this.matrix = new DoubleMatrix(data);
        } else if (source instanceof DenseDoubleMatrix2D) {
            this.matrix = new DoubleMatrix((int)source.getRowCount(), (int)source.getColumnCount());
            DenseDoubleMatrix2D m2 = (DenseDoubleMatrix2D)source;
            int r = (int)source.getRowCount();
            while (--r >= 0) {
                int c = (int)source.getColumnCount();
                while (--c >= 0) {
                    this.matrix.put(r, c, m2.getDouble(r, c));
                }
            }
        } else {
            this.matrix = new DoubleMatrix((int)source.getRowCount(), (int)source.getColumnCount());
            for (long[] c : source.availableCoordinates()) {
                this.setDouble(source.getAsDouble(c), c);
            }
        }
        if (source.getMetaData() != null) {
            this.setMetaData(source.getMetaData().clone());
        }
    }

    public JBlasDenseDoubleMatrix2D(int rowCount, int columnCount, double[] doubleArray) {
        super((long)rowCount, (long)columnCount);
        this.matrix = new DoubleMatrix(rowCount, columnCount, doubleArray);
    }

    @Override
    public Matrix inv() {
        return Inv.INSTANCE.calc(this);
    }

    @Override
    public Matrix invSPD() {
        return InvSPD.INSTANCE.calc(this);
    }

    @Override
    public double getDouble(long row, long column) {
        return this.matrix.get((int)row, (int)column);
    }

    @Override
    public double getDouble(int row, int column) {
        return this.matrix.get(row, column);
    }

    @Override
    public void setDouble(double value, long row, long column) {
        this.matrix.put((int)row, (int)column, value);
    }

    @Override
    public void setDouble(double value, int row, int column) {
        this.matrix.put(row, column, value);
    }

    @Override
    public DoubleMatrix getWrappedObject() {
        return this.matrix;
    }

    public final Matrix copy() {
        JBlasDenseDoubleMatrix2D m = new JBlasDenseDoubleMatrix2D(this.matrix.dup());
        if (this.getMetaData() != null) {
            m.setMetaData(this.getMetaData().clone());
        }
        return m;
    }

    @Override
    public Matrix transpose() {
        return new JBlasDenseDoubleMatrix2D(this.matrix.transpose());
    }

    @Override
    public Matrix[] lu() {
        return LU.INSTANCE.calc(this);
    }

    @Override
    public Matrix[] svd() {
        return SVD.INSTANCE.calc(this);
    }

    @Override
    public Matrix[] eig() {
        return Eig.INSTANCE.calc(this);
    }

    @Override
    public Matrix chol() {
        return Chol.INSTANCE.calc(this);
    }

    @Override
    public Matrix mtimes(Matrix m) {
        if (m instanceof JBlasDenseDoubleMatrix2D) {
            DoubleMatrix r = new DoubleMatrix((int)this.getRowCount(), (int)m.getColumnCount());
            this.matrix.mmuli(((JBlasDenseDoubleMatrix2D)m).matrix, r);
            return new JBlasDenseDoubleMatrix2D(r);
        }
        return super.mtimes(m);
    }

    @Override
    public Matrix plus(Matrix m) {
        if (m instanceof JBlasDenseDoubleMatrix2D) {
            DoubleMatrix r = new DoubleMatrix((int)this.getRowCount(), (int)this.getColumnCount());
            this.matrix.addi(((JBlasDenseDoubleMatrix2D)m).matrix, r);
            JBlasDenseDoubleMatrix2D result = new JBlasDenseDoubleMatrix2D(r);
            MapMatrix<String, Object> a = this.getMetaData();
            if (a != null) {
                result.setMetaData(a.clone());
            }
            return result;
        }
        return super.plus(m);
    }

    @Override
    public Matrix minus(Matrix m) {
        if (m instanceof JBlasDenseDoubleMatrix2D) {
            DoubleMatrix r = new DoubleMatrix((int)this.getRowCount(), (int)this.getColumnCount());
            this.matrix.subi(((JBlasDenseDoubleMatrix2D)m).matrix, r);
            JBlasDenseDoubleMatrix2D result = new JBlasDenseDoubleMatrix2D(r);
            MapMatrix<String, Object> a = this.getMetaData();
            if (a != null) {
                result.setMetaData(a.clone());
            }
            return result;
        }
        return super.minus(m);
    }

    @Override
    public Matrix times(double value) {
        DoubleMatrix r = new DoubleMatrix((int)this.getRowCount(), (int)this.getColumnCount());
        JBlasDenseDoubleMatrix2D result = new JBlasDenseDoubleMatrix2D(this.matrix.muli(value, r));
        MapMatrix<String, Object> a = this.getMetaData();
        if (a != null) {
            result.setMetaData(a.clone());
        }
        return result;
    }

    @Override
    public Matrix divide(double value) {
        DoubleMatrix r = new DoubleMatrix((int)this.getRowCount(), (int)this.getColumnCount());
        JBlasDenseDoubleMatrix2D result = new JBlasDenseDoubleMatrix2D(this.matrix.divi(value, r));
        MapMatrix<String, Object> a = this.getMetaData();
        if (a != null) {
            result.setMetaData(a.clone());
        }
        return result;
    }

    @Override
    public Matrix plus(double value) {
        DoubleMatrix r = new DoubleMatrix((int)this.getRowCount(), (int)this.getColumnCount());
        JBlasDenseDoubleMatrix2D result = new JBlasDenseDoubleMatrix2D(this.matrix.addi(value, r));
        MapMatrix<String, Object> a = this.getMetaData();
        if (a != null) {
            result.setMetaData(a.clone());
        }
        return result;
    }

    @Override
    public Matrix minus(double value) {
        DoubleMatrix r = new DoubleMatrix((int)this.getRowCount(), (int)this.getColumnCount());
        JBlasDenseDoubleMatrix2D result = new JBlasDenseDoubleMatrix2D(this.matrix.subi(value, r));
        MapMatrix<String, Object> a = this.getMetaData();
        if (a != null) {
            result.setMetaData(a.clone());
        }
        return result;
    }

    @Override
    public Matrix solve(Matrix b) {
        return Solve.INSTANCE.calc(this, b);
    }

    public JBlasDenseDoubleMatrix2DFactory getFactory() {
        return Factory;
    }
}

