/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.itext;

import com.itextpdf.awt.DefaultFontMapper;
import com.itextpdf.awt.FontMapper;
import com.itextpdf.awt.PdfGraphics2D;
import com.itextpdf.text.Document;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import org.ujmp.core.filematrix.FileFormat;
import org.ujmp.gui.interfaces.CanRenderGraph;

public abstract class ExportPDF {
    private static final Logger logger = Logger.getLogger(ExportPDF.class.getName());

    public static final File selectFile() {
        return ExportPDF.selectFile(null);
    }

    public static final File selectFile(Component c) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(FileFormat.PDF.getFileFilter());
        int returnVal = chooser.showOpenDialog(c);
        if (returnVal == 0) {
            File file = chooser.getSelectedFile();
            if (!file.getAbsolutePath().toLowerCase().endsWith(".pdf")) {
                file = new File(file.getAbsolutePath() + ".pdf");
            }
            return file;
        }
        return null;
    }

    public static final void save(File file, Component c) {
        ExportPDF.save(file, c, c.getWidth(), c.getHeight());
    }

    public static final void save(File file, Component c, int width, int height) {
        if (file == null) {
            logger.log(Level.WARNING, "no file selected");
            return;
        }
        if (c == null) {
            logger.log(Level.WARNING, "no component provided");
            return;
        }
        try {
            Document document = new Document(new Rectangle((float)width, (float)height));
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(file.getAbsolutePath()));
            document.addAuthor("UJMP v0.3.0");
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            PdfTemplate tp = cb.createTemplate((float)width, (float)height);
            PdfGraphics2D g2 = new PdfGraphics2D(cb, (float)width, (float)height, (FontMapper)new DefaultFontMapper());
            if (c instanceof CanRenderGraph) {
                ((CanRenderGraph)((Object)c)).renderGraph((Graphics2D)g2);
            } else {
                c.paint((Graphics)g2);
            }
            g2.dispose();
            cb.addTemplate(tp, 0.0f, 0.0f);
            document.close();
            writer.close();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "could not save PDF file", e);
        }
    }
}

