/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import org.ujmp.core.Matrix;
import org.ujmp.gui.MatrixGUIObject;
import org.ujmp.gui.menu.MatrixPopupMenu;
import org.ujmp.gui.table.ColumnTableHeaderRenderer64;
import org.ujmp.gui.table.JTable64;
import org.ujmp.gui.table.JTableHeader64;
import org.ujmp.gui.table.ListSelectionEvent64;
import org.ujmp.gui.table.ListSelectionListener64;
import org.ujmp.gui.table.MatrixTable64;
import org.ujmp.gui.table.RowHeaderTableModel64;
import org.ujmp.gui.table.RowTableHeaderRenderer64;
import org.ujmp.gui.table.TableModelEvent64;
import org.ujmp.gui.table.TableModelListener64;
import org.ujmp.gui.util.Preloader;

public class MatrixTableEditorPanel
extends JPanel
implements TableModelListener64,
MouseListener,
MouseMotionListener,
KeyListener,
ListSelectionListener64 {
    private static final long serialVersionUID = -1794955656888362574L;
    private final MatrixGUIObject dataModel;
    private final JTable64 jTable;
    private final JTable64 rowHeader;
    private final JScrollPane scrollPane;
    private final Preloader preloader = new Preloader();
    private boolean scroll = true;
    private boolean isShowPreloader = true;

    public MatrixTableEditorPanel(String title, MatrixGUIObject m) {
        this.dataModel = m;
        this.setBorder(BorderFactory.createTitledBorder(title == null ? "Matrix Editor" : title));
        this.setLayout(new BorderLayout());
        this.jTable = new MatrixTable64(m);
        this.jTable.setRowHeight(35);
        this.rowHeader = new JTable64(new RowHeaderTableModel64(m));
        this.rowHeader.setRowHeight(35);
        this.rowHeader.getColumnModel64().setDefaultColumnWidth(80);
        this.rowHeader.getTableHeader().setReorderingAllowed(false);
        this.rowHeader.setSelectionModel(this.jTable.getSelectionModel());
        this.rowHeader.setDefaultRenderer(Object.class, new RowTableHeaderRenderer64(this.jTable));
        JTableHeader64 tableHeader = new JTableHeader64(this.jTable.getColumnModel64());
        tableHeader.setReorderingAllowed(false);
        tableHeader.setDefaultRenderer(new ColumnTableHeaderRenderer64(this.jTable));
        this.jTable.setTableHeader(tableHeader);
        this.scrollPane = new JScrollPane(this.jTable);
        this.scrollPane.setRowHeaderView(this.rowHeader);
        this.addMouseMotionListener(this);
        this.jTable.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.jTable.addMouseListener(this);
        this.jTable.addKeyListener(this);
        this.dataModel.addTableModelListener(this);
        this.dataModel.getRowSelectionModel().addListSelectionListener(this);
        this.dataModel.getColumnSelectionModel().addListSelectionListener(this);
        if (this.dataModel.getRowCount() < 0 || this.dataModel.getColumnCount() < 0) {
            this.isShowPreloader = true;
            this.add((Component)this.preloader, "Center");
        } else {
            this.isShowPreloader = false;
            this.add((Component)this.scrollPane, "Center");
        }
    }

    public void tableChanged(TableModelEvent64 e) {
        this.removePreloader();
    }

    private void removePreloader() {
        if (this.isShowPreloader && this.dataModel.getRowCount() >= 0 && this.dataModel.getColumnCount() >= 0) {
            this.isShowPreloader = false;
            this.remove(this.preloader);
            this.add((Component)this.scrollPane, "Center");
            this.revalidate();
        }
    }

    public void tableChanged(TableModelEvent e) {
        this.removePreloader();
    }

    public void mouseClicked(MouseEvent e) {
        Object o;
        int row = this.jTable.rowAtPoint(e.getPoint());
        int col = this.jTable.columnAtPoint(e.getPoint());
        if (row < 0 || col < 0) {
            return;
        }
        if (e.getButton() == 3) {
            MatrixPopupMenu popup = new MatrixPopupMenu(null, this.dataModel, row, col);
            popup.show(this.jTable, e.getX(), e.getY());
        } else if (e.getButton() == 1 && (o = this.dataModel.getMatrix().getAsObject(row, col)) instanceof Matrix) {
            ((Matrix)o).showGUI();
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.scroll = false;
    }

    public void mouseReleased(MouseEvent e) {
        this.scroll = true;
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void valueChanged(ListSelectionEvent e) {
        this.valueChanged(new ListSelectionEvent64(e.getSource(), (long)e.getFirstIndex(), (long)e.getLastIndex(), e.getValueIsAdjusting()));
    }

    public void valueChanged(ListSelectionEvent64 e) {
        if (this.scroll && !e.getValueIsAdjusting()) {
            long minRow = this.jTable.getSelectionModel().getMinSelectionIndex();
            long minCol = this.jTable.getColumnModel().getSelectionModel().getMinSelectionIndex();
            long maxRow = this.jTable.getSelectionModel().getMaxSelectionIndex();
            long maxCol = this.jTable.getColumnModel().getSelectionModel().getMaxSelectionIndex();
            if (minRow == maxRow && minCol == maxCol) {
                JViewport viewport = (JViewport)this.jTable.getParent();
                Rectangle rect = this.jTable.getCellRect((int)minRow, (int)minCol, true);
                Rectangle viewRect = viewport.getViewRect();
                rect.setLocation(rect.x - viewRect.x, rect.y - viewRect.y);
                int centerX = (viewRect.width - rect.width) / 2;
                int centerY = (viewRect.height - rect.height) / 2;
                if (rect.x < centerX) {
                    centerX = -centerX;
                }
                if (rect.y < centerY) {
                    centerY = -centerY;
                }
                rect.translate(centerX, centerY);
                viewport.scrollRectToVisible(rect);
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.dataModel != null) {
            this.dataModel.removeTableModelListener(this);
        }
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        int row = this.jTable.rowAtPoint(e.getPoint());
        int col = this.jTable.columnAtPoint(e.getPoint());
        this.dataModel.setMouseOverCoordinates(row, col);
    }
}

