/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Map;
import org.ujmp.core.collections.map.SoftHashMap;

public class BufferedRandomAccessFile
extends RandomAccessFile {
    private int bufferSize = 65536;
    private final Map<Long, byte[]> buffer = new SoftHashMap<Long, byte[]>();

    public BufferedRandomAccessFile(File file, String mode) throws FileNotFoundException {
        super(file, mode);
    }

    public BufferedRandomAccessFile(File file, String mode, int bufferSize) throws FileNotFoundException {
        super(file, mode);
        this.bufferSize = bufferSize;
    }

    public synchronized int read() throws IOException {
        byte[] b = new byte[1];
        this.read(b);
        this.seek(this.getFilePointer() + 1L);
        new IOException("don't use this method").printStackTrace();
        return b[0];
    }

    public synchronized void seek(long pos) throws IOException {
        new IOException("don't use this method").printStackTrace();
        super.seek(pos);
    }

    public synchronized int read(byte[] b) throws IOException {
        new IOException("don't use this method").printStackTrace();
        return super.read(b);
    }

    public synchronized int read(long seek, byte[] b) throws IOException {
        if (b.length > this.bufferSize) {
            throw new IOException("cannot read more than buffersize");
        }
        long pos = seek / (long)this.bufferSize * (long)this.bufferSize;
        int offset = (int)(seek - pos);
        byte[] bytes = this.buffer.get(pos);
        if (bytes == null) {
            super.seek(pos);
            bytes = new byte[this.bufferSize];
            super.read(bytes);
            this.buffer.put(pos, bytes);
        }
        if (offset + b.length > this.bufferSize) {
            System.arraycopy(bytes, offset, b, 0, this.bufferSize - offset);
            bytes = this.buffer.get(pos += (long)this.bufferSize);
            if (bytes == null) {
                super.seek(pos);
                bytes = new byte[this.bufferSize];
                super.read(bytes);
                this.buffer.put(pos, bytes);
            }
            System.arraycopy(bytes, 0, b, this.bufferSize - offset, b.length - this.bufferSize + offset);
        } else {
            System.arraycopy(bytes, offset, b, 0, b.length);
        }
        return b.length;
    }

    public synchronized void writeByte(long seek, byte value) throws IOException {
        super.seek(seek);
        super.writeByte(value);
        this.buffer.clear();
    }

    public synchronized void writeChar(long seek, char value) throws IOException {
        super.seek(seek);
        super.writeChar(value);
        this.buffer.clear();
    }

    public synchronized void writeDouble(long seek, double value) throws IOException {
        super.seek(seek);
        super.writeDouble(value);
        this.buffer.clear();
    }

    public synchronized void writeFloat(long seek, float value) throws IOException {
        super.seek(seek);
        super.writeFloat(value);
        this.buffer.clear();
    }

    public synchronized void writeShort(long seek, short value) throws IOException {
        super.seek(seek);
        super.writeShort(value);
        this.buffer.clear();
    }

    public synchronized void write(long seek, byte[] array) throws IOException {
        super.seek(seek);
        super.write(array);
        this.buffer.clear();
    }

    public synchronized void writeInt(long seek, int value) throws IOException {
        super.seek(seek);
        super.writeInt(value);
        this.buffer.clear();
    }

    public synchronized void writeLong(long seek, long value) throws IOException {
        super.seek(seek);
        super.writeLong(value);
        this.buffer.clear();
    }
}

