/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.objectmatrix.calculation;

import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.objectmatrix.calculation.AbstractObjectCalculation;

public class SetContent
extends AbstractObjectCalculation {
    private static final long serialVersionUID = 2014347270412520806L;
    private final Matrix newContent;
    private final long[] position;

    public SetContent(Matrix source, Matrix newContent, long ... position) {
        super(source);
        this.newContent = newContent;
        this.position = position;
    }

    public Object getObject(long ... coordinates) {
        if (!Coordinates.isGreaterOrEqual(coordinates, this.position)) {
            return this.getSource().getAsObject(coordinates);
        }
        long[] c = Coordinates.minus(coordinates, this.position);
        if (Coordinates.isSmallerThan(c, this.newContent.getSize())) {
            return this.newContent.getAsObject(c);
        }
        return this.getSource().getAsObject(coordinates);
    }

    public Matrix calcOrig() {
        if (!Coordinates.equals(this.getSource().getSize(), this.getSize())) {
            throw new RuntimeException("Cannot change Matrix size. Use calc(Ret.NEW) or calc(Ret.LINK) instead.");
        }
        long[] newCoordinates = new long[this.position.length];
        for (long[] c : this.newContent.allCoordinates()) {
            Coordinates.plus(newCoordinates, this.position, c);
            this.getSource().setAsObject(this.getObject(newCoordinates), newCoordinates);
        }
        this.getSource().fireValueChanged();
        return this.getSource();
    }
}

