/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.objectmatrix.calculation;

import java.util.Collection;
import org.ujmp.core.Matrix;
import org.ujmp.core.mapmatrix.DefaultMapMatrix;
import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.core.objectmatrix.calculation.AbstractObjectCalculation;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Selection
extends AbstractObjectCalculation {
    private static final long serialVersionUID = 4576183558391811345L;
    private final long[][] selection;
    private final long[] size;

    public Selection(Matrix m, String selectionString) {
        this(m, StringUtil.parseSelection(selectionString, m.getSize()));
    }

    public Selection(Matrix m, Collection<? extends Number> ... selection) {
        super(m);
        this.selection = new long[selection.length][];
        if (selection[0] != null) {
            this.selection[0] = MathUtil.collectionToLongArray(selection[0]);
        }
        if (selection[1] != null) {
            this.selection[1] = MathUtil.collectionToLongArray(selection[1]);
        }
        this.size = this.selection[0] != null && this.selection[1] != null ? new long[]{this.selection[0].length, this.selection[1].length} : (this.selection[0] == null ? new long[]{this.getSource().getRowCount(), this.selection[1].length} : new long[]{this.selection[0].length, this.getSource().getColumnCount()});
        this.createAnnotation();
    }

    public Selection(Matrix m, long[] ... selection) {
        super(m);
        this.selection = selection;
        this.size = selection[0] != null && selection[1] != null ? new long[]{selection[0].length, selection[1].length} : (selection[0] == null ? new long[]{this.getSource().getRowCount(), selection[1].length} : new long[]{selection[0].length, this.getSource().getColumnCount()});
        this.createAnnotation();
    }

    private void createAnnotation() {
        if (this.getSource().getDimensionCount() != 2) {
            throw new RuntimeException("only supported for 2d matrices");
        }
        MapMatrix<String, Object> a = this.getSource().getMetaData();
        if (a != null) {
            DefaultMapMatrix<String, Object> anew = new DefaultMapMatrix<String, Object>();
            anew.put("Label", a.get("Label"));
            if (this.selection[0] == null) {
                long rowCount = this.getSource().getRowCount();
                int r = 0;
                while ((long)r < rowCount) {
                    ++r;
                }
            } else {
                for (int r = 0; r < this.selection[0].length; ++r) {
                }
            }
            if (this.selection[1] == null) {
                long colCount = this.getSource().getColumnCount();
                int c = 0;
                while ((long)c < colCount) {
                    ++c;
                }
            } else {
                for (int c = 0; c < this.selection[1].length; ++c) {
                }
            }
            this.setMetaData(anew);
        }
    }

    @Override
    public Object getObject(long ... coordinates) {
        if (this.selection[0] != null && this.selection[1] != null) {
            return this.getSource().getAsObject(this.selection[0][(int)coordinates[0]], this.selection[1][(int)coordinates[1]]);
        }
        if (this.selection[0] == null) {
            return this.getSource().getAsObject(coordinates[0], this.selection[1][(int)coordinates[1]]);
        }
        return this.getSource().getAsObject(this.selection[0][(int)coordinates[0]], coordinates[1]);
    }

    @Override
    public long[] getSize() {
        return this.size;
    }

    @Override
    public void setObject(Object value, long ... coordinates) {
        if (this.selection[0] != null && this.selection[1] != null) {
            this.getSource().setAsObject(value, this.selection[0][(int)coordinates[0]], this.selection[1][(int)coordinates[1]]);
        } else if (this.selection[0] == null) {
            this.getSource().setAsObject(value, coordinates[0], this.selection[1][(int)coordinates[1]]);
        } else {
            this.getSource().setAsObject(value, this.selection[0][(int)coordinates[0]], coordinates[1]);
        }
    }
}

