/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.io;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.ujmp.core.Matrix;
import org.ujmp.core.util.io.IntelligentFileWriter;

public class ExportMatrixGML {
    public static final void toFile(File file, Matrix m, Object ... parameters) throws IOException {
        IntelligentFileWriter w = new IntelligentFileWriter(file);
        ExportMatrixGML.toWriter(w, m, parameters);
        w.close();
    }

    public static final void toStream(OutputStream out, Matrix m, Object ... parameters) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter(out);
        ExportMatrixGML.toWriter(w, m, parameters);
        w.close();
    }

    public static final void toWriter(Writer w, Matrix m, Object ... parameters) throws IOException {
        w.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        w.write("<graphml>\n");
        w.write("<key id=\"k0\" for=\"node\" attr.name=\"variableName\" attr.type=\"string\"></key>\n");
        w.write("<key id=\"k1\" for=\"node\" attr.name=\"description\" attr.type=\"string\"></key>\n");
        w.write("<key id=\"k2\" for=\"edge\" attr.name=\"confidence\" attr.type=\"double\"><default>0.0</default></key>\n");
        w.write("<key id=\"k3\" for=\"edge\" attr.name=\"directed\" attr.type=\"boolean\"><default>false</default></key>\n");
        w.write("<key id=\"k5\" for=\"node\" attr.name=\"xPos\" attr.type=\"string\"></key>\n");
        w.write("<key id=\"k6\" for=\"node\" attr.name=\"yPos\" attr.type=\"string\"></key>\n");
        w.write("<graph id=\"" + m.getLabel() + "\" edgedefault=\"undirected\">\n");
        int i = 0;
        while ((long)i < m.getRowCount()) {
            w.write("<node id=\"node" + i + "\">\n");
            w.write("<data key=\"k0\">" + m.getRowLabel(i).replaceAll("[<>&]", "") + "</data>\n");
            w.write("</node>\n");
            ++i;
        }
        int id = 0;
        for (long[] c : m.allCoordinates()) {
            if (!(m.getAsDouble(c) > 0.0)) continue;
            w.write("<edge id=\"edge" + id++ + "\" ");
            w.write("source=\"node" + c[0] + "\" ");
            w.write("target=\"node" + c[1] + "\">\n");
            w.write("</edge>\n");
        }
        w.write("</graph>\n");
        w.write("</graphml>");
        w.close();
    }
}

