/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.impl;

import java.util.HashMap;
import java.util.Map;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.doublematrix.impl.NonZeroIterable;
import org.ujmp.core.doublematrix.stub.AbstractSparseDoubleMatrix2D;
import org.ujmp.core.util.DefaultSparseDoubleVector1D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSparseRowDoubleMatrix2D
extends AbstractSparseDoubleMatrix2D {
    private static final long serialVersionUID = -5291604525500706427L;
    protected final Map<Long, DefaultSparseDoubleVector1D> rows = new HashMap<Long, DefaultSparseDoubleVector1D>();

    public DefaultSparseRowDoubleMatrix2D(long rows, long columns) {
        super(rows, columns);
        this.setSize(rows, columns);
    }

    public DefaultSparseRowDoubleMatrix2D(Matrix m) {
        super(m.getRowCount(), m.getColumnCount());
        this.setSize(m.getSize());
        for (long[] c : m.availableCoordinates()) {
            this.setDouble(m.getAsDouble(c), c);
        }
        if (m.getMetaData() != null) {
            this.setMetaData(m.getMetaData().clone());
        }
    }

    @Override
    public double getDouble(long row, long column) {
        Matrix m = this.rows.get(row);
        return m == null ? 0.0 : m.getAsDouble(0L, column);
    }

    @Override
    public double getDouble(int row, int column) {
        return this.getDouble((long)row, (long)column);
    }

    @Override
    public Iterable<long[]> availableCoordinates() {
        return new NonZeroIterable(this);
    }

    @Override
    public boolean containsCoordinates(long ... coordinates) {
        return this.getDouble(coordinates) != 0.0;
    }

    @Override
    public void setDouble(double o, long row, long column) {
        DefaultSparseDoubleVector1D m = this.rows.get(row);
        if (m == null) {
            m = new DefaultSparseDoubleVector1D(1L, this.getColumnCount());
            this.rows.put(row, m);
        }
        m.setAsDouble(o, 0L, column);
    }

    @Override
    public void setDouble(double o, int row, int column) {
        this.setDouble(o, (long)row, (long)column);
    }

    @Override
    public void setSize(long ... size) {
        if (this.size[1] != size[1]) {
            for (Matrix matrix : this.rows.values()) {
                matrix.setSize(1L, size[1]);
            }
        }
        this.size = size;
    }

    public Matrix getRow(long row) {
        return this.rows.get(row);
    }

    @Override
    public Matrix selectRows(Calculation.Ret returnType, long ... rows) {
        if (returnType == Calculation.Ret.LINK && rows.length == 1) {
            return this.getRow(rows[0]);
        }
        return super.selectRows(returnType, rows);
    }

    @Override
    public final void clear() {
        this.rows.clear();
    }
}

