/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.impl;

import java.util.Arrays;
import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.calculation.Mtimes;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.doublematrix.impl.BlockMatrixLayout;
import org.ujmp.core.doublematrix.stub.AbstractDenseDoubleMatrix2D;
import org.ujmp.core.interfaces.HasBlockDoubleArray2D;
import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.core.objectmatrix.calculation.Transpose;
import org.ujmp.core.util.UJMPSettings;
import org.ujmp.core.util.VerifyUtil;
import org.ujmp.core.util.concurrent.PFor;

public class BlockDenseDoubleMatrix2D
extends AbstractDenseDoubleMatrix2D
implements HasBlockDoubleArray2D {
    private static final long serialVersionUID = -5131649082019624021L;
    private double[][] data;
    protected BlockMatrixLayout layout;

    private static int deriveDefaultBlockStripeSize(int rows, int cols) {
        return rows < UJMPSettings.getInstance().getDefaultBlockSize() && cols < UJMPSettings.getInstance().getDefaultBlockSize() ? 50 : UJMPSettings.getInstance().getDefaultBlockSize();
    }

    public BlockDenseDoubleMatrix2D(double[][] values) {
        this(values.length, values[0].length, BlockMatrixLayout.BlockOrder.ROWMAJOR);
        this.fill(values);
    }

    public BlockDenseDoubleMatrix2D(double[][] values, int blockStripeSize, BlockMatrixLayout.BlockOrder blockOrder) {
        this(values.length, values[0].length, blockStripeSize, blockOrder);
        this.fill(values);
    }

    public BlockDenseDoubleMatrix2D(int rows, int cols, int blockStripeSize, BlockMatrixLayout.BlockOrder blockOrder) {
        super((long)rows, (long)cols);
        VerifyUtil.verifyTrue(rows > 0, "rows<=0");
        VerifyUtil.verifyTrue(cols > 0, "cols<=0");
        VerifyUtil.verifyTrue(blockStripeSize > 0, "blockStripeSize<=0");
        VerifyUtil.verifyTrue(blockOrder != null, "blockOrder == null");
        if (UJMPSettings.getInstance().getNumberOfThreads() != 1) {
            System.err.println("WARNING: setting number of threads to 1 for BlockMatrix");
            UJMPSettings.getInstance().setNumberOfThreads(1);
        }
        this.size = new long[]{rows, cols};
        this.layout = new BlockMatrixLayout(rows, cols, blockStripeSize, blockOrder);
        this.data = new double[this.layout.numberOfBlocks][];
    }

    public BlockDenseDoubleMatrix2D(int rows, int cols, BlockMatrixLayout.BlockOrder blockOrder) {
        this(rows, cols, BlockDenseDoubleMatrix2D.deriveDefaultBlockStripeSize(rows, cols), blockOrder);
    }

    public BlockDenseDoubleMatrix2D(int rows, int cols) {
        this(rows, cols, BlockDenseDoubleMatrix2D.deriveDefaultBlockStripeSize(rows, cols), BlockMatrixLayout.BlockOrder.ROWMAJOR);
    }

    public BlockDenseDoubleMatrix2D(Matrix m) {
        this(m, BlockDenseDoubleMatrix2D.deriveDefaultBlockStripeSize((int)m.getRowCount(), (int)m.getColumnCount()));
    }

    public BlockDenseDoubleMatrix2D(BlockDenseDoubleMatrix2D m) {
        this((int)m.size[0], (int)m.size[1], m.layout.blockStripe, m.layout.blockOrder);
        int i = m.layout.numberOfBlocks;
        while (--i != -1) {
            double[] block = m.data[i];
            if (block == null) continue;
            this.data[i] = new double[block.length];
            System.arraycopy(block, 0, this.data[i], 0, block.length);
        }
        MapMatrix<String, Object> a = m.getMetaData();
        if (a != null) {
            this.setMetaData(a.clone());
        }
    }

    public BlockDenseDoubleMatrix2D(Matrix m, int blockStripeSize) {
        this(m, blockStripeSize, BlockMatrixLayout.BlockOrder.ROWMAJOR);
    }

    public BlockDenseDoubleMatrix2D(Matrix m, int blockStripeSize, BlockMatrixLayout.BlockOrder blockOrder) {
        this((int)m.getRowCount(), (int)m.getColumnCount(), blockStripeSize, blockOrder);
        MapMatrix<String, Object> a;
        if (m instanceof DenseDoubleMatrix2D) {
            DenseDoubleMatrix2D mDense = (DenseDoubleMatrix2D)m;
            int mRows = (int)mDense.getRowCount();
            int mColumns = (int)mDense.getColumnCount();
            for (int j = 0; j < mColumns; ++j) {
                for (int i = 0; i < mRows; ++i) {
                    this.setDouble(mDense.getDouble(i, j), i, j);
                }
            }
        } else {
            for (long[] c : m.availableCoordinates()) {
                this.setDouble(m.getAsDouble(c), c);
            }
        }
        if ((a = m.getMetaData()) != null) {
            this.setMetaData(a.clone());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addBlockData(int row, int column, double[] newData) {
        double[] block;
        int blockNumber = this.layout.getBlockNumber(row, column);
        if (null == this.data[blockNumber]) {
            double[][] dArray = this.data;
            synchronized (this.data) {
                this.data[blockNumber] = newData;
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return;
            }
        }
        double[] dArray = block = this.data[blockNumber];
        synchronized (block) {
            int i = newData.length;
            while (--i >= 0) {
                int n = i;
                block[n] = block[n] + newData[i];
            }
            // ** MonitorExit[var6_8] (shouldn't be in output)
            return;
        }
    }

    public void fill(double[][] data) {
        this.fill(data, 0, 0);
    }

    public void fill(double[][] data, int startRow, int startCol) {
        int rows = data.length;
        int cols = data[0].length;
        VerifyUtil.verifyTrue(startRow < rows && (long)startRow < this.getRowCount(), "illegal startRow: %s", startRow);
        VerifyUtil.verifyTrue(startCol < cols && (long)startCol < this.getColumnCount(), "illegal startCol: %s", startCol);
        VerifyUtil.verifyTrue((long)rows <= this.getRowCount(), "too many rows in input: %s: max allowed = %s", rows, this.getRowCount());
        VerifyUtil.verifyTrue((long)cols <= this.getColumnCount(), "too many columns in input: %s: max allowed = %s", cols, this.getColumnCount());
        for (int i = startRow; i < rows; ++i) {
            for (int j = startCol; j < cols; ++j) {
                this.setDouble(data[i][j], i, j);
            }
        }
    }

    double[] getBlockData(int row, int column) {
        int blockNumber = this.layout.getBlockNumber(row, column);
        double[] block = this.data[blockNumber];
        if (null == block) {
            block = new double[this.layout.getBlockSize(row, column)];
            this.data[blockNumber] = block;
        }
        return this.data[blockNumber];
    }

    public final BlockMatrixLayout getBlockLayout() {
        return this.layout;
    }

    public final int getBlockStripeSize() {
        return this.layout.blockStripe;
    }

    public double getDouble(int row, int col) {
        double[] block = this.data[this.layout.getBlockNumber(row, col)];
        if (null == block) {
            return 0.0;
        }
        return block[this.layout.getIndexInBlock(row, col)];
    }

    public double getDouble(long row, long column) {
        return this.getDouble((int)row, (int)column);
    }

    public Matrix mtimes(Matrix m2) {
        if (m2 instanceof DenseDoubleMatrix2D) {
            BlockDenseDoubleMatrix2D result = new BlockDenseDoubleMatrix2D((int)this.getRowCount(), (int)m2.getColumnCount(), this.layout.blockStripe, BlockMatrixLayout.BlockOrder.ROWMAJOR);
            Mtimes.DENSEDOUBLEMATRIX2D.calc(this, (DenseDoubleMatrix2D)m2, result);
            return result;
        }
        return super.mtimes(m2);
    }

    public void setDouble(double value, int row, int column) {
        double[] block = this.getBlockData(row, column);
        block[this.layout.getIndexInBlock((int)row, (int)column)] = value;
    }

    public void setDouble(double value, long row, long column) {
        this.setDouble(value, (int)row, (int)column);
    }

    public Matrix transpose() {
        return this.transpose(Calculation.Ret.NEW);
    }

    public BlockDenseDoubleMatrix2D clone() {
        return new BlockDenseDoubleMatrix2D(this);
    }

    public Matrix transpose(Calculation.Ret returnType) {
        BlockMatrixLayout.BlockOrder transOrder = BlockMatrixLayout.BlockOrder.ROWMAJOR == this.layout.blockOrder ? BlockMatrixLayout.BlockOrder.COLUMNMAJOR : BlockMatrixLayout.BlockOrder.ROWMAJOR;
        int step = this.layout.blockStripe;
        BlockDenseDoubleMatrix2D transMat = new BlockDenseDoubleMatrix2D((int)this.getColumnCount(), (int)this.getRowCount(), step, transOrder);
        for (int i = 0; i < this.layout.rows; i += step) {
            for (int j = 0; j < this.layout.columns; j += step) {
                int blockNumberA = this.layout.getBlockNumber(i, j);
                double[] block = this.data[blockNumberA];
                if (returnType == Calculation.Ret.NEW && null != block) {
                    double[] newBlock = new double[block.length];
                    System.arraycopy(block, 0, newBlock, 0, block.length);
                    block = newBlock;
                }
                int blockNumberB = transMat.layout.getBlockNumber(j, i);
                transMat.data[blockNumberB] = block;
            }
        }
        if (returnType == Calculation.Ret.ORIG) {
            this.layout = transMat.layout;
            this.data = transMat.data;
            System.arraycopy(transMat.size, 0, this.size, 0, transMat.size.length);
            if (this.getMetaData() != null) {
                this.setMetaData(Transpose.transposeAnnotation(this.getMetaData(), Coordinates.transpose(this.getSize())));
            }
            return this;
        }
        if (returnType == Calculation.Ret.LINK) {
            return super.transpose(Calculation.Ret.LINK);
        }
        if (this.getMetaData() != null) {
            transMat.setMetaData(Transpose.transposeAnnotation(this.getMetaData(), Coordinates.transpose(this.getSize())));
        }
        return transMat;
    }

    public final double[][] getBlockDoubleArray2D() {
        return this.data;
    }

    public Matrix plus(final double value) {
        final BlockDenseDoubleMatrix2D result = new BlockDenseDoubleMatrix2D(this);
        if (result.data.length < 100) {
            int i = result.data.length;
            while (--i != -1) {
                double[] block = result.data[i];
                if (block == null) {
                    block = new double[this.layout.blockArea];
                }
                int j = block.length;
                while (--j != -1) {
                    int n = j;
                    block[n] = block[n] + value;
                }
            }
        } else {
            new PFor(0, result.data.length){

                public void step(int i) {
                    double[] block = result.data[i];
                    if (block == null) {
                        block = new double[BlockDenseDoubleMatrix2D.this.layout.blockArea];
                    }
                    int j = block.length;
                    while (--j != -1) {
                        int n = j;
                        block[n] = block[n] + value;
                    }
                }
            };
        }
        return result;
    }

    public Matrix plus(Matrix value) {
        if (value instanceof BlockDenseDoubleMatrix2D) {
            final BlockDenseDoubleMatrix2D b = (BlockDenseDoubleMatrix2D)value;
            if (b.layout.rows == this.layout.rows && b.layout.columns == this.layout.columns && b.layout.blockOrder == this.layout.blockOrder && b.layout.blockStripe == this.layout.blockStripe) {
                final BlockDenseDoubleMatrix2D result = new BlockDenseDoubleMatrix2D(this);
                if (result.data.length < 100) {
                    int i = result.data.length;
                    while (--i != -1) {
                        double[] block2 = b.data[i];
                        if (block2 == null) continue;
                        if (result.data[i] == null) {
                            result.data[i] = new double[b.data[i].length];
                        }
                        double[] block = result.data[i];
                        int j = block.length;
                        while (--j != -1) {
                            int n = j;
                            block[n] = block[n] + block2[j];
                        }
                    }
                } else {
                    new PFor(0, result.data.length - 1){

                        public void step(int i) {
                            double[] block2 = b.data[i];
                            if (block2 == null) {
                                return;
                            }
                            if (result.data[i] == null) {
                                ((BlockDenseDoubleMatrix2D)result).data[i] = new double[b.data[i].length];
                            }
                            double[] block = result.data[i];
                            int j = block.length;
                            while (--j != -1) {
                                int n = j;
                                block[n] = block[n] + block2[j];
                            }
                        }
                    };
                }
                return result;
            }
        }
        return super.plus(value);
    }

    public Matrix minus(Matrix value) {
        if (value instanceof BlockDenseDoubleMatrix2D) {
            final BlockDenseDoubleMatrix2D b = (BlockDenseDoubleMatrix2D)value;
            if (b.layout.rows == this.layout.rows && b.layout.columns == this.layout.columns && b.layout.blockOrder == this.layout.blockOrder && b.layout.blockStripe == this.layout.blockStripe) {
                final BlockDenseDoubleMatrix2D result = new BlockDenseDoubleMatrix2D(this);
                if (result.data.length < 100) {
                    int i = this.data.length;
                    while (--i != -1) {
                        double[] block2 = b.data[i];
                        if (block2 == null) continue;
                        if (result.data[i] == null) {
                            result.data[i] = new double[b.data[i].length];
                        }
                        double[] block = result.data[i];
                        int j = block.length;
                        while (--j != -1) {
                            int n = j;
                            block[n] = block[n] - block2[j];
                        }
                    }
                } else {
                    new PFor(0, result.data.length - 1){

                        public void step(int i) {
                            double[] block2 = b.data[i];
                            if (block2 == null) {
                                return;
                            }
                            if (result.data[i] == null) {
                                ((BlockDenseDoubleMatrix2D)result).data[i] = new double[b.data[i].length];
                            }
                            double[] block = result.data[i];
                            int j = block.length;
                            while (--j != -1) {
                                int n = j;
                                block[n] = block[n] - block2[j];
                            }
                        }
                    };
                }
                return result;
            }
        }
        return super.minus(value);
    }

    public Matrix times(Matrix value) {
        if (value instanceof BlockDenseDoubleMatrix2D) {
            final BlockDenseDoubleMatrix2D b = (BlockDenseDoubleMatrix2D)value;
            if (b.layout.rows == this.layout.rows && b.layout.columns == this.layout.columns && b.layout.blockOrder == this.layout.blockOrder && b.layout.blockStripe == this.layout.blockStripe) {
                final BlockDenseDoubleMatrix2D result = new BlockDenseDoubleMatrix2D(this);
                if (result.data.length < 100) {
                    int i = result.data.length;
                    while (--i != -1) {
                        double[] block2 = b.data[i];
                        if (block2 == null) {
                            result.data[i] = null;
                            continue;
                        }
                        double[] block = result.data[i];
                        if (block == null) continue;
                        int j = block.length;
                        while (--j != -1) {
                            int n = j;
                            block[n] = block[n] * block2[j];
                        }
                    }
                } else {
                    new PFor(0, result.data.length - 1){

                        public void step(int i) {
                            double[] block2 = b.data[i];
                            if (block2 == null) {
                                ((BlockDenseDoubleMatrix2D)result).data[i] = null;
                            } else {
                                double[] block = result.data[i];
                                if (block == null) {
                                    return;
                                }
                                int j = block.length;
                                while (--j != -1) {
                                    int n = j;
                                    block[n] = block[n] * block2[j];
                                }
                            }
                        }
                    };
                }
                return result;
            }
        }
        return super.times(value);
    }

    public Matrix divide(Matrix value) {
        if (value instanceof BlockDenseDoubleMatrix2D) {
            final BlockDenseDoubleMatrix2D b = (BlockDenseDoubleMatrix2D)value;
            if (b.layout.rows == this.layout.rows && b.layout.columns == this.layout.columns && b.layout.blockOrder == this.layout.blockOrder && b.layout.blockStripe == this.layout.blockStripe) {
                final BlockDenseDoubleMatrix2D result = new BlockDenseDoubleMatrix2D(this);
                if (result.data.length < 100) {
                    int i = result.data.length;
                    while (--i != -1) {
                        double[] block2 = b.data[i];
                        if (block2 == null) {
                            if (result.data[i] == null) {
                                result.data[i] = new double[this.layout.blockArea];
                            }
                            Arrays.fill(result.data[i], Double.NaN);
                            continue;
                        }
                        double[] block = result.data[i];
                        if (block == null) continue;
                        int j = block.length;
                        while (--j != -1) {
                            int n = j;
                            block[n] = block[n] / block2[j];
                        }
                    }
                } else {
                    new PFor(0, result.data.length - 1){

                        public void step(int i) {
                            double[] block2 = b.data[i];
                            if (block2 == null) {
                                if (result.data[i] == null) {
                                    ((BlockDenseDoubleMatrix2D)result).data[i] = new double[BlockDenseDoubleMatrix2D.this.layout.blockArea];
                                }
                                Arrays.fill(result.data[i], Double.NaN);
                            } else {
                                double[] block = result.data[i];
                                if (block == null) {
                                    return;
                                }
                                int j = block.length;
                                while (--j != -1) {
                                    int n = j;
                                    block[n] = block[n] / block2[j];
                                }
                            }
                        }
                    };
                }
                return result;
            }
        }
        return super.times(value);
    }

    public Matrix minus(final double value) {
        final BlockDenseDoubleMatrix2D result = new BlockDenseDoubleMatrix2D(this);
        if (result.data.length < 100) {
            int i = result.data.length;
            while (--i != -1) {
                double[] block = result.data[i];
                if (block == null) {
                    block = new double[this.layout.blockArea];
                }
                int j = block.length;
                while (--j != -1) {
                    int n = j;
                    block[n] = block[n] - value;
                }
            }
        } else {
            new PFor(0, result.data.length - 1){

                public void step(int i) {
                    double[] block = result.data[i];
                    if (block == null) {
                        block = new double[BlockDenseDoubleMatrix2D.this.layout.blockArea];
                    }
                    int j = block.length;
                    while (--j != -1) {
                        int n = j;
                        block[n] = block[n] - value;
                    }
                }
            };
        }
        return result;
    }

    public Matrix times(final double value) {
        final BlockDenseDoubleMatrix2D result = new BlockDenseDoubleMatrix2D(this);
        if (result.data.length < 100) {
            int i = result.data.length;
            while (--i != -1) {
                double[] block = result.data[i];
                if (block == null) continue;
                int j = block.length;
                while (--j != -1) {
                    int n = j;
                    block[n] = block[n] * value;
                }
            }
        } else {
            new PFor(0, result.data.length - 1){

                public void step(int i) {
                    double[] block = result.data[i];
                    if (block != null) {
                        int j = block.length;
                        while (--j != -1) {
                            int n = j;
                            block[n] = block[n] * value;
                        }
                    }
                }
            };
        }
        return result;
    }

    public Matrix divide(final double value) {
        final BlockDenseDoubleMatrix2D result = new BlockDenseDoubleMatrix2D(this);
        if (result.data.length < 100) {
            int i = result.data.length;
            while (--i != -1) {
                double[] block = result.data[i];
                if (block == null) {
                    block = new double[this.layout.blockArea];
                }
                int j = block.length;
                while (--j != -1) {
                    int n = j;
                    block[n] = block[n] / value;
                }
            }
        } else {
            new PFor(0, result.data.length - 1){

                public void step(int i) {
                    double[] block = result.data[i];
                    if (block == null) {
                        block = new double[BlockDenseDoubleMatrix2D.this.layout.blockArea];
                    }
                    int j = block.length;
                    while (--j != -1) {
                        int n = j;
                        block[n] = block[n] / value;
                    }
                }
            };
        }
        return result;
    }

    public BlockMatrixLayout.BlockOrder setBlockOrder(BlockMatrixLayout.BlockOrder order) {
        VerifyUtil.verifyTrue(order != null, "block order cannot be null");
        if (order == this.layout.blockOrder) {
            return order;
        }
        BlockMatrixLayout newLayout = new BlockMatrixLayout(this.layout.rows, this.layout.columns, this.layout.blockStripe, order);
        for (int r = 0; r < this.layout.rows; r += this.layout.blockStripe) {
            for (int c = 0; c < this.layout.columns; c += this.layout.blockStripe) {
                int blockNumber = this.layout.getBlockNumber(r, c);
                if (this.data[blockNumber] == null) continue;
                this.data[blockNumber] = order == BlockMatrixLayout.BlockOrder.ROWMAJOR ? this.layout.toRowMajorBlock(this.data[blockNumber], r, c) : this.layout.toColMajorBlock(this.data[blockNumber], r, c);
            }
        }
        BlockMatrixLayout.BlockOrder oldLayout = this.layout.blockOrder;
        this.layout = newLayout;
        return oldLayout;
    }
}

