/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.general.statistical;

import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;
import org.ujmp.core.doublematrix.calculation.general.missingvalues.CountMissing;
import org.ujmp.core.doublematrix.calculation.general.statistical.Sum;
import org.ujmp.core.mapmatrix.DefaultMapMatrix;
import org.ujmp.core.mapmatrix.MapMatrix;

public class Mean
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = 4116408128004680574L;
    private Matrix sum = null;
    private Matrix missingCount = null;
    private boolean ignoreNaN = false;

    public Mean(int dimension, boolean ignoreNaN, Matrix matrix) {
        super(dimension, matrix);
        this.ignoreNaN = ignoreNaN;
        MapMatrix<String, Object> aold = matrix.getMetaData();
        if (aold != null) {
            DefaultMapMatrix<String, Object> a = new DefaultMapMatrix<String, Object>();
            a.put("Label", aold.get("Label"));
            if (dimension == 0 || dimension == 1) {
                // empty if block
            }
            this.setMetaData(a);
        }
    }

    public double getDouble(long ... coordinates) {
        if (this.sum == null) {
            this.sum = new Sum(this.getDimension(), this.ignoreNaN, this.getSource()).calcNew();
        }
        if (this.ignoreNaN && this.missingCount == null) {
            this.missingCount = new CountMissing(this.getDimension(), this.getSource()).calcNew();
        }
        if (this.ignoreNaN) {
            switch (this.getDimension()) {
                case 0x7FFFFFFF: {
                    return this.sum.getAsDouble(0L, 0L) / ((double)Coordinates.product(this.getSource().getSize()) - this.missingCount.getAsDouble(0L, 0L));
                }
                case 0: {
                    return this.sum.getAsDouble(0L, coordinates[1]) / ((double)this.getSource().getRowCount() - this.missingCount.getAsDouble(0L, coordinates[1]));
                }
                case 1: {
                    return this.sum.getAsDouble(coordinates[0], 0L) / ((double)this.getSource().getColumnCount() - this.missingCount.getAsDouble(coordinates[0], 0L));
                }
            }
            return Double.NaN;
        }
        switch (this.getDimension()) {
            case 0x7FFFFFFF: {
                return this.sum.getAsDouble(0L, 0L) / (double)Coordinates.product(this.getSource().getSize());
            }
            case 0: {
                return this.sum.getAsDouble(0L, coordinates[1]) / (double)this.getSource().getRowCount();
            }
            case 1: {
                return this.sum.getAsDouble(coordinates[0], 0L) / (double)this.getSource().getColumnCount();
            }
        }
        return Double.NaN;
    }

    public long[] getSize() {
        switch (this.getDimension()) {
            case 0: {
                return new long[]{1L, this.getSource().getSize()[1]};
            }
            case 1: {
                return new long[]{this.getSource().getSize()[0], 1L};
            }
            case 0x7FFFFFFF: {
                return new long[]{1L, 1L};
            }
        }
        return null;
    }

    public static double calc(Matrix m) {
        double sum = 0.0;
        for (long[] c : m.availableCoordinates()) {
            sum += m.getAsDouble(c);
        }
        return sum / (double)Coordinates.product(m.getSize());
    }
}

