/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.general.misc;

import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;
import org.ujmp.core.doublematrix.calculation.general.misc.Center;
import org.ujmp.core.doublematrix.calculation.general.statistical.Std;

public class Standardize
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = 6454174968175712888L;
    private Matrix center = null;
    private Matrix sigma = null;

    public Standardize(int dimension, Matrix matrix) {
        super(dimension, matrix);
    }

    public double getDouble(long ... coordinates) {
        if (this.center == null) {
            this.center = new Center(true, this.getDimension(), this.getSource()).calcNew();
        }
        if (this.sigma == null) {
            this.sigma = new Std(this.getDimension(), true, this.center, true).calcNew();
        }
        switch (this.getDimension()) {
            case 0x7FFFFFFF: {
                return this.center.getAsDouble(coordinates) / this.sigma.getAsDouble(0L, 0L);
            }
            case 0: {
                return this.center.getAsDouble(coordinates) / this.sigma.getAsDouble(0L, coordinates[1]);
            }
            case 1: {
                return this.center.getAsDouble(coordinates) / this.sigma.getAsDouble(coordinates[0], 0L);
            }
        }
        return Double.NaN;
    }
}

