/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.general.misc;

import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;

public class MinkowskiDistance
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = -182036616301344756L;
    private final long[] size;
    private final double p;
    private final boolean ignoreNaN;

    public MinkowskiDistance(Matrix matrix, double p, boolean ignoreNaN) {
        super(matrix);
        this.p = p;
        this.size = new long[]{matrix.getRowCount(), matrix.getRowCount()};
        this.ignoreNaN = ignoreNaN;
    }

    public double getDouble(long ... coordinates) {
        Matrix m1 = this.getSource().selectRows(Calculation.Ret.LINK, coordinates[0]);
        Matrix m2 = this.getSource().selectRows(Calculation.Ret.LINK, coordinates[1]);
        return m1.minkowskiDistanceTo(m2, this.p, this.ignoreNaN);
    }

    public long[] getSize() {
        return this.size;
    }
}

