/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.collections.list;

import java.util.List;
import org.ujmp.core.collections.composite.SortedListSet;
import org.ujmp.core.genericmatrix.stub.AbstractDenseGenericMatrix2D;
import org.ujmp.core.mapmatrix.MapMatrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMapMatrixList<K, V>
extends AbstractDenseGenericMatrix2D<V> {
    private static final long serialVersionUID = -6522807188407425255L;
    private SortedListSet<K> keys = null;

    public AbstractMapMatrixList() {
        super(2L, 0L);
    }

    private SortedListSet<K> getKeys() {
        if (this.keys == null) {
            this.keys = new SortedListSet();
            for (MapMatrix<K, V> map : this.getList()) {
                this.keys.addAll(map.keySet());
            }
            for (int i = 0; i < this.keys.size(); ++i) {
                this.setColumnLabel(i, this.keys.get(i));
            }
        }
        return this.keys;
    }

    public abstract List<MapMatrix<K, V>> getList();

    @Override
    public long[] getSize() {
        this.size[0] = this.getList().size();
        this.size[1] = this.getKeys().size();
        return this.size;
    }

    @Override
    public V getObject(long row, long column) {
        return this.getObject((int)row, (int)column);
    }

    @Override
    public V getObject(int row, int column) {
        MapMatrix<K, V> map = this.getList().get(row);
        K key = this.getKeys().get(column);
        return map.get(key);
    }

    @Override
    public void setObject(V value, long row, long column) {
        this.setObject(value, (int)row, (int)column);
    }

    @Override
    public void setObject(V value, int row, int column) {
        MapMatrix<K, V> map = this.getList().get(row);
        K key = this.getKeys().get(column);
        map.put(key, value);
    }
}

