/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.charmatrix.stub;

import org.ujmp.core.charmatrix.CharMatrix;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.genericmatrix.stub.AbstractGenericMatrix;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.VerifyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCharMatrix
extends AbstractGenericMatrix<Character>
implements CharMatrix {
    private static final long serialVersionUID = 1967840166659276033L;

    public AbstractCharMatrix(long ... size) {
        super(size);
    }

    @Override
    public final Character getObject(long ... coordinates) {
        return Character.valueOf(this.getChar(coordinates));
    }

    @Override
    public final void setObject(Character o, long ... coordinates) {
        this.setChar(o.charValue(), coordinates);
    }

    @Override
    public final char getAsChar(long ... coordinates) {
        return this.getChar(coordinates);
    }

    @Override
    public final void setAsChar(char value, long ... coordinates) {
        this.setChar(value, coordinates);
    }

    @Override
    public final double getAsDouble(long ... coordinates) {
        return this.getChar(coordinates);
    }

    @Override
    public final void setAsDouble(double value, long ... coordinates) {
        VerifyUtil.verifyTrue(!MathUtil.isNaNOrInfinite(value), "Nan, Inf and -Inf not allowed in this matrix");
        this.setChar((char)value, coordinates);
    }

    @Override
    public final ValueType getValueType() {
        return ValueType.CHAR;
    }
}

