/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.calculation;

import org.ujmp.core.Coordinates;
import org.ujmp.core.SparseMatrix;
import org.ujmp.core.calculation.TransposeCalculation;
import org.ujmp.core.util.VerifyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TransposeSparseMatrix
implements TransposeCalculation<SparseMatrix, SparseMatrix> {
    TransposeSparseMatrix() {
    }

    @Override
    public final void calc(SparseMatrix source, SparseMatrix target) {
        VerifyUtil.verify2D(source);
        VerifyUtil.verify2D(target);
        VerifyUtil.verifyEquals(source.getRowCount(), target.getColumnCount(), "matrices have wrong size");
        VerifyUtil.verifyEquals(source.getColumnCount(), target.getRowCount(), "matrices have wrong size");
        for (long[] c : source.availableCoordinates()) {
            Object o = source.getAsObject(c);
            target.setAsObject(o, Coordinates.transpose(c));
        }
    }
}

