/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.calculation;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.ujmp.core.calculation.Mtimes;
import org.ujmp.core.calculation.MtimesCalculation;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.doublematrix.impl.BlockDenseDoubleMatrix2D;
import org.ujmp.core.doublematrix.impl.BlockMatrixLayout;
import org.ujmp.core.doublematrix.impl.BlockMultiply;
import org.ujmp.core.interfaces.HasColumnMajorDoubleArray1D;
import org.ujmp.core.interfaces.HasRowMajorDoubleArray2D;
import org.ujmp.core.util.UJMPSettings;
import org.ujmp.core.util.VerifyUtil;
import org.ujmp.core.util.concurrent.PFor;
import org.ujmp.core.util.concurrent.UJMPThreadPoolExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MtimesDenseDoubleMatrix2D
implements MtimesCalculation<DenseDoubleMatrix2D, DenseDoubleMatrix2D, DenseDoubleMatrix2D> {
    MtimesDenseDoubleMatrix2D() {
    }

    @Override
    public final void calc(DenseDoubleMatrix2D source1, DenseDoubleMatrix2D source2, DenseDoubleMatrix2D target) {
        VerifyUtil.verifyTrue(source1 != null, "a == null");
        VerifyUtil.verifyTrue(source2 != null, "b == null");
        VerifyUtil.verifyTrue(target != null, "c == null");
        VerifyUtil.verifyTrue(source1.getColumnCount() == source2.getRowCount(), "a.cols!=b.rows");
        VerifyUtil.verifyTrue(source1.getRowCount() == target.getRowCount(), "a.rows!=c.rows");
        VerifyUtil.verifyTrue(source2.getColumnCount() == target.getColumnCount(), "a.cols!=c.cols");
        if (source1.getRowCount() >= (long)Mtimes.THRESHOLD && source1.getColumnCount() >= (long)Mtimes.THRESHOLD) {
            if (Mtimes.MTIMES_JBLAS != null && UJMPSettings.getInstance().isUseJBlas()) {
                Mtimes.MTIMES_JBLAS.calc(source1, source2, target);
            } else if (UJMPSettings.getInstance().isUseBlockMatrixMultiply()) {
                this.calcBlockMatrixMultiThreaded(source1, source2, target);
            } else if (source1 instanceof HasColumnMajorDoubleArray1D && source2 instanceof HasColumnMajorDoubleArray1D && target instanceof HasColumnMajorDoubleArray1D) {
                this.calcDoubleArrayMultiThreaded(((HasColumnMajorDoubleArray1D)((Object)source1)).getColumnMajorDoubleArray1D(), (int)source1.getRowCount(), (int)source1.getColumnCount(), ((HasColumnMajorDoubleArray1D)((Object)source2)).getColumnMajorDoubleArray1D(), (int)source2.getRowCount(), (int)source2.getColumnCount(), ((HasColumnMajorDoubleArray1D)((Object)target)).getColumnMajorDoubleArray1D());
            } else if (source1 instanceof HasRowMajorDoubleArray2D && source2 instanceof HasRowMajorDoubleArray2D && target instanceof HasRowMajorDoubleArray2D) {
                this.calcDoubleArray2DMultiThreaded(((HasRowMajorDoubleArray2D)((Object)source1)).getRowMajorDoubleArray2D(), ((HasRowMajorDoubleArray2D)((Object)source2)).getRowMajorDoubleArray2D(), ((HasRowMajorDoubleArray2D)((Object)target)).getRowMajorDoubleArray2D());
            } else {
                this.calcDenseDoubleMatrix2DMultiThreaded(source1, source2, target);
            }
        } else if (source1 instanceof HasColumnMajorDoubleArray1D && source2 instanceof HasColumnMajorDoubleArray1D && target instanceof HasColumnMajorDoubleArray1D) {
            this.gemmDoubleArraySingleThreaded(((HasColumnMajorDoubleArray1D)((Object)source1)).getColumnMajorDoubleArray1D(), (int)source1.getRowCount(), (int)source1.getColumnCount(), ((HasColumnMajorDoubleArray1D)((Object)source2)).getColumnMajorDoubleArray1D(), (int)source2.getRowCount(), (int)source2.getColumnCount(), ((HasColumnMajorDoubleArray1D)((Object)target)).getColumnMajorDoubleArray1D());
        } else if (source1 instanceof HasRowMajorDoubleArray2D && source2 instanceof HasRowMajorDoubleArray2D && target instanceof HasRowMajorDoubleArray2D) {
            this.calcDoubleArray2DSingleThreaded(((HasRowMajorDoubleArray2D)((Object)source1)).getRowMajorDoubleArray2D(), ((HasRowMajorDoubleArray2D)((Object)source2)).getRowMajorDoubleArray2D(), ((HasRowMajorDoubleArray2D)((Object)target)).getRowMajorDoubleArray2D());
        } else {
            this.calcDenseDoubleMatrix2DSingleThreaded(source1, source2, target);
        }
    }

    private void calcBlockMatrixMultiThreaded(DenseDoubleMatrix2D source1, DenseDoubleMatrix2D source2, DenseDoubleMatrix2D target) {
        BlockDenseDoubleMatrix2D a = null;
        BlockDenseDoubleMatrix2D b = null;
        BlockDenseDoubleMatrix2D c = null;
        a = source1 instanceof BlockDenseDoubleMatrix2D ? (BlockDenseDoubleMatrix2D)source1 : new BlockDenseDoubleMatrix2D(source1);
        b = source2 instanceof BlockDenseDoubleMatrix2D && a.getBlockStripeSize() == ((BlockDenseDoubleMatrix2D)source2).getBlockStripeSize() ? (BlockDenseDoubleMatrix2D)source2 : new BlockDenseDoubleMatrix2D(source2, a.getBlockStripeSize(), BlockMatrixLayout.BlockOrder.COLUMNMAJOR);
        int arows = (int)a.getRowCount();
        int bcols = (int)b.getColumnCount();
        c = target instanceof BlockDenseDoubleMatrix2D && a.getBlockStripeSize() == ((BlockDenseDoubleMatrix2D)target).getBlockStripeSize() ? (BlockDenseDoubleMatrix2D)target : new BlockDenseDoubleMatrix2D(arows, bcols, a.getBlockStripeSize(), BlockMatrixLayout.BlockOrder.ROWMAJOR);
        BlockMatrixLayout.BlockOrder prevA = a.setBlockOrder(BlockMatrixLayout.BlockOrder.ROWMAJOR);
        BlockMatrixLayout.BlockOrder prevB = b.setBlockOrder(BlockMatrixLayout.BlockOrder.COLUMNMAJOR);
        this.blockMultiplyMultiThreaded(a, b, c);
        if (c != target) {
            int j = bcols;
            while (--j != -1) {
                int i = arows;
                while (--i != -1) {
                    target.setDouble(c.getDouble(i, j), i, j);
                }
            }
        }
    }

    private final void gemmDoubleArraySingleThreaded(double[] A, int m1RowCount, int m1ColumnCount, double[] B, int m2RowCount, int m2ColumnCount, double[] C) {
        for (int j = 0; j < m2ColumnCount; ++j) {
            int jcolTimesM1RowCount = j * m1RowCount;
            int jcolTimesM1ColumnCount = j * m1ColumnCount;
            Arrays.fill(C, jcolTimesM1RowCount, jcolTimesM1RowCount + m1RowCount, 0.0);
            for (int lcol = 0; lcol < m1ColumnCount; ++lcol) {
                double temp = B[lcol + jcolTimesM1ColumnCount];
                if (temp == 0.0) continue;
                int lcolTimesM1RowCount = lcol * m1RowCount;
                MtimesDenseDoubleMatrix2D.calcOneColumn(temp, A, C, m1RowCount, jcolTimesM1RowCount, lcolTimesM1RowCount);
            }
        }
    }

    private final void calcDoubleArrayMultiThreaded(final double[] A, final int m1RowCount, final int m1ColumnCount, final double[] B, int m2RowCount, int m2ColumnCount, final double[] C) {
        new PFor(0, m2ColumnCount - 1){

            public void step(int i) {
                int jcolTimesM1RowCount = i * m1RowCount;
                int jcolTimesM1ColumnCount = i * m1ColumnCount;
                Arrays.fill(C, jcolTimesM1RowCount, jcolTimesM1RowCount + m1RowCount, 0.0);
                for (int lcol = 0; lcol < m1ColumnCount; ++lcol) {
                    double temp = B[lcol + jcolTimesM1ColumnCount];
                    if (temp == 0.0) continue;
                    int lcolTimesM1RowCount = lcol * m1RowCount;
                    MtimesDenseDoubleMatrix2D.calcOneColumn(temp, A, C, m1RowCount, jcolTimesM1RowCount, lcolTimesM1RowCount);
                }
            }
        };
    }

    private static final void calcOneColumn(double temp, double[] A, double[] C, int m1RowCount, int index1, int index2) {
        for (int irow = 0; irow < m1RowCount; ++irow) {
            int n = index1++;
            C[n] = C[n] + A[index2++] * temp;
        }
    }

    private final void calcDoubleArray2DSingleThreaded(double[][] m1, double[][] m2, double[][] ret) {
        int columnCount = m1[0].length;
        double[] columns = new double[columnCount];
        int c = m2[0].length;
        while (--c != -1) {
            int k = columnCount;
            while (--k != -1) {
                columns[k] = m2[k][c];
            }
            int r = m1.length;
            while (--r != -1) {
                double sum = 0.0;
                double[] row = m1[r];
                int k2 = columnCount;
                while (--k2 != -1) {
                    sum += row[k2] * columns[k2];
                }
                ret[r][c] = sum;
            }
        }
    }

    private final void calcDoubleArray2DMultiThreaded(final double[][] m1, final double[][] m2, final double[][] ret) {
        final int columnCount = m1[0].length;
        final double[] columns = new double[columnCount];
        new PFor(0, m2[0].length - 1){

            public void step(int i) {
                int k = columnCount;
                while (--k != -1) {
                    columns[k] = m2[k][i];
                }
                int r = m1.length;
                while (--r != -1) {
                    double sum = 0.0;
                    double[] row = m1[r];
                    int k2 = columnCount;
                    while (--k2 != -1) {
                        sum += row[k2] * columns[k2];
                    }
                    ret[r][i] = sum;
                }
            }
        };
    }

    private final void calcDenseDoubleMatrix2DSingleThreaded(DenseDoubleMatrix2D A, DenseDoubleMatrix2D B, DenseDoubleMatrix2D C) {
        int m1RowCount = (int)A.getRowCount();
        int m1ColumnCount = (int)A.getColumnCount();
        int m2ColumnCount = (int)B.getColumnCount();
        for (int i = 0; i < m2ColumnCount; ++i) {
            for (int irow = 0; irow < m1RowCount; ++irow) {
                C.setDouble(0.0, irow, i);
            }
            for (int lcol = 0; lcol < m1ColumnCount; ++lcol) {
                double temp = B.getDouble(lcol, i);
                if (temp == 0.0) continue;
                for (int irow = 0; irow < m1RowCount; ++irow) {
                    C.setDouble(C.getDouble(irow, i) + A.getDouble(irow, lcol) * temp, irow, i);
                }
            }
        }
    }

    private final void calcDenseDoubleMatrix2DMultiThreaded(final DenseDoubleMatrix2D A, final DenseDoubleMatrix2D B, final DenseDoubleMatrix2D C) {
        final int m1RowCount = (int)A.getRowCount();
        final int m1ColumnCount = (int)A.getColumnCount();
        int m2ColumnCount = (int)B.getColumnCount();
        new PFor(0, m2ColumnCount - 1){

            public void step(int i) {
                for (int irow = 0; irow < m1RowCount; ++irow) {
                    C.setDouble(0.0, irow, i);
                }
                for (int lcol = 0; lcol < m1ColumnCount; ++lcol) {
                    double temp = B.getDouble(lcol, i);
                    if (temp == 0.0) continue;
                    for (int irow = 0; irow < m1RowCount; ++irow) {
                        C.setDouble(C.getDouble(irow, i) + A.getDouble(irow, lcol) * temp, irow, i);
                    }
                }
            }
        };
    }

    private BlockDenseDoubleMatrix2D blockMultiplyMultiThreaded(BlockDenseDoubleMatrix2D a, BlockDenseDoubleMatrix2D b, BlockDenseDoubleMatrix2D c) {
        int kStride;
        BlockMatrixLayout al = a.getBlockLayout();
        BlockMatrixLayout bl = b.getBlockLayout();
        VerifyUtil.verifyTrue(al.columns == bl.rows, "b.rows != this.columns");
        VerifyUtil.verifyTrue(al.blockStripe == bl.blockStripe, "block sizes differ: %s != %s", al.blockStripe, bl.blockStripe);
        LinkedList<BlockMultiply> tasks = new LinkedList<BlockMultiply>();
        int kMax = (int)b.getColumnCount();
        int jMax = (int)a.getColumnCount();
        int iMax = (int)a.getRowCount();
        int bColSlice = Math.min(al.blockStripe, kMax);
        int aColSlice = Math.min(al.blockStripe, jMax);
        int aRowSlice = Math.min(al.blockStripe, iMax);
        boolean blocksPerTask = true;
        int blocksPerTaskDimJ = this.selectBlocksPerTaskDimJ(al.blockStripe, iMax, jMax, kMax);
        for (int k = 0; k < kMax; k += kStride) {
            int jStride;
            kStride = Math.min(1 * bColSlice, kMax - k);
            for (int j = 0; j < jMax; j += jStride) {
                int iStride;
                jStride = Math.min(blocksPerTaskDimJ * aColSlice, jMax - j);
                for (int i = 0; i < iMax; i += iStride) {
                    iStride = Math.min(1 * aRowSlice, iMax - i);
                    tasks.add(new BlockMultiply(a, b, c, i, i + iStride, j, j + jStride, k, k + kStride));
                }
            }
        }
        try {
            for (Future f : UJMPThreadPoolExecutor.getInstance().invokeAll(tasks)) {
                f.get();
            }
        }
        catch (ExecutionException e) {
            StringBuilder sb = new StringBuilder("Execution exception - while awaiting completion of matrix multiplication [" + e.getMessage() + "]:");
            if (e.getCause() != null) {
                for (StackTraceElement stackTraceElement : e.getCause().getStackTrace()) {
                    sb.append(stackTraceElement).append("  *  ");
                }
            }
            throw new RuntimeException(sb.toString(), e.getCause());
        }
        catch (InterruptedException e) {
            String msg = "Interrupted - while awaiting completion of matrix multiplication.";
            throw new RuntimeException(msg + ": cause [" + e.getMessage() + "]", e);
        }
        return c;
    }

    private int selectBlocksPerTaskDimJ(int blockStripe, int iMax, int jMax, int kMax) {
        int adjust;
        int n = adjust = jMax % blockStripe > 0 ? 1 : 0;
        if (jMax < 5 * blockStripe || jMax <= iMax) {
            return jMax / blockStripe + adjust;
        }
        return Math.max(1, (jMax / blockStripe + adjust) / 2);
    }
}

