/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.calculation;

import java.math.BigDecimal;
import org.ujmp.core.DenseMatrix2D;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.MinusScalar;
import org.ujmp.core.calculation.MinusScalarCalculation;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.UJMPSettings;
import org.ujmp.core.util.VerifyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MinusScalarDenseMatrix2D
implements MinusScalarCalculation<DenseMatrix2D, DenseMatrix2D> {
    MinusScalarDenseMatrix2D() {
    }

    @Override
    public final void calc(DenseMatrix2D source, BigDecimal value, DenseMatrix2D target) {
        if (source instanceof DenseDoubleMatrix2D && target instanceof DenseDoubleMatrix2D) {
            MinusScalar.DENSEDOUBLEMATRIX2D.calc((DenseDoubleMatrix2D)source, value, (DenseDoubleMatrix2D)target);
        } else {
            MapMatrix<String, Object> a;
            VerifyUtil.verifySameSize((Matrix)source, (Matrix)target);
            int r = (int)source.getRowCount();
            while (--r != -1) {
                int c = (int)source.getColumnCount();
                while (--c != -1) {
                    BigDecimal svalue = source.getAsBigDecimal(r, c);
                    BigDecimal result = MathUtil.minus(svalue, value);
                    target.setAsBigDecimal(result, r, c);
                }
            }
            if (source != target && (a = source.getMetaData()) != null) {
                target.setMetaData(a.clone());
            }
        }
    }

    @Override
    public final void calc(DenseMatrix2D source, double value, DenseMatrix2D target) {
        if (source instanceof DenseDoubleMatrix2D && target instanceof DenseDoubleMatrix2D) {
            MinusScalar.DENSEDOUBLEMATRIX2D.calc((DenseDoubleMatrix2D)source, value, (DenseDoubleMatrix2D)target);
        } else {
            this.calc(source, new BigDecimal(value, UJMPSettings.getInstance().getMathContext()), target);
        }
    }
}

