/*
 * Decompiled with CFR 0.152.
 */
package xtools.gsea;

import edu.mit.broad.genome.alg.DatasetGenerators;
import edu.mit.broad.genome.alg.gsea.GeneSetCohort;
import edu.mit.broad.genome.alg.gsea.KSTests;
import edu.mit.broad.genome.math.RandomSeedGenerator;
import edu.mit.broad.genome.math.RandomSeedGenerators;
import edu.mit.broad.genome.objects.FeatureAnnot;
import edu.mit.broad.genome.objects.FeatureAnnotCollapseStrucMap;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentDb;
import edu.mit.broad.genome.objects.strucs.CollapsedDetails;
import edu.mit.broad.genome.parsers.EdbFolderParser;
import edu.mit.broad.genome.reports.EnrichmentReports;
import edu.mit.broad.genome.reports.api.ReportIndexState;
import edu.mit.broad.genome.reports.pages.HtmlPage;
import edu.mit.broad.genome.reports.pages.HtmlReportIndexPage;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.vdb.chip.FeatureAnnotChip;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import xtools.api.AbstractTool;
import xtools.api.param.BadParamException;
import xtools.api.param.BooleanParam;
import xtools.api.param.IntegerParam;
import xtools.api.param.Param;
import xtools.api.param.RankedListReqdParam;
import xtools.api.param.StringInputParam;
import xtools.gsea.AbstractGseaTool;
import xtools.gsea.ToolHelper;

public class GseaPreranked
extends AbstractGseaTool {
    private final RankedListReqdParam fRankedListParam = new RankedListReqdParam();
    private final IntegerParam fShowDetailsForTopXSetsParam = new IntegerParam("plot_top_x", "Plot graphs for the top sets of each phenotype", "Plot GSEA mountain and related plots for the top sets of each phenotype", 20, false, Param.ADVANCED);
    private final BooleanParam fMakeZippedReportParam = AbstractTool.createZipReportParam(false);
    private final BooleanParam fMakeGeneSetReportsParam = new BooleanParam("make_sets", "Make detailed gene set report", "Create detailed gene set reports (heat-map, mountain plot etc) for every enriched gene set", true, false, Param.ADVANCED);
    private final BooleanParam fCreateSvgsParam = new BooleanParam("create_svgs", "Create SVG plot images", "Create SVG plot images along with PNGs (GZ compressed to save space as these are very large)", false, false, Param.ADVANCED);
    private final StringInputParam fAltDelimParam = new StringInputParam("altDelim", "Alternate delimiter", "Optional alternate delimiter character for gene set names instead of comma", null, false, new char[]{';'}, Param.ADVANCED);

    public GseaPreranked(Properties properties) {
        super("Remap_Only", "Max_probe");
        super.init(properties, "");
    }

    public GseaPreranked(Properties properties, String paramFilePath) {
        super("Remap_Only", "Max_probe");
        super.init(properties, paramFilePath);
    }

    public GseaPreranked(String[] args) {
        super("Remap_Only", "Max_probe");
        super.init(args);
    }

    public GseaPreranked() {
        super("Remap_Only", "Abs_max_of_probes");
        this.declareParams();
    }

    @Override
    public String getName() {
        return "GSEAPreranked";
    }

    @Override
    public void execute() throws Exception {
        ReportIndexState state = new ReportIndexState(true, false, false, GseaPreranked.createHeader(this.fRankedListParam));
        this.startExec(state);
        RankedList fullRl = this.uniquize(this.fRankedListParam.getRankedList());
        if (fullRl.getSize() == 0) {
            throw new IllegalArgumentException("The chip and the ranked list did not match");
        }
        if (this.fAltDelimParam.isSpecified() && StringUtils.isNotBlank((CharSequence)this.fAltDelimParam.getValue().toString())) {
            this.fGeneSetMatrixParam.setAlternateDelimiter(this.fAltDelimParam.getValue().toString());
        }
        GeneSet[] origGeneSets = this.fGeneSetMatrixParam.getGeneSetMatrixCombo().getGeneSets();
        ToolHelper.validateMixedVersionAndSpecies(origGeneSets, this.fChipParam.getChip(), this.fReport, this.log);
        CollapsedDetails.Ranked cd = this.getRankedList(fullRl);
        this.execute_one(cd, origGeneSets);
        if (this.fMakeZippedReportParam.isTrue()) {
            this.fReport.closeReport(true);
            this.fReport.zipReport();
        }
        this.doneExec();
    }

    private void execute_one(CollapsedDetails.Ranked fullRL, GeneSet[] origGeneSets) throws Exception {
        int nperms = this.fNumPermParam.getIValue();
        int topXSets = this.fShowDetailsForTopXSetsParam.getIValue();
        RandomSeedGenerator rst = RandomSeedGenerators.lookup((String)this.fRndSeedTypeParam.getValue(), this);
        int minSize = this.fGeneSetMinSizeParam.getIValue();
        int maxSize = this.fGeneSetMaxSizeParam.getIValue();
        GeneSetCohort.Generator gcohgen = this.fGcohGenReqdParam.createGeneSetCohortGenerator(minSize, maxSize);
        boolean createSvgs = this.fCreateSvgsParam.isSpecified() && this.fCreateSvgsParam.isTrue();
        RankedList rl = fullRL.getRankedList();
        Chip chip = null;
        FeatureAnnot fann = null;
        if (this.fChipParam.isSpecified()) {
            chip = this.fChipParam.getChip();
            fann = fullRL.wasCollapsed ? new FeatureAnnotCollapseStrucMap("", fullRL.collapseStrucMap) : new FeatureAnnotChip(chip);
        } else {
            fann = new FeatureAnnot(rl.getName(), rl.getRankedNames(), null);
        }
        KSTests tests = new KSTests(this.getOutputStream());
        if (rst instanceof RandomSeedGenerators.Timestamp) {
            this.fReport.addComment("Timestamp used as the random seed: " + ((RandomSeedGenerators.Timestamp)rst).getTimestamp());
        }
        EnrichmentDb edb = tests.executeGsea(rl, origGeneSets, nperms, rst, chip, gcohgen);
        HtmlReportIndexPage reportIndexPage = this.fReport.getIndexPage();
        EnrichmentReports.Ret ret = EnrichmentReports.createGseaLikeReport(edb, this.getOutputStream(), (CollapsedDetails)fullRL, (HtmlPage)reportIndexPage, this.fReport, topXSets, minSize, maxSize, this.fMakeGeneSetReportsParam.isTrue(), this.fMakeZippedReportParam.isTrue(), createSvgs, origGeneSets, "PreRanked", this.fNormModeParam.getNormModeName(), fann);
        new EdbFolderParser().export((PersistentObject)ret.edb, ret.savedInDir);
    }

    @Override
    protected Param[] getAdditionalParams() {
        return new Param[]{this.fRankedListParam, this.fShowDetailsForTopXSetsParam, this.fMakeZippedReportParam, this.fMakeGeneSetReportsParam, this.fCreateSvgsParam, this.fAltDelimParam};
    }

    @Override
    public String getDesc() {
        return "Run GSEA on a pre-ranked (with external tools) gene list";
    }

    private CollapsedDetails.Ranked getRankedList(RankedList origRL) throws Exception {
        CollapsedDetails.Ranked cd = new CollapsedDetails.Ranked();
        cd.orig = origRL;
        if (this.fFeatureSpaceParam.isSymbols()) {
            if (!this.fChipParam.isSpecified()) {
                throw new BadParamException("Chip parameter must be specified as you asked to analyze in the space of gene symbols. Chip is used to collapse probe ids into symbols.", 1002);
            }
            Chip chip = this.fChipParam.getChip();
            int collapseModeIndex = this.fFeatureSpaceParam.isRemap() ? 5 : this.fCollapseModeParam.getStringIndexChoosen();
            DatasetGenerators.CollapsedRL collapsedRL = new DatasetGenerators().collapse(origRL, chip, this.fIncludeOnlySymbols.isTrue(), collapseModeIndex);
            RankedList collapsed = collapsedRL.symbolized;
            this.log.info("Collapsing dataset was done. Original: {} collapsed: {}", (Object)origRL.getQuickInfo(), (Object)collapsed.getQuickInfo());
            this.fReport.savePageTsv(collapsedRL.makeEtiologySdf());
            cd.chip = chip;
            cd.wasCollapsed = true;
            cd.collapsed = collapsed;
            cd.collapseStrucMap = collapsedRL.symbolCollapseStrucMap;
            this.checkIfCollapsedIsEmpty(cd);
        } else {
            cd.wasCollapsed = false;
            cd.collapsed = origRL;
            this.log.info("No ranked list collapsing was done .. using original as is");
        }
        return cd;
    }

    private void checkIfCollapsedIsEmpty(CollapsedDetails cd) {
        if (!cd.wasCollapsed) {
            return;
        }
        if (cd.getNumRow_orig() == 0) {
            return;
        }
        if (cd.getNumRow_collapsed() != 0) {
            return;
        }
        throw new BadParamException("The collapsed dataset was empty when used with chip:" + cd.getChipName(), 1005);
    }

    public static void main(String[] args) {
        GseaPreranked tool = new GseaPreranked(args);
        GseaPreranked.tool_main(tool);
    }

    static String createHeader(RankedListReqdParam dsr) {
        try {
            if (dsr.isSpecified()) {
                RankedList rl = dsr.getRankedList();
                StringBuilder buf = new StringBuilder();
                buf.append("<div id=\"footer\" style=\"width: 905; height: 35\">\n").append("<h3 style=\"text-align: left\"><font color=\"#808080\">GSEA Report for ").append("Dataset ").append(rl.getName()).append("</font></h3>\n").append("</div>");
                return buf.toString();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return null;
    }
}

