/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.io.expr.cls;

import edu.mit.broad.genome.utils.ParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.genepattern.io.expr.cls.IClsHandler;

public class ClsParser {
    static final String formatName = "cls";
    List suffixes = Collections.unmodifiableList(Arrays.asList("cls"));
    BufferedReader reader;
    int numClasses;
    int numItems;
    IClsHandler handler;

    public void parse(InputStream is) throws IOException, ParseException {
        this.reader = new BufferedReader(new InputStreamReader(is));
        this.read();
    }

    void read() throws IOException, ParseException {
        this.processHeader();
        String classifierLine = this.reader.readLine();
        String[] names = null;
        String dataLine = null;
        String[] assignments = null;
        HashMap<Integer, Object> classNumber2NameMap = new HashMap<Integer, Object>();
        if (this.hasClassNames(classifierLine)) {
            names = this.readClassNamesLine(classifierLine);
            int length = names.length;
            for (int i = 0; i < length; ++i) {
                classNumber2NameMap.put(new Integer(i), names[i]);
            }
            dataLine = this.reader.readLine();
            assignments = this.processData(dataLine, classNumber2NameMap);
        } else {
            names = new String[this.numClasses];
            for (int i = 0; i < this.numClasses; ++i) {
                names[i] = "" + i;
                classNumber2NameMap.put(new Integer(i), "" + i);
            }
            dataLine = classifierLine;
            assignments = this.processData(dataLine, classNumber2NameMap);
        }
        if (this.handler != null) {
            this.handler.classes(names);
            this.handler.assignments(assignments);
        }
    }

    private boolean hasClassNames(String classifierLine) {
        return classifierLine != null && classifierLine.length() > 2 && classifierLine.startsWith("#");
    }

    private void processHeader() throws IOException, ParseException {
        String headerLine = this.reader.readLine();
        if (headerLine == null) {
            throw new ParseException("No header line");
        }
        int[] hdrInts = new int[3];
        StringTokenizer tok = new StringTokenizer(headerLine, " \t");
        if (tok.countTokens() != 3) {
            throw new ParseException("Header line needs three numbers!\n\"" + headerLine + "\"");
        }
        try {
            for (int i = 0; i < 3; ++i) {
                hdrInts[i] = Integer.parseInt(tok.nextToken().trim());
            }
        }
        catch (NumberFormatException e) {
            throw new ParseException("Header line element '" + e.getMessage() + "' is not a number");
        }
        if (hdrInts[0] <= 0) {
            throw new ParseException("Header line missing first number, number of data points");
        }
        if (hdrInts[1] <= 0) {
            throw new ParseException("Header line missing second number, number of classes");
        }
        this.numClasses = hdrInts[1];
        this.numItems = hdrInts[0];
    }

    private String[] readClassNamesLine(String classifierLine) throws ParseException {
        StringTokenizer st = new StringTokenizer(classifierLine = classifierLine.substring(classifierLine.indexOf(35) + 1), " \t");
        if (st.countTokens() != this.numClasses) {
            throw new ParseException("First line specifies " + this.numClasses + " classes, but found " + st.countTokens() + ".");
        }
        String[] names = new String[this.numClasses];
        int ic = 0;
        while (st.hasMoreTokens()) {
            names[ic] = st.nextToken();
            ++ic;
        }
        return names;
    }

    private String[] processData(String data_line, Map classNumber2ClassNameMap) throws ParseException {
        if (data_line == null) {
            throw new ParseException("Missing data (numbers seperated by spaces) on 3rd line");
        }
        try {
            String[] assignments = new String[this.numItems];
            String[] tokens = data_line.split("[ \t]");
            if (tokens.length != this.numItems) {
                throw new ParseException("Header specifies " + this.numItems + " data points, but file contains " + tokens.length + " data points.");
            }
            for (int i = 0; i < tokens.length; ++i) {
                String name;
                int classNumber = Integer.parseInt(tokens[i].trim());
                if (classNumber >= this.numClasses || classNumber < 0) {
                    throw new ParseException("Header specifies " + this.numClasses + " classes, but data line contains a " + classNumber + ", a value that is too " + (classNumber < 0 ? "small" : "large") + ". All data for this file must be in the range 0-" + (this.numClasses - 1) + ".");
                }
                assignments[i] = name = (String)classNumber2ClassNameMap.get(new Integer(classNumber));
            }
            return assignments;
        }
        catch (NumberFormatException ex) {
            throw new ParseException("All values on the 3rd lines must be numbers.");
        }
    }

    public void setHandler(IClsHandler handler) {
        this.handler = handler;
    }
}

