/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.gsea;

import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.grid.FilterableTableModel;
import com.jidesoft.grid.QuickFilterPane;
import com.jidesoft.grid.QuickTableFilterField;
import com.jidesoft.grid.SortableTable;
import com.jidesoft.grid.SortableTableModel;
import com.jidesoft.swing.JideScrollPane;
import com.jidesoft.swing.JideTitledBorder;
import com.jidesoft.swing.PartialEtchedBorder;
import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.swing.GuiHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class ViewAndSearchComponent
extends JPanel {
    private SortableTable sortableTable;
    private QuickFilterPane quickFilterPane = new QuickFilterPane();
    private QuickTableFilterField filterField;
    private int numberOfGeneSets;
    private JLabel filteredLabel;
    private ControlPanel controlPanel;

    public void setTableModel(final TableModel tableModel) {
        this.numberOfGeneSets = tableModel.getRowCount();
        SwingUtilities.invokeLater(new Thread(){

            @Override
            public void run() {
                ViewAndSearchComponent.this.filteredLabel.setText(tableModel.getRowCount() + " out of " + ViewAndSearchComponent.this.numberOfGeneSets + " gene sets");
            }
        });
        this.quickFilterPane.setTableModel((TableModel)new SortableTableModel(tableModel));
        this.filterField.setTableModel(this.quickFilterPane.getDisplayTableModel());
        this.sortableTable.setModel((TableModel)this.filterField.getDisplayTableModel());
        this.filterField.getDisplayTableModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (e.getSource() instanceof FilterableTableModel) {
                    int count = ((TableModel)e.getSource()).getRowCount();
                    ViewAndSearchComponent.this.filteredLabel.setText(count + " out of " + ViewAndSearchComponent.this.numberOfGeneSets + " gene sets");
                }
            }
        });
    }

    public ViewAndSearchComponent(String runBtnText, int[] searchColumnIndices, ActionListener runListener, ActionListener reportListener, boolean includeRunPanel, JPanel topPanel) {
        this.quickFilterPane.setColumnIndices(searchColumnIndices);
        JPanel quickSearchPanel = new JPanel(new FlowLayout(3));
        this.filterField = new QuickTableFilterField();
        quickSearchPanel.add((Component)this.filterField);
        quickSearchPanel.setBorder((Border)new JideTitledBorder((Border)new PartialEtchedBorder(1, 1), "Filter Gene Sets", 4, 1));
        this.filteredLabel = new JLabel("   ");
        this.filteredLabel.setHorizontalAlignment(0);
        this.filteredLabel.setForeground(GuiHelper.COLOR_DARK_GREEN);
        this.filteredLabel.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        this.sortableTable = new SortableTable(){

            public String getToolTipText(MouseEvent event) {
                Object obj;
                String tip = null;
                Point p = event.getPoint();
                int hitColumnIndex = this.columnAtPoint(p);
                int hitRowIndex = this.rowAtPoint(p);
                if (hitColumnIndex != -1 && hitRowIndex != -1 && (obj = this.getValueAt(hitRowIndex, hitColumnIndex)) != null) {
                    tip = obj.toString();
                }
                if (tip == null) {
                    tip = this.getToolTipText();
                }
                return tip;
            }
        };
        this.sortableTable.setShowSortOrderNumber(false);
        this.sortableTable.getSelectionModel().setSelectionMode(2);
        this.filterField.setTable((JTable)this.sortableTable);
        JideScrollPane scrollPane = new JideScrollPane((Component)this.sortableTable, 22, 30);
        quickSearchPanel.add(this.filteredLabel);
        JPanel headerPanel = new JPanel(new BorderLayout());
        if (topPanel != null) {
            headerPanel.add((Component)topPanel, "North");
        }
        headerPanel.add((Component)quickSearchPanel, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)scrollPane, "Center");
        this.add((Component)headerPanel, "North");
        if (includeRunPanel) {
            this.controlPanel = new ControlPanel(runBtnText, runListener, reportListener, this.sortableTable);
            this.add((Component)((Object)this.controlPanel), "South");
        }
    }

    public TableSelectionListener getTableSelectionListener() {
        return this.controlPanel.tableSelectionListener;
    }

    public String[] getSelectedColumnArray(int columnIndex) {
        int[] rows = this.sortableTable.getSelectedRows();
        String[] names = new String[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            names[i] = this.sortableTable.getModel().getValueAt(rows[i], columnIndex).toString();
        }
        return names;
    }

    public SortableTable getTable() {
        return this.sortableTable;
    }

    public JPanel getButtonPanel() {
        return this.controlPanel;
    }

    private static class TableSelectionListener
    implements ListSelectionListener {
        private SortableTable table;
        private List list;

        public TableSelectionListener(SortableTable table) {
            table.getSelectionModel().addListSelectionListener(this);
            this.table = table;
            this.list = new ArrayList();
        }

        public void addComponent(Component c) {
            this.list.add(c);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            boolean enabled = this.table.getSelectedRows().length >= 2;
            int size = this.list.size();
            for (int i = 0; i < size; ++i) {
                ((Component)this.list.get(i)).setEnabled(enabled);
            }
        }
    }

    static class ControlPanel
    extends ButtonPanel {
        private JButton bLeadingEdge;
        private JButton buildhtmlReportBtn;
        private TableSelectionListener tableSelectionListener;
        private JLabel label;

        public ControlPanel(String runBtnText, ActionListener runListener, ActionListener reportListener, final SortableTable table) {
            this.setBorder(BorderFactory.createEmptyBorder(5, 10, 20, 10));
            JButton bHelp = JarResources.createHelpButton("post_hoc");
            this.addButton(bHelp, "HELP");
            this.label = new JLabel("For " + table.getSelectedRows().length + " selected gene sets: ");
            table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    label.setText("For " + table.getSelectedRows().length + " selected gene sets: ");
                }
            });
            this.add(this.label);
            this.bLeadingEdge = new JButton(runBtnText, GuiHelper.ICON_START16);
            this.bLeadingEdge.addActionListener(runListener);
            this.bLeadingEdge.setEnabled(false);
            this.tableSelectionListener = new TableSelectionListener(table);
            table.getSelectionModel().addListSelectionListener(this.tableSelectionListener);
            this.tableSelectionListener.addComponent(this.bLeadingEdge);
            this.add(this.bLeadingEdge);
            this.buildhtmlReportBtn = new JButton("Build HTML Report", GuiHelper.ICON_START16);
            this.buildhtmlReportBtn.addActionListener(reportListener);
            this.buildhtmlReportBtn.setEnabled(false);
            this.tableSelectionListener.addComponent(this.buildhtmlReportBtn);
            this.add(this.buildhtmlReportBtn);
        }
    }
}

