/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.annotation;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.genepattern.annotation.SetAnnotatorModel;
import org.genepattern.annotation.SparseClassVector;
import org.genepattern.uiutil.CenteredDialog;
import org.genepattern.uiutil.UIUtil;

public class FeatureClassEditor
extends CenteredDialog {
    private JComboBox classComboBox = new JComboBox();
    private JPanel colorPanel;
    private JButton deleteButton = new JButton("Delete");
    private JList list = new JList();
    private JScrollPane scrollPane = new JScrollPane(this.list);
    private MyClass selectedClass;
    private Container featureListContainer;
    private SparseClassVector classVector;
    private Frame parent;
    private SetAnnotatorModel model;

    public FeatureClassEditor(final Frame parent, SetAnnotatorModel model, SparseClassVector cv) {
        super(parent);
        this.parent = parent;
        this.model = model;
        this.classVector = cv;
        this.setTitle("Feature Annotations");
        this.colorPanel = new JPanel(){

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                int descent = g.getFontMetrics().getDescent();
                g.drawString("Click to edit...", 4, this.getHeight() - descent);
            }
        };
        this.colorPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Integer classNumber = ((MyClass)((FeatureClassEditor)FeatureClassEditor.this).classComboBox.getSelectedItem()).classNumber;
                Color c = JColorChooser.showDialog(parent, "Select Color", FeatureClassEditor.this.colorPanel.getBackground());
                if (c != null) {
                    FeatureClassEditor.this.colorPanel.setBackground(c);
                    FeatureClassEditor.this.classVector.setClass(classNumber, FeatureClassEditor.this.classVector.getClassName(classNumber), c);
                }
            }
        });
        this.colorPanel.setPreferredSize(new Dimension(100, 20));
        this.colorPanel.setMinimumSize(new Dimension(100, 20));
        this.colorPanel.setBorder(BorderFactory.createEtchedBorder());
        this.classComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureClassEditor.this.selectedClass = (MyClass)FeatureClassEditor.this.classComboBox.getSelectedItem();
                if (FeatureClassEditor.this.selectedClass != null) {
                    Color c = FeatureClassEditor.this.classVector.getColor(((FeatureClassEditor)FeatureClassEditor.this).selectedClass.classNumber);
                    FeatureClassEditor.this.colorPanel.setBackground(c);
                    FeatureClassEditor.this.setMembers(((FeatureClassEditor)FeatureClassEditor.this).selectedClass.classNumber);
                }
            }
        });
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (UIUtil.showConfirmDialog(parent, "Are you sure you want to delete " + ((FeatureClassEditor)FeatureClassEditor.this).selectedClass.className + "?")) {
                    // empty if block
                }
                FeatureClassEditor.this.classVector.removeClass(((FeatureClassEditor)FeatureClassEditor.this).selectedClass.classNumber);
            }
        });
        this.featureListContainer = new JPanel(new BorderLayout());
        Iterator classNumbers = this.classVector.getClassNumbers();
        while (classNumbers.hasNext()) {
            Integer i = (Integer)classNumbers.next();
            String className = this.classVector.getClassName(i);
            this.classComboBox.addItem(new MyClass(className, i));
        }
        if (this.classComboBox.getItemCount() == 0) {
            UIUtil.showMessageDialog(parent, "No feature annotations loaded.\nLoad feature annotations by clicking Open Feature List(s) on the File menu.");
            return;
        }
        this.classComboBox.setSelectedIndex(0);
        JPanel p = new JPanel();
        p.add(this.classComboBox);
        p.add(this.colorPanel);
        p.add(this.deleteButton);
        JPanel temp = new JPanel(new BorderLayout());
        temp.add((Component)p, "North");
        temp.add((Component)this.scrollPane, "Center");
        this.featureListContainer.add((Component)temp, "Center");
        this.setContentPane(this.featureListContainer);
        this.pack();
        this.setVisible(true);
    }

    private void setMembers(Integer classNumber) {
        Vector<String> members = new Vector<String>();
        List memberIndices = this.classVector.getMembers(classNumber);
        for (int i = 0; i < memberIndices.size(); ++i) {
            Integer row = (Integer)memberIndices.get(i);
            members.add(this.model.getName(row));
        }
        this.list.setListData(members);
    }

    private static class MyClass {
        String className;
        Integer classNumber;

        public MyClass(String className, Integer classNumber) {
            this.className = className;
            this.classNumber = classNumber;
        }

        public String toString() {
            return this.className;
        }
    }
}

