/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.core.api;

import com.jidesoft.dialog.ButtonPanel;
import edu.mit.broad.genome.Errors;
import edu.mit.broad.genome.swing.GuiHelper;
import edu.mit.broad.xbench.actions.ext.BrowserAction;
import edu.mit.broad.xbench.core.api.Application;
import edu.mit.broad.xbench.core.api.DialogDescriptor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xapps.gsea.GseaWebResources;
import xtools.api.param.Validator;

public class DialogDescriptorJide
implements DialogDescriptor {
    private static final Logger klog = LoggerFactory.getLogger(DialogDescriptorJide.class);
    private JPanel fMainPanel;
    private int fChoosenOption = -1;
    private boolean fModal = true;
    private JDialog fDialog;
    private String fTitle;
    private boolean showLicenseButton = false;
    private Action fHelpAction_opt;
    private Action fInfoAction_opt;
    private JButton bCancel;
    private JButton[] fCustomButtons;
    private boolean fAddCancelButton = true;
    private boolean fDisplayWider = false;
    private Validator warningValidator = null;
    private Validator errorValidator = null;
    JPanel botPanel;
    private JButton bOk;
    private ButtonPanel buttonPanel;

    public DialogDescriptorJide(String title, Component inputComp, Action help_action_opt) {
        this.fHelpAction_opt = help_action_opt;
        this.jbInit(title, inputComp);
    }

    public DialogDescriptorJide(String title, Component inputComp, Action help_action_opt, Action info_action_opt, boolean showLicenseButton) {
        this.showLicenseButton = showLicenseButton;
        this.fHelpAction_opt = help_action_opt;
        this.fInfoAction_opt = info_action_opt;
        this.jbInit(title, inputComp);
    }

    protected DialogDescriptorJide() {
    }

    protected void jbInit(String title, Component inputComp) {
        this.fTitle = title;
        this.fMainPanel = new JPanel(new BorderLayout(10, 10));
        this.fMainPanel.add(inputComp, "Center");
        this.bCancel = new JButton("Cancel");
    }

    protected void _jbInit_jit_buttons() {
        if (this.botPanel == null) {
            this.botPanel = new JPanel(new BorderLayout(3, 3));
            this.botPanel.add((Component)this.createButtonPanel(), "Center");
            this.botPanel.add(Box.createVerticalStrut(10), "South");
            this.fMainPanel.add((Component)this.botPanel, "Last");
            this.fMainPanel.setPreferredSize(this.fDisplayWider ? DD_SIZE_WIDER : DD_SIZE);
        }
    }

    @Override
    public int show() {
        this._jbInit_jit_buttons();
        this.fChoosenOption = 2;
        this.fDialog = new JDialog(Application.getWindowManager().getRootFrame(), this.fTitle, this.fModal);
        this.fDialog.setModal(this.fModal);
        this.fMainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.fDialog.setContentPane(this.fMainPanel);
        this.fDialog.setResizable(true);
        this.fDialog.pack();
        GuiHelper.centerComponent(this.fDialog);
        this.fDialog.setVisible(true);
        this.fDialog.requestFocus();
        return this.fChoosenOption;
    }

    @Override
    public void enableDoubleClickableJList(final JList jl) {
        jl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (jl.isSelectionEmpty()) {
                    return;
                }
                if (me.getClickCount() == 2) {
                    me.consume();
                    if (!DialogDescriptorJide.this.performValidationBeforeOK()) {
                        return;
                    }
                    DialogDescriptorJide.this.fChoosenOption = 0;
                    if (DialogDescriptorJide.this.fDialog != null) {
                        DialogDescriptorJide.this.fDialog.dispose();
                    }
                }
            }
        });
    }

    @Override
    public void setDisplayWider() {
        this.fDisplayWider = true;
        if (this.fMainPanel != null) {
            this.fMainPanel.setPreferredSize(DD_SIZE_WIDER);
        }
    }

    @Override
    public void setWarningValidator(Validator warningValidator) {
        this.warningValidator = warningValidator;
    }

    @Override
    public void setErrorValidator(Validator errorValidator) {
        this.errorValidator = errorValidator;
    }

    public void setButtons(JButton[] boptions) {
        this.fCustomButtons = boptions;
    }

    @Override
    public void setOnlyShowCloseOption() {
        this.fCustomButtons = new JButton[0];
        this.bCancel.setText("Close");
        this.fAddCancelButton = true;
    }

    private boolean performValidationBeforeOK() {
        if (this.errorValidator != null && !this.errorValidator.isValid()) {
            Errors errors = this.errorValidator.buildValidationFailedErrors();
            klog.error(errors.getName());
            Object errorMsg = "";
            String sep = "";
            for (String err : errors.getErrorsAsStrings()) {
                errorMsg = (String)errorMsg + sep + err;
                sep = SystemUtils.LINE_SEPARATOR;
            }
            Application.getWindowManager().showMessage(errors.getName(), (String)errorMsg);
            return false;
        }
        if (this.warningValidator != null && !this.warningValidator.isValid()) {
            Errors warnings = this.warningValidator.buildValidationFailedErrors();
            Object warningMsg = "";
            String sep = "";
            for (String w : warnings.getErrorsAsStrings()) {
                warningMsg = (String)warningMsg + sep + w;
                sep = SystemUtils.LINE_SEPARATOR;
            }
            boolean confirm = Application.getWindowManager().showConfirm(warnings.getName(), (String)warningMsg);
            if (!confirm) {
                return false;
            }
            klog.warn(warnings.getName());
        }
        return true;
    }

    private ButtonPanel createButtonPanel() {
        this.buttonPanel = new ButtonPanel();
        if (this.fCustomButtons != null) {
            for (int i = 0; i < this.fCustomButtons.length; ++i) {
                this.buttonPanel.addButton((AbstractButton)this.fCustomButtons[i]);
            }
            if (this.fAddCancelButton) {
                this.bCancel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DialogDescriptorJide.this.fChoosenOption = 2;
                        DialogDescriptorJide.this.fDialog.setVisible(false);
                        DialogDescriptorJide.this.fDialog.dispose();
                    }
                });
                this.buttonPanel.addButton((AbstractButton)this.bCancel, (Object)"CANCEL");
            }
        } else {
            this.bOk = new JButton("OK");
            this.buttonPanel.addButton((AbstractButton)this.bOk, (Object)"AFFIRMATIVE");
            this.buttonPanel.addButton((AbstractButton)this.bCancel, (Object)"CANCEL");
            if (this.fHelpAction_opt != null) {
                JButton bHelp = new JButton("Help");
                bHelp.setAction(this.fHelpAction_opt);
                this.buttonPanel.addButton((AbstractButton)bHelp, (Object)"HELP");
            }
            if (this.fInfoAction_opt != null) {
                JButton bInfo = new JButton("Info");
                bInfo.setAction(this.fInfoAction_opt);
                this.buttonPanel.addButton((AbstractButton)bInfo, (Object)"HELP");
            }
            if (this.showLicenseButton) {
                JButton bLicense = new JButton("MSigDB License", GuiHelper.ICON_HELP16);
                bLicense.addActionListener(new BrowserAction("MSigDB License", "MSigDB License Terms", GuiHelper.ICON_HELP16, GseaWebResources.getGseaBaseURL() + "/license_terms_list.jsp"));
                this.buttonPanel.addButton((AbstractButton)bLicense, (Object)"ALTERNATIVE");
            }
            this.bOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!DialogDescriptorJide.this.performValidationBeforeOK()) {
                        return;
                    }
                    DialogDescriptorJide.this.fChoosenOption = 0;
                    DialogDescriptorJide.this.fDialog.setVisible(false);
                    DialogDescriptorJide.this.fDialog.dispose();
                }
            });
            this.bCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogDescriptorJide.this.fChoosenOption = 2;
                    DialogDescriptorJide.this.fDialog.setVisible(false);
                    DialogDescriptorJide.this.fDialog.dispose();
                }
            });
        }
        return this.buttonPanel;
    }
}

