/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.vdb;

import edu.mit.broad.vdb.chip.Chip;
import java.io.File;
import java.util.WeakHashMap;

public class VdbRuntimeResources {
    private static WeakHashMap<String, Chip> kChipNameChipFileObject = new WeakHashMap();
    private static String FTP_ANNOTATION_BASE;
    private static String fChipLocBase;

    public static Chip getChip(String chipNameOrPath) {
        if (chipNameOrPath == null) {
            throw new IllegalArgumentException("Param chipNameOrPath cannot be null");
        }
        File tmpf = new File(chipNameOrPath = chipNameOrPath.trim());
        if (tmpf.exists() && tmpf.isFile() && tmpf.getName().endsWith(".chip")) {
            return new Chip(tmpf.getName(), tmpf.getPath());
        }
        Chip chip = kChipNameChipFileObject.get(chipNameOrPath);
        if (chip == null) {
            String chipFile_source = VdbRuntimeResources.getChipFile_source(chipNameOrPath);
            chip = new Chip(chipNameOrPath, chipFile_source);
            kChipNameChipFileObject.put(chipNameOrPath, chip);
        }
        return chip;
    }

    public static String getChipFile_source(String chipNameOrPath) {
        if (chipNameOrPath == null) {
            throw new IllegalArgumentException("Param chipNameOrPath cannot be null");
        }
        if (((String)chipNameOrPath).startsWith("ftp")) {
            if (((String)chipNameOrPath).startsWith("ftp.")) {
                chipNameOrPath = "ftp://" + (String)chipNameOrPath;
            }
            return chipNameOrPath;
        }
        if (((String)chipNameOrPath).startsWith("gseaftp")) {
            if (((String)chipNameOrPath).startsWith("gseaftp.")) {
                chipNameOrPath = "ftp://" + (String)chipNameOrPath;
            }
            return chipNameOrPath;
        }
        String path = fChipLocBase + (String)(chipNameOrPath = ((String)chipNameOrPath).replace('-', '_'));
        if (!path.endsWith(".chip")) {
            path = path + ".chip";
        }
        return path;
    }

    static {
        fChipLocBase = FTP_ANNOTATION_BASE = "ftp://gseaftp.broadinstitute.org/pub/gsea/annotations/";
    }
}

