/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.utils;

import edu.mit.broad.genome.utils.SystemUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;

public class FileUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int countLines(String path, boolean ignoreblanklines) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(new File(path))));){
            int numberOfLines = 0;
            if (!ignoreblanklines) {
                while (reader.readLine() != null) {
                    ++numberOfLines;
                }
            } else {
                String currLine = null;
                while ((currLine = reader.readLine()) != null) {
                    if (currLine.trim().length() <= 0) continue;
                    ++numberOfLines;
                }
            }
            int n = numberOfLines;
            return n;
        }
    }

    public static String shortenedPathRepresentation(File file) {
        if (file != null && file.getParentFile() != null) {
            return ".." + File.separator + file.getParentFile().getName() + File.separator + file.getName();
        }
        if (file != null) {
            return file.getName();
        }
        return null;
    }

    public static File findFile(File dir, String endsWith) {
        Collection allMatches = org.apache.commons.io.FileUtils.listFiles((File)dir, (String[])new String[]{endsWith}, (boolean)false);
        if (allMatches.isEmpty()) {
            throw new IllegalArgumentException("No file with endsWith: " + endsWith + " found in dir: " + dir + "\n");
        }
        return (File)allMatches.iterator().next();
    }

    public static boolean isLocked(File file) {
        if (!file.exists()) {
            return false;
        }
        File origFile = new File(file.getAbsolutePath());
        StringBuffer btmp = new StringBuffer(file.getName()).append(System.currentTimeMillis()).append(".lock_check");
        File newFile = new File(SystemUtils.getTmpDir(), btmp.toString());
        boolean able2rename = file.renameTo(newFile);
        if (!able2rename) {
            return true;
        }
        boolean movedback = newFile.renameTo(origFile);
        if (!movedback) {
            throw new IllegalStateException("Bad error - couldnt move file back after lock check");
        }
        return false;
    }
}

