/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.reports.pages;

import edu.mit.broad.genome.reports.api.ToolReport;
import edu.mit.broad.genome.reports.pages.HtmlFormat;
import edu.mit.broad.genome.reports.pages.HtmlPage;
import edu.mit.broad.genome.utils.DateUtils;
import edu.mit.broad.genome.utils.SystemUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.ecs.Element;
import org.apache.ecs.html.BR;
import org.apache.ecs.html.Div;
import org.apache.ecs.html.LI;
import org.apache.ecs.html.UL;
import xapps.gsea.GseaWebResources;

public class HtmlReportIndexPage
extends HtmlPage {
    private ToolReport fToolReport;
    private List fErrors;
    private boolean fFooterAdded;
    private boolean browseFooter = true;

    public HtmlReportIndexPage(ToolReport toolReport, String headerOpt) {
        this(toolReport, null, headerOpt);
    }

    public HtmlReportIndexPage(ToolReport toolReport, String specialSuffix, String headerOpt) {
        super("index", HtmlReportIndexPage._makeTitle(toolReport, specialSuffix));
        this.fToolReport = toolReport;
        this.addHeader(headerOpt);
    }

    private static String _makeTitle(ToolReport toolReport, String specialSuffix) {
        String title = "Index for " + toolReport.getProducerName() + " " + toolReport.getReportDir().getName();
        if (specialSuffix != null && specialSuffix.length() > 0) {
            title = title + " " + specialSuffix;
        }
        return title;
    }

    @Override
    public void addError(String error) {
        if (this.fErrors == null) {
            this.fErrors = new ArrayList();
        }
        this.fErrors.add(error);
    }

    private void addHeader(String headerOpt) {
        if (headerOpt == null) {
            return;
        }
        this.getDoc().appendBody(headerOpt);
    }

    public void setAddBrowseFooter(boolean addBrowseFolder) {
        this.browseFooter = addBrowseFolder;
    }

    private void addFooter() {
        if (!this.fFooterAdded) {
            Div div = new Div();
            div.addElement((Element)new BR());
            if (this.browseFooter) {
                UL ul = new UL();
                ul.addElement((Element)new LI((Element)HtmlFormat.Links.hyperDir("Browse result folder", this.fToolReport.getReportDir(), "")));
                ul.addElement((Element)new LI((Element)HtmlFormat.Links.hyper("View parameters used for this report", this.fToolReport.getParamsFile(), "", this.fToolReport.getReportDir())));
                div.addElement((Element)ul);
            }
            this.addBlock(div, false);
            String date = DateUtils.formatAsDayMonthYear(this.fToolReport.getDate()) + " " + DateUtils.formatAsHourMin(this.fToolReport.getDate());
            StringBuffer buf = new StringBuffer("<hr class=\"solid_line\"/>\n");
            buf.append("<div id=\"footer\">\n");
            buf.append("Report: ").append(this.fToolReport.getName()).append("&nbsp&nbsp ");
            buf.append("by user: ").append(SystemUtils.getUserName()).append("&nbsp&nbsp");
            buf.append("<div class=\"date\">").append(this.fToolReport.getProducerName()).append("&nbsp[").append(date).append(']').append("</div>\n");
            buf.append("<div class=\"contact\">Website: <a href=\"").append(GseaWebResources.getGseaBaseURL()).append("\">").append(GseaWebResources.getGseaURLDisplayName()).append("</a>\n");
            buf.append("Questions & Suggestions: <a href=\"").append(GseaWebResources.getGseaContactURL()).append("\">Contact page</a></div>\n");
            buf.append("<div class=\"spacer\">&nbsp;</div>\n");
            buf.append("</div>\n");
            this.getDoc().appendBody(buf.toString());
            this.fFooterAdded = true;
        }
    }

    @Override
    public void write(OutputStream os) throws IOException {
        this.addFooter();
        super.write(os);
    }
}

