/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.FeatureAnnot;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.parsers.AbstractParser;
import edu.mit.broad.genome.parsers.ParseUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class TxtDatasetParser
extends AbstractParser {
    public TxtDatasetParser() {
        super(Dataset.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void export(PersistentObject pob, File file) throws Exception {
        try {
            PrintWriter pw = this.startExport(pob, file);
            Dataset ds = (Dataset)pob;
            FeatureAnnot ann = ds.getAnnot().getFeatureAnnot();
            pw.print("NAME");
            pw.print('\t');
            pw.print("DESCRIPTION");
            for (int i = 0; i < ds.getNumCol(); ++i) {
                pw.print('\t');
                pw.print(ds.getColumnName(i));
            }
            pw.println();
            for (int r = 0; r < ds.getNumRow(); ++r) {
                String featname = ds.getRowName(r);
                pw.print(featname);
                pw.print('\t');
                String desc = ann.getNativeDesc(featname);
                if (desc != null) {
                    pw.print(desc);
                } else {
                    pw.print("na");
                }
                pw.print('\t');
                pw.println(ds.getRow(r).toString('\t'));
            }
        }
        finally {
            this.doneExport();
        }
    }

    @Override
    public List parse(String sourcepath, InputStream is) throws Exception {
        this.startImport(sourcepath);
        try (BufferedReader bin = new BufferedReader(new InputStreamReader(is));){
            String objName = NamingConventions.removeExtension(sourcepath);
            String currLine = this.nextLine(bin);
            List<String> colnames = ParseUtils.string2stringsList(currLine, "\t");
            colnames.remove(0);
            boolean hasDesc = false;
            String possibleDescToken = colnames.get(0).toString();
            if (possibleDescToken.equalsIgnoreCase("DESCRIPTION") || possibleDescToken.equalsIgnoreCase("DESC")) {
                colnames.remove(0);
                hasDesc = true;
            }
            this.log.debug("HAS DESC: {}", (Object)hasDesc);
            ArrayList<String> lines = new ArrayList<String>();
            currLine = this.nextLineTrimless(bin);
            while (currLine != null) {
                lines.add(currLine);
                currLine = this.nextLineTrimless(bin);
            }
            List list = this.parseTextMatrixToDataset(objName, lines, colnames, hasDesc);
            return list;
        }
    }
}

