/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.APMMatrix;
import edu.mit.broad.genome.objects.Annot;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultDataset;
import edu.mit.broad.genome.objects.FeatureAnnot;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.SampleAnnot;
import edu.mit.broad.genome.parsers.AbstractParser;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.parsers.ParserException;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class ResParser
extends AbstractParser {
    public ResParser() {
        super(Dataset.class);
    }

    @Override
    public void export(PersistentObject pob, File file) throws Exception {
        PrintWriter pw = this.startExport(pob, file);
        Dataset ds = (Dataset)pob;
        APMMatrix apm = null;
        if (ds instanceof DefaultDataset) {
            apm = ((DefaultDataset)ds).getAPMMatrix();
        }
        FeatureAnnot ann = ds.getAnnot().getFeatureAnnot();
        pw.print("DESCRIPTION\tNAME\t");
        for (int i = 0; i < ds.getNumCol(); ++i) {
            pw.print(ds.getColumnName(i) + "\t");
            if (i == ds.getNumCol() - 1) continue;
            pw.print('\t');
        }
        pw.println();
        pw.println("");
        pw.println(ds.getNumRow());
        for (int r = 0; r < ds.getNumRow(); ++r) {
            String featName = ds.getRowName(r);
            Object featDesc = "na";
            if (ann != null) {
                featDesc = ann.hasNativeDescriptions() ? ann.getNativeDesc(featName) : ann.getGeneSymbol(featName) + ":" + ann.getGeneTitle(featName);
            }
            pw.print((String)featDesc);
            pw.print('\t');
            pw.print(featName);
            pw.print('\t');
            Vector row = ds.getRow(r);
            StringBuffer buf = new StringBuffer();
            for (int c = 0; c < row.getSize(); ++c) {
                if (apm == null) {
                    buf.append(row.getElement(c)).append('\t').append('P');
                } else {
                    buf.append(row.getElement(c)).append('\t').append(apm.getElement_char(r, c));
                }
                if (c == row.getSize()) continue;
                buf.append('\t');
            }
            pw.println(buf.toString());
        }
        pw.close();
        this.doneExport();
    }

    @Override
    public List parse(String sourcepath, InputStream is) throws Exception {
        this.startImport(sourcepath);
        int currLineNum = 0;
        StringBuffer comment = new StringBuffer();
        BufferedReader bin = new BufferedReader(new InputStreamReader(is));
        String currLine = bin.readLine();
        while (currLine.startsWith("#")) {
            comment.append(currLine).append('\n');
            currLine = bin.readLine();
        }
        ++currLineNum;
        ArrayList<String> colArr = new ArrayList<String>();
        int theDelim = 9;
        char[] tmpChar = new char[1];
        if (currLine.length() > 0) {
            tmpChar[0] = theDelim = (int)ParseUtils.getDelim(currLine);
            StringTokenizer st = new StringTokenizer(currLine, new String(tmpChar));
            if (st.hasMoreTokens()) {
                st.nextToken();
            }
            if (st.hasMoreTokens()) {
                st.nextToken();
            }
            while (st.hasMoreTokens()) {
                colArr.add(st.nextToken());
            }
        }
        bin.readLine();
        ++currLineNum;
        currLine = bin.readLine();
        ++currLineNum;
        int numRows = 0;
        int numCols = colArr.size();
        try {
            String intStr = currLine.trim();
            numRows = Integer.parseInt(intStr);
            currLine = bin.readLine();
            ++currLineNum;
        }
        catch (Exception intStr) {
            // empty catch block
        }
        this.log.info("Found meg data as numRows:{} numCols:{}", (Object)numRows, (Object)numCols);
        ArrayList<String> colNames = new ArrayList<String>(numCols);
        for (int i = 0; i < numCols; ++i) {
            colNames.add((String)colArr.get(i));
        }
        Matrix matrix = new Matrix(numRows, numCols);
        APMMatrix apmMatrix = new APMMatrix(numRows, numCols);
        ArrayList<String> rowNames = new ArrayList<String>(numRows);
        ArrayList<String> rowDescs = new ArrayList<String>(numRows);
        int dataRowInd = 0;
        while (currLine != null) {
            if (currLine.length() == 0) {
                currLine = bin.readLine();
                continue;
            }
            int ind1 = currLine.indexOf(theDelim);
            this.checkIndex(ind1, currLineNum);
            String desc = currLine.substring(0, ind1);
            int ind2 = currLine.indexOf(theDelim, ind1 + 1);
            this.checkIndex(ind2, currLineNum);
            String name = currLine.substring(ind1 + 1, ind2);
            rowNames.add(name);
            float[] theFloats = new float[numCols];
            float[] theCalls = new float[numCols];
            ind1 = ind2;
            for (int i = 0; i < numCols; ++i) {
                ind2 = currLine.indexOf(theDelim, ind1 + 1);
                this.checkIndex(ind2, currLineNum);
                String floatStr = currLine.substring(ind1 + 1, ind2);
                theFloats[i] = Float.valueOf(floatStr).floatValue();
                String apStr = currLine.substring(ind1 + 1 + floatStr.length() + 1, ind1 + 1 + floatStr.length() + 1 + 1);
                theCalls[i] = APMMatrix.valueOf(apStr);
                ind1 = currLine.indexOf(theDelim, ind2 + 1);
            }
            matrix.setRow(dataRowInd, theFloats);
            apmMatrix.setRow(dataRowInd, theCalls);
            rowDescs.add(desc);
            ++dataRowInd;
            currLine = bin.readLine();
            ++currLineNum;
        }
        this.doneImport();
        FeatureAnnot fann = new FeatureAnnot(sourcepath, rowNames, rowDescs);
        fann.addComment(this.fComment.toString());
        SampleAnnot sann = new SampleAnnot(sourcepath, colNames);
        DefaultDataset ds = new DefaultDataset(sourcepath, matrix, rowNames, colNames, new Annot(fann, sann), apmMatrix);
        ds.addComment(this.fComment.toString());
        System.out.println(">>>>> DONE PARSING: " + apmMatrix.getQuickInfo());
        return ResParser.unmodlist(new PersistentObject[]{ds});
    }

    private void checkIndex(int ind, int lineNum) throws ParserException {
        if (ind < 0) {
            throw new ParserException("Invalid line index=" + ind + " . Expecting ind >=0  on line: " + lineNum);
        }
    }
}

