/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.alg.RankedListGenerators;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.parsers.AbstractParser;
import edu.mit.broad.genome.parsers.ParserException;
import gnu.trove.TFloatArrayList;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class RankedListParser
extends AbstractParser {
    public RankedListParser() {
        super(RankedList.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void export(PersistentObject pob, File file) throws Exception {
        RankedList rl = (RankedList)pob;
        try (PrintWriter pw = this.startExport(pob, file);){
            int size = rl.getSize();
            for (int i = 0; i < size; ++i) {
                pw.print(rl.getRankName(i));
                pw.print("\t");
                pw.println(rl.getScore(i));
            }
        }
        finally {
            this.doneExport();
        }
    }

    @Override
    public List parse(String sourcepath, InputStream is) throws Exception {
        this.startImport(sourcepath);
        try (BufferedReader bin = new BufferedReader(new InputStreamReader(is));){
            String objname = NamingConventions.removeExtension(new File(sourcepath).getName());
            ArrayList<String> names = new ArrayList<String>();
            TFloatArrayList floats = new TFloatArrayList();
            int skippedMissingRows = 0;
            boolean foundInfiniteValues = false;
            int row = 0;
            String currLine = this.nextLine(bin);
            if (currLine == null) {
                throw new ParserException("RNK file was empty!");
            }
            List<String> fields = RankedListParser.string2stringsV2(currLine, 2);
            if (fields.get(0).equalsIgnoreCase("Name") || fields.get(1).equalsIgnoreCase("Rank")) {
                currLine = this.nextLine(bin);
            }
            while (currLine != null) {
                fields = RankedListParser.string2stringsV2(currLine, 2);
                String name = this.parseRowname(fields.get(0).trim(), row++);
                try {
                    float value = this.parseStringToFloat(fields.get(1), true);
                    if (!Float.isNaN(value)) {
                        names.add(name);
                        floats.add(value);
                        if (Float.isInfinite(value)) {
                            foundInfiniteValues = true;
                            this.log.warn("Infinite values found in row {} of the data matrix with Name '{}'.", (Object)(row + 1), (Object)name);
                        }
                    } else {
                        ++skippedMissingRows;
                        this.log.warn("Missing value found in row {} of the data matrix with Name '{}'.", (Object)(row + 1), (Object)name);
                    }
                }
                catch (NumberFormatException nfe) {
                    this.log.error("Could not parse '{}' as a floating point number in row {} of the data matrix with Name '{}'.", new Object[]{fields.get(1), row + 1, name});
                    throw nfe;
                }
                currLine = this.nextLine(bin);
            }
            if (floats.isEmpty()) {
                throw new ParserException("Data was missing in all rows!");
            }
            this.doneImport();
            RankedList rl = RankedListGenerators.createBySorting(objname, names.toArray(new String[names.size()]), floats.toNativeArray(), SortMode.REAL, Order.DESCENDING);
            if (rl.getSize() <= 2000) {
                String warning = "Loaded RNK with " + rl.getSize() + " features.  This may be too few for GSEA, which expects data for all expressed genes for a proper analysis.";
                this.log.warn(warning);
                rl.addWarning(warning);
            }
            if (foundInfiniteValues) {
                String warning = "Infinite values detected in this RNK file. This may cause unexpected results in the calculations or failures in plotting.";
                this.log.warn(warning);
                rl.addWarning(warning + "  See the log for more details.");
            }
            if (skippedMissingRows > 0) {
                String warning = "There were " + skippedMissingRows + " row(s) in total of missing data in this RNK file.  These will be ignored.";
                this.log.warn(warning);
                rl.addWarning(warning + "  See the log for more details.");
            }
            List list = RankedListParser.unmodlist(rl);
            return list;
        }
    }
}

