/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.objects.Annot;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultDataset;
import edu.mit.broad.genome.objects.FeatureAnnot;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.SampleAnnot;
import edu.mit.broad.genome.parsers.AbstractParser;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.parsers.ParserException;
import edu.mit.broad.genome.utils.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class PclParser
extends AbstractParser {
    protected PclParser() {
        super(Dataset.class);
    }

    @Override
    public void export(PersistentObject pob, File file) throws Exception {
        int i;
        PrintWriter pw = new PrintWriter(new FileOutputStream(file));
        Dataset ds = (Dataset)pob;
        FeatureAnnot ann = ds.getAnnot().getFeatureAnnot();
        pw.print("UNIQUID\tNAME\tGWEIGHT\t");
        for (i = 0; i < ds.getNumCol(); ++i) {
            pw.print(ds.getColumnName(i));
            if (i == ds.getNumCol() - 1) continue;
            pw.print('\t');
        }
        pw.println();
        pw.print("EWEIGHT\t\t\t");
        for (i = 0; i < ds.getNumCol(); ++i) {
            pw.print("1");
            if (i == ds.getNumCol() - 1) continue;
            pw.print('\t');
        }
        pw.println();
        for (int r = 0; r < ds.getNumRow(); ++r) {
            StringBuffer buf = new StringBuffer();
            String rowName = ds.getRowName(r);
            buf.append(rowName).append('\t');
            buf.append(ann.getNativeDesc(rowName)).append('\t');
            buf.append("1\t");
            buf.append(ds.getRow(r).toString('\t'));
            pw.println(buf.toString());
        }
        pw.close();
        this.doneExport();
    }

    @Override
    public List parse(String hackINeedFullPath, InputStream is) throws Exception {
        this.startImport(hackINeedFullPath);
        int nlines = FileUtils.countLines(hackINeedFullPath, true);
        int nfloatlines = nlines - 2;
        this.log.debug("Number of float lines = {}", (Object)nfloatlines);
        try (BufferedReader bin = new BufferedReader(new InputStreamReader(is));){
            Object warning;
            String currLine = this.nextLine(bin);
            List<String> colNames = ParseUtils.string2stringsList(currLine, "\t");
            int expectedNCols = colNames.size();
            colNames.remove(0);
            colNames.remove(0);
            colNames.remove(0);
            this.log.debug("Number of columns of floats = {}", (Object)colNames.size());
            this.nextLine(bin);
            ArrayList<String> rowNames = new ArrayList<String>(nfloatlines);
            ArrayList<String> rowDescs = new ArrayList<String>(nfloatlines);
            ArrayList<float[]> data = new ArrayList<float[]>(nfloatlines);
            int skippedMissingRows = 0;
            int partialMissingRows = 0;
            boolean foundInfiniteValues = false;
            int r = 0;
            currLine = this.nextLineTrimless(bin);
            while (currLine != null) {
                List<String> fields = PclParser.string2stringsV2(currLine, expectedNCols);
                if (fields.size() != expectedNCols) {
                    throw new ParserException("Invalid format on line: " + currLine + " expected # fields = " + expectedNCols + " but found: " + fields.size());
                }
                String rowName = fields.get(0).toString().trim();
                if (rowName.length() == 0) {
                    throw new ParserException("Bad rowname - cant be empty at: " + r + " >" + currLine);
                }
                String desc = fields.get(1).toString().trim();
                if (desc.length() == 0) {
                    throw new ParserException("Bad rowdescname - cant be empty at: " + r + " >" + currLine);
                }
                if (Integer.parseInt(fields.get(2).toString()) != 1) {
                    throw new ParserException("Expected field was not 1 for GWEIGHT: " + fields.get(2) + " " + currLine);
                }
                float[] dataRow = this.parseFieldsIntoFloatArray(fields, r, 3, rowName);
                int countMissing = this.countMissingValues(dataRow, r, rowName);
                if (countMissing < dataRow.length) {
                    if (countMissing > 0) {
                        ++partialMissingRows;
                    }
                    data.add(dataRow);
                    rowNames.add(rowName);
                    rowDescs.add(desc);
                } else {
                    ++skippedMissingRows;
                }
                foundInfiniteValues |= this.checkForInfiniteValues(dataRow, r, rowName);
                ++r;
                currLine = this.nextLineTrimless(bin);
            }
            if (data.isEmpty()) {
                throw new ParserException("Data was missing in all rows!");
            }
            Matrix matrix = new Matrix(data.size(), colNames.size());
            for (int i = 0; i < data.size(); ++i) {
                matrix.setRow(i, (float[])data.get(i));
            }
            String name = new File(hackINeedFullPath).getName();
            FeatureAnnot fann = new FeatureAnnot(name, rowNames, rowDescs);
            fann.addComment(this.fComment.toString());
            SampleAnnot sann = new SampleAnnot(name, colNames);
            DefaultDataset ds = new DefaultDataset(name, matrix, rowNames, colNames, new Annot(fann, sann));
            ds.addComment(this.fComment.toString());
            if (foundInfiniteValues) {
                warning = "Infinite values detected in this dataset. This may cause unexpected results in the calculations or failures in plotting.";
                this.log.warn((String)warning);
                ds.addWarning((String)warning + "  See the log for more details.");
            }
            if (partialMissingRows > 0) {
                warning = "There were " + partialMissingRows + " row(s) in total with partially missing data in this dataset.";
                this.log.warn((String)warning);
                ds.addWarning((String)warning + "  See the log for more details.");
            }
            if (skippedMissingRows > 0) {
                warning = "There were " + skippedMissingRows + " row(s) in total with all data missing in this dataset.  These will be ignored.";
                this.log.warn((String)warning);
                ds.addWarning((String)warning + "  See the log for more details.");
            }
            this.doneImport();
            List list = PclParser.unmodlist(new PersistentObject[]{ds});
            return list;
        }
    }
}

