/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.FeatureAnnot;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.parsers.AbstractParser;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.parsers.ParserException;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class GctParser
extends AbstractParser {
    public GctParser() {
        super(Dataset.class);
    }

    @Override
    public void export(PersistentObject pob, File file) throws Exception {
        this._export(pob, this.startExport(pob, file));
    }

    @Override
    public void export(PersistentObject pob, OutputStream os) throws Exception {
        this._export(pob, this.startExport(pob, os, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _export(PersistentObject pob, PrintWriter pw) throws Exception {
        try {
            Dataset ds = (Dataset)pob;
            FeatureAnnot ann = null;
            if (ds.getAnnot() != null) {
                ann = ds.getAnnot().getFeatureAnnot();
            }
            pw.println("#1.2");
            pw.println(ds.getNumRow() + "\t" + ds.getNumCol());
            pw.print("NAME");
            pw.print("\t");
            pw.print("DESCRIPTION");
            for (int i = 0; i < ds.getNumCol(); ++i) {
                pw.print("\t");
                pw.print(ds.getColumnName(i));
            }
            pw.println();
            for (int r = 0; r < ds.getNumRow(); ++r) {
                StringBuffer buf = new StringBuffer();
                String rowName = ds.getRowName(r);
                buf.append(rowName).append('\t');
                Object desc = "na";
                if (ann != null) {
                    if (ann.hasNativeDescriptions()) {
                        desc = ann.getNativeDesc(rowName);
                    } else {
                        String symbol = ann.getGeneSymbol(rowName);
                        if (symbol != null) {
                            desc = symbol + ":" + ann.getGeneTitle(rowName);
                        }
                    }
                }
                if (desc == null) {
                    desc = "na";
                }
                buf.append((String)desc).append('\t');
                buf.append(ds.getRow(r).toString('\t'));
                pw.println(buf.toString());
            }
        }
        finally {
            this.doneExport();
        }
    }

    @Override
    public List parse(String sourcepath, InputStream is) throws Exception {
        this.startImport(sourcepath);
        try (BufferedReader bin = new BufferedReader(new InputStreamReader(is));){
            String objName = NamingConventions.removeExtension(sourcepath);
            String currLine = this.nextLine(bin);
            int[] nstuff = ParseUtils.string2ints(currLine, " \t");
            if (nstuff.length != 2) {
                throw new ParserException("Gct file with bad row/col info on line 2: " + currLine);
            }
            int nrows = nstuff[0];
            int ncols = nstuff[1];
            currLine = this.nextLine(bin);
            List<String> colnames = ParseUtils.string2stringsList(currLine, "\t");
            colnames.remove(0);
            colnames.remove(0);
            if (colnames.size() != ncols) {
                throw new ParserException("Bad gct format -- expected ncols from specification on header line: " + ncols + " but found in data: " + colnames.size());
            }
            ArrayList<String> lines = new ArrayList<String>();
            currLine = this.nextLineTrimless(bin);
            while (currLine != null) {
                lines.add(currLine);
                currLine = this.nextLineTrimless(bin);
            }
            if (lines.size() != nrows) {
                throw new ParserException("Bad gct format -- exepcted nrows from specification on header line: " + nrows + " but found in data: " + lines.size());
            }
            List list = this.parseTextMatrixToDataset(objName, lines, colnames, true);
            return list;
        }
    }
}

