/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.objects.Dataframe;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.parsers.AbstractParser;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.parsers.ParserException;
import gnu.trove.TFloatArrayList;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class DataframeParser
extends AbstractParser {
    public DataframeParser() {
        super(Dataframe.class);
    }

    @Override
    public void export(PersistentObject pob, File file) throws Exception {
        PrintWriter pw = this.startExport(pob, file);
        this._export(pob, pw);
    }

    @Override
    public void export(PersistentObject pob, OutputStream os) throws Exception {
        PrintWriter pw = this.startExport(pob, os, null);
        this._export(pob, pw);
    }

    private void _export(PersistentObject pob, PrintWriter pw) throws Exception {
        Dataframe df = (Dataframe)pob;
        pw.print("NAME\t");
        for (int i = 0; i < df.getNumCol(); ++i) {
            pw.print(df.getColumnName(i));
            pw.print('\t');
        }
        pw.println();
        for (int r = 0; r < df.getNumRow(); ++r) {
            pw.print(df.getRowName(r));
            pw.print('\t');
            pw.println(df.getRow(r).toString('\t'));
        }
        pw.close();
        this.doneExport();
    }

    @Override
    public List parse(String sourcepath, InputStream is) throws Exception {
        BufferedReader bin = new BufferedReader(new InputStreamReader(is));
        return this._parse(sourcepath, bin);
    }

    protected Dataframe parseDf(String sourcepath, BufferedReader bin) throws Exception {
        this.startImport(sourcepath);
        String currLine = this.nextLine(bin);
        List<String> colNames = ParseUtils.string2stringsList(currLine, " \t");
        colNames.remove(0);
        currLine = this.nextLine(bin);
        TFloatArrayList floats = new TFloatArrayList();
        ArrayList<String> rowNames = new ArrayList<String>();
        while (currLine != null) {
            List<String> fields = ParseUtils.string2stringsList(currLine, " \t");
            if (fields.size() != colNames.size() + 1) {
                throw new ParserException("Bad format - expect ncols: " + (colNames.size() + 1) + " but found: " + fields.size() + " on line: " + currLine);
            }
            String rowName = fields.get(0);
            rowNames.add(rowName);
            for (int f = 1; f < fields.size(); ++f) {
                floats.add(Float.parseFloat(fields.get(f).toString()));
            }
            currLine = this.nextLine(bin);
        }
        bin.close();
        this.doneImport();
        this.log.info("Completed parsing DATAFRAME");
        Matrix matrix = new Matrix(rowNames.size(), colNames.size(), floats);
        Dataframe df = new Dataframe(sourcepath, matrix, rowNames, colNames, true, true, true);
        df.addComment(this.fComment.toString());
        return df;
    }

    private List _parse(String sourcepath, BufferedReader bin) throws Exception {
        Dataframe df = this.parseDf(sourcepath, bin);
        return DataframeParser.unmodlist(new PersistentObject[]{df});
    }
}

