/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.NotImplementedException;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.objects.Annot;
import edu.mit.broad.genome.objects.DefaultDataset;
import edu.mit.broad.genome.objects.FeatureAnnot;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.SampleAnnot;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.parsers.Parser;
import edu.mit.broad.genome.parsers.ParserException;
import edu.mit.broad.genome.utils.ClassUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractParser
implements Parser {
    protected final Logger log;
    protected final Comment fComment;
    private Class fRepClass;
    private String fRepClassName;
    private File _importFile;
    private Object _importObjName;
    private PrintWriter _exportPw;
    private boolean fSilentMode;

    protected AbstractParser(Class repClass) {
        if (repClass == null) {
            throw new IllegalArgumentException("Parameter repClass cannot be null");
        }
        this.log = LoggerFactory.getLogger((Class)repClass);
        this.fComment = new Comment();
        this.fRepClass = repClass;
        this.fRepClassName = ClassUtils.shorten(this.fRepClass);
    }

    public void export(PersistentObject pob, OutputStream os) throws Exception {
        throw new NotImplementedException();
    }

    @Override
    public List parse(String objname, File file) throws Exception {
        this._importFile = file;
        this._importObjName = objname;
        return this.parse(objname, new FileInputStream(file));
    }

    @Override
    public void setSilentMode(boolean silent) {
        this.fSilentMode = silent;
    }

    protected boolean isSilentMode() {
        return this.fSilentMode;
    }

    protected static List unmodlist(PersistentObject pob) {
        ArrayList<PersistentObject> list = new ArrayList<PersistentObject>(1);
        list.add(pob);
        return Collections.unmodifiableList(list);
    }

    protected static List unmodlist(PersistentObject[] pobs) {
        ArrayList<PersistentObject> list = new ArrayList<PersistentObject>(pobs.length);
        for (int i = 0; i < pobs.length; ++i) {
            list.add(pobs[i]);
        }
        return Collections.unmodifiableList(list);
    }

    protected String nextLine(BufferedReader bin) throws IOException {
        return this.nextLine(bin, true);
    }

    protected String nextLine(BufferedReader bin, boolean autoAdd2Comment) throws IOException {
        String currLine = bin.readLine();
        if (currLine == null) {
            return null;
        }
        currLine = currLine.trim();
        while (currLine != null && (currLine.length() == 0 || currLine.startsWith("#"))) {
            if (currLine.startsWith("#") && autoAdd2Comment) {
                this.fComment.add(currLine);
            }
            if ((currLine = bin.readLine()) == null) continue;
            currLine = currLine.trim();
        }
        return currLine;
    }

    protected String nextNonEmptyLine(BufferedReader bin) throws IOException {
        String currLine = bin.readLine();
        if (currLine == null) {
            return null;
        }
        currLine = currLine.trim();
        while (currLine != null && currLine.length() == 0) {
            currLine = bin.readLine();
            if (currLine == null) continue;
            currLine = currLine.trim();
        }
        return currLine;
    }

    protected String nextLineTrimless(BufferedReader bin) throws IOException {
        String currLine = bin.readLine();
        if (currLine == null) {
            return null;
        }
        while (currLine != null && (currLine.length() == 0 || currLine.startsWith("#"))) {
            if (currLine.startsWith("#")) {
                this.fComment.add(currLine);
            }
            currLine = bin.readLine();
        }
        return currLine;
    }

    protected boolean isNull(Object obj) {
        if (obj == null) {
            return true;
        }
        String s = obj.toString();
        if ((s = s.trim()).length() == 0) {
            return true;
        }
        return "NULL".equalsIgnoreCase(s.trim());
    }

    protected boolean isNa(String s) {
        return "na".equalsIgnoreCase(s.trim());
    }

    protected boolean isNullorNa(String s) {
        if (this.isNull(s)) {
            return true;
        }
        return this.isNa(s);
    }

    protected PrintWriter startExport(PersistentObject pob, File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Parameter file cannot be null");
        }
        return this.startExport(pob, new FileOutputStream(file), file.getName());
    }

    protected PrintWriter startExport(PersistentObject pob, OutputStream os, String toName) throws IOException {
        if (pob == null) {
            throw new IllegalArgumentException("Parameter pob cannot be null");
        }
        if (os == null) {
            throw new IllegalArgumentException("Parameter os cannot be null");
        }
        if (!this.fSilentMode) {
            this.log.debug("Exporting: {} to: {} {}", new Object[]{pob.getName(), toName, pob.getClass()});
        }
        this._exportPw = new PrintWriter(os);
        return this._exportPw;
    }

    protected void doneExport() {
        if (this._exportPw != null) {
            this._exportPw.flush();
            this._exportPw.close();
        }
    }

    protected void startImport(String sourcepath) {
        if (!this.fSilentMode) {
            this.log.info("Begun importing: {} from: {}", (Object)this.fRepClassName, (Object)sourcepath);
        }
    }

    protected void doneImport() {
    }

    protected float parseStringToFloat(String s, boolean correctDoubleQuotes) {
        if ((s = s.trim()).length() == 0) {
            return Float.NaN;
        }
        try {
            return Float.parseFloat(s);
        }
        catch (NumberFormatException nfe) {
            if (s.equalsIgnoreCase("na")) {
                return Float.NaN;
            }
            if (correctDoubleQuotes && s.startsWith("\"") && s.endsWith("\"") && s.length() > 1) {
                return this.parseStringToFloat(s.substring(1, s.length() - 1), false);
            }
            throw nfe;
        }
    }

    protected List parseTextMatrixToDataset(String objName, List<String> lines, List<String> colNames, boolean hasDesc) throws Exception {
        Object warning;
        int lineCount = lines.size();
        ArrayList<String> rowNames = new ArrayList<String>(lineCount);
        ArrayList<String> rowDescs = hasDesc ? new ArrayList<String>(lineCount) : null;
        ArrayList<float[]> data = new ArrayList<float[]>(lineCount);
        int skippedMissingRows = 0;
        int partialMissingRows = 0;
        boolean foundInfiniteValues = false;
        int startPos = hasDesc ? 2 : 1;
        int expFields = colNames.size() + startPos;
        for (int i = 0; i < lineCount; ++i) {
            String rowname;
            String currLine = lines.get(i);
            List<String> fields = AbstractParser.string2stringsV2(currLine, expFields);
            float[] dataRow = this.parseFieldsIntoFloatArray(fields, i, startPos, rowname = this.parseRowname(fields.get(0).trim(), i));
            int countMissing = this.countMissingValues(dataRow, i, rowname);
            if (countMissing < dataRow.length) {
                if (countMissing > 0) {
                    ++partialMissingRows;
                }
                data.add(dataRow);
                rowNames.add(rowname);
                if (hasDesc) {
                    String desc = fields.get(1).trim();
                    if (desc.length() == 0) {
                        desc = "na";
                    }
                    rowDescs.add(desc);
                }
            } else {
                ++skippedMissingRows;
            }
            foundInfiniteValues |= this.checkForInfiniteValues(dataRow, i, rowname);
        }
        if (data.isEmpty()) {
            throw new ParserException("Data was missing in all rows!");
        }
        Matrix matrix = new Matrix(data.size(), colNames.size());
        for (int i = 0; i < data.size(); ++i) {
            matrix.setRow(i, (float[])data.get(i));
        }
        FeatureAnnot ann = new FeatureAnnot(objName, rowNames, rowDescs);
        ann.addComment(this.fComment.toString());
        SampleAnnot sann = new SampleAnnot(objName, colNames);
        DefaultDataset ds = new DefaultDataset(objName, matrix, rowNames, colNames, new Annot(ann, sann));
        ds.addComment(this.fComment.toString());
        if (data.size() <= 2000) {
            warning = "Loaded dataset with " + data.size() + " features.  This may be too few for GSEA, which expects data for all expressed genes for a proper analysis.";
            this.log.warn((String)warning);
            ds.addWarning((String)warning);
        }
        if (foundInfiniteValues) {
            warning = "Infinite values detected in this dataset. This may cause unexpected results in the calculations or failures in plotting.";
            this.log.warn((String)warning);
            ds.addWarning((String)warning + "  See the log for more details.");
        }
        if (partialMissingRows > 0) {
            warning = "There were " + partialMissingRows + " row(s) in total with partially missing data in this dataset.";
            this.log.warn((String)warning);
            ds.addWarning((String)warning + "  See the log for more details.");
        }
        if (skippedMissingRows > 0) {
            warning = "There were " + skippedMissingRows + " row(s) in total with all data missing in this dataset.  These will be ignored.";
            this.log.warn((String)warning);
            ds.addWarning((String)warning + "  See the log for more details.");
        }
        this.doneImport();
        return AbstractParser.unmodlist(new PersistentObject[]{ds});
    }

    protected boolean checkForInfiniteValues(float[] dataRow, int row, String rowname) {
        for (int i = 0; i < dataRow.length; ++i) {
            if (!Float.isInfinite(dataRow[i])) continue;
            this.log.warn("Infinite values found in row {} of the data matrix with Name '{}'.", (Object)(row + 1), (Object)rowname);
            return true;
        }
        return false;
    }

    protected int countMissingValues(float[] dataRow, int row, String rowname) {
        int missingCount = 0;
        for (int i = 0; i < dataRow.length; ++i) {
            if (!Float.isNaN(dataRow[i])) continue;
            ++missingCount;
        }
        if (missingCount == dataRow.length) {
            this.log.warn("All values missing in row {} of the data matrix with Name '{}'.  Row will be ignored.", (Object)(row + 1), (Object)rowname);
        } else if (missingCount > 0) {
            this.log.warn("Missing values found in row {} of the data matrix with Name '{}'.", (Object)(row + 1), (Object)rowname);
        }
        return missingCount;
    }

    protected float[] parseFieldsIntoFloatArray(List<String> fields, int row, int startingField, String rowname) {
        float[] dataRow = new float[fields.size() - startingField];
        int col = 0;
        for (int f = startingField; f < fields.size(); ++f) {
            String s = fields.get(f);
            try {
                dataRow[col++] = this.parseStringToFloat(s, true);
                continue;
            }
            catch (NumberFormatException nfe) {
                this.log.error("Could not parse '{}' as a floating point number in row {} of the data matrix with Name '{}'.", new Object[]{s, row + 1, rowname});
                throw nfe;
            }
        }
        return dataRow;
    }

    protected String parseRowname(String rowname, int row) throws ParserException {
        if (rowname.length() == 0) {
            throw new ParserException("Bad rowname - cant be empty at row " + (row + 1) + " of data matrix.");
        }
        if (rowname.startsWith("\"") && rowname.endsWith("\"") && rowname.length() > 1 && (rowname = rowname.substring(1, rowname.length() - 1).trim()).length() == 0) {
            throw new ParserException("Bad rowname - cant be empty at row " + (row + 1) + " of data matrix.");
        }
        return rowname;
    }

    protected static List<String> string2stringsV2(String s, int expectedLen) throws IllegalArgumentException {
        if (null == s) {
            throw new NullPointerException("Cannot work on null String");
        }
        String delim = "\t";
        StringTokenizer tok = new StringTokenizer(s, delim, true);
        ArrayList<String> ret = new ArrayList<String>();
        String prev = null;
        int cnt = 0;
        while (tok.hasMoreTokens()) {
            String curr = tok.nextToken();
            if (cnt == 0) {
                ret.add(curr.trim());
            } else if (curr.equals(delim)) {
                if (prev.equals(delim)) {
                    ret.add("");
                }
            } else {
                ret.add(curr.trim());
            }
            prev = curr;
            ++cnt;
        }
        if (ret.size() == expectedLen) {
            return ret;
        }
        if (ret.size() < expectedLen) {
            for (int i = ret.size(); i < expectedLen; ++i) {
                ret.add("");
            }
            return ret;
        }
        ArrayList<String> real_ret = new ArrayList<String>();
        for (int i = 0; i < ret.size(); ++i) {
            if (i < expectedLen) {
                real_ret.add((String)ret.get(i));
                continue;
            }
            String item = (String)ret.get(i);
            if (item == null || item.trim().length() == 0) continue;
            real_ret.add(item);
        }
        return real_ret;
    }

    protected static int indexOf(String s, List list, boolean barfIfMising) throws ParserException {
        int index = list.indexOf(s);
        if (index == -1 && barfIfMising) {
            throw new ParserException("Column not found: " + s);
        }
        return index;
    }

    protected class Comment {
        private List<String> fLines;
        private Map<String, String> fKeyValues;

        protected Comment() {
        }

        protected void add(String s) {
            if (s == null || s.length() == 0) {
                return;
            }
            if ((s = s.substring(1, s.length())).length() == 0) {
                return;
            }
            if (s.indexOf(61) != -1) {
                String[] fields;
                if (this.fKeyValues == null) {
                    this.fKeyValues = new HashMap<String, String>();
                }
                if ((fields = ParseUtils.string2strings(s, "= ")).length != 1) {
                    if (fields.length == 2) {
                        this.fKeyValues.put(fields[0].toUpperCase(), fields[1]);
                    } else {
                        AbstractParser.this.log.warn("Bad comment KEY=VALUE field: Got more tokens than expected: {}", (Object)fields.length);
                    }
                }
            } else {
                if (this.fLines == null) {
                    this.fLines = new ArrayList<String>();
                }
                this.fLines.add(s);
            }
        }

        public String toString() {
            if (this.fLines == null && this.fKeyValues == null) {
                return "";
            }
            StringBuilder buf = new StringBuilder();
            if (this.fLines != null && !this.fLines.isEmpty()) {
                for (int i = 0; i < this.fLines.size(); ++i) {
                    buf.append(this.fLines.get(i)).append('\n');
                }
            }
            if (this.fKeyValues != null && !this.fKeyValues.isEmpty()) {
                buf.append(this.fKeyValues);
            }
            return buf.toString();
        }
    }
}

