/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.objects.AbstractGeneSetMatrix;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.MSigDBVersion;
import edu.mit.broad.genome.parsers.AuxUtils;
import java.util.List;

public class DefaultGeneSetMatrix
extends AbstractGeneSetMatrix {
    public DefaultGeneSetMatrix(String name, GeneSet[] gsets) {
        this.initMatrix(name, gsets);
    }

    public DefaultGeneSetMatrix(String name, GeneSet[] gsets, MSigDBVersion msigDBVersion, boolean removeAuxStuff) {
        this.setMSigDBVersion(msigDBVersion);
        if (removeAuxStuff) {
            GeneSet[] cgsets = new GeneSet[gsets.length];
            for (int i = 0; i < gsets.length; ++i) {
                cgsets[i] = gsets[i].cloneShallow(AuxUtils.getAuxNameOnlyNoHash(gsets[i].getName()));
            }
            this.initMatrix(name, cgsets);
        } else {
            this.initMatrix(name, gsets);
        }
    }

    public DefaultGeneSetMatrix(String name, List gsets, MSigDBVersion msigDBVersion) {
        this.setMSigDBVersion(msigDBVersion);
        this.initMatrix(name, gsets.toArray(new GeneSet[gsets.size()]));
    }
}

