/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.IDataframe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Dataframe
extends AbstractObject
implements IDataframe {
    private Matrix fMatrix;
    private List fRowNames;
    private List fColNames;

    protected Dataframe() {
    }

    public Dataframe(String name, Matrix matrix, List rowNames, List colNames, boolean shareMatrix, boolean shareRowNames, boolean shareColNames) {
        if (matrix == null) {
            throw new IllegalArgumentException("Param matrix cant be null");
        }
        if (rowNames == null) {
            throw new IllegalArgumentException("Param rownames cant be null");
        }
        if (colNames == null) {
            throw new IllegalArgumentException("Param rownames cant be null");
        }
        Matrix dmatrix = shareMatrix ? matrix : matrix.cloneDeep();
        ArrayList drowNames = shareRowNames ? rowNames : new ArrayList(rowNames);
        ArrayList dcolNames = shareColNames ? colNames : new ArrayList(colNames);
        this.init(name, dmatrix, drowNames, dcolNames);
    }

    private void init(String dsname, Matrix matrix, List rowNames, List colNames) {
        super.initialize(dsname);
        if (matrix == null) {
            throw new IllegalArgumentException("Matrix cannot be null");
        }
        if (rowNames == null) {
            throw new IllegalArgumentException("rowNames cannot be null");
        }
        if (colNames == null) {
            throw new IllegalArgumentException("colNames cannot be null");
        }
        if (matrix.getNumRow() != rowNames.size()) {
            throw new IllegalArgumentException("Matrix numrow: " + matrix.getNumRow() + " and rowNames: " + rowNames.size() + " do not match in size");
        }
        if (matrix.getNumCol() != colNames.size()) {
            throw new IllegalArgumentException("Matrix numcol: " + matrix.getNumCol() + " and colNames: " + colNames.size() + " do not match in size");
        }
        this.fMatrix = matrix;
        this.fMatrix.setImmutable();
        this.fRowNames = Collections.unmodifiableList(rowNames);
        this.fColNames = Collections.unmodifiableList(colNames);
    }

    public Vector getRow(int rown) {
        return this.fMatrix.getRowV(rown);
    }

    @Override
    public Object getElementObj(int rown, int coln) {
        return new Float(this.fMatrix.getElement(rown, coln));
    }

    @Override
    public String getRowName(int rown) {
        return (String)this.fRowNames.get(rown);
    }

    @Override
    public String getColumnName(int coln) {
        return (String)this.fColNames.get(coln);
    }

    @Override
    public int getNumRow() {
        return this.fMatrix.getNumRow();
    }

    @Override
    public int getNumCol() {
        return this.fMatrix.getNumCol();
    }

    @Override
    public String getQuickInfo() {
        StringBuffer buf = new StringBuffer().append(this.getNumRow()).append('x').append(this.getNumCol());
        return buf.toString();
    }
}

