/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.math.ColorSchemes;
import edu.mit.broad.genome.math.GraphMode;
import edu.mit.broad.genome.math.Orientation;
import edu.mit.broad.genome.math.ScaleMode;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.ColorDataset;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DatasetProxy;
import java.awt.Color;

public class ColorDatasetImpl
extends DatasetProxy
implements ColorDataset {
    protected ScaleMode fScaleMode;
    protected Orientation fOrientType;
    protected ColorSchemes.ColorScheme fColorScheme;
    protected GraphMode fGraphMode;
    private Color[][] fColors;

    public ColorDatasetImpl(Dataset ds, ScaleMode smode, ColorSchemes.ColorScheme colorScheme, Orientation orient, GraphMode gmode) {
        super("colored." + ds.getName(), ds);
        this.fScaleMode = smode;
        this.fColorScheme = colorScheme;
        this.fOrientType = orient;
        this.fGraphMode = gmode;
        this.cacheColors();
    }

    public ColorDatasetImpl(Dataset ds, ColorSchemes.ColorScheme colorScheme) {
        this(ds, DEFAULT_SCALE_MODE, colorScheme, DEFAULT_ORIENTATION, DEFAULT_GRAPH_MODE);
    }

    public ColorDatasetImpl(Dataset ds, ScaleMode scaleMode, ColorSchemes.ColorScheme colorScheme) {
        this(ds, scaleMode, colorScheme, DEFAULT_ORIENTATION, DEFAULT_GRAPH_MODE);
    }

    protected void cacheColors() {
        if (this.fOrientType.isByRow()) {
            this.cacheColorsByRow();
        } else if (this.fOrientType.isByCol()) {
            this.cacheColorsByColumn();
        } else {
            throw new IllegalStateException("Unknown orientType option: " + this.fOrientType);
        }
    }

    protected void cacheColorsByRow() {
        this.fColors = new Color[this.getNumRow()][this.getNumCol()];
        for (int r = 0; r < this.getNumRow(); ++r) {
            Vector vr = this.getRow(r);
            Vector v = vr.toVectorNaNless();
            if (this.fScaleMode.isRelative()) {
                double center = v.meanOrMedian(this.fScaleMode.isMean());
                double max = v.max();
                double min = v.min();
                for (int c = 0; c < this.getNumCol(); ++c) {
                    if (this.fScaleMode.isMean()) {
                        boolean coloraswhite = false;
                        if (this.fScaleMode == ScaleMode.REL_MEAN_ZERO_OMITTED) {
                            coloraswhite = true;
                        }
                        this.fColors[r][c] = ColorDataset.Helper.computeRelativeMeanColor(this.getElement(r, c), min, max, center, this.fGraphMode, this.fColorScheme, coloraswhite);
                        continue;
                    }
                    this.fColors[r][c] = ColorDataset.Helper.computeRelativeMedianColor(this.getElement(r, c), min, max, center, this.fGraphMode, this.fColorScheme);
                }
                continue;
            }
            for (int c = 0; c < this.getNumCol(); ++c) {
                this.fColors[r][c] = ColorDataset.Helper.computeAbsoluteColor(this.getElement(r, c), this.fGraphMode, this.fColorScheme);
            }
        }
    }

    protected void cacheColorsByColumn() {
        this.log.info("Beginning to cache fColors by COL from: {}", this.getClass());
        this.fColors = new Color[this.getNumRow()][this.getNumCol()];
        for (int c = 0; c < this.getNumCol(); ++c) {
            Vector v = this.getColumn(c);
            if (this.fScaleMode.isRelative()) {
                double mean = v.mean();
                double median = v.median();
                double max = v.max();
                double min = v.min();
                for (int r = 0; r < this.getNumRow(); ++r) {
                    this.fColors[r][c] = this.fScaleMode.isMean() ? ColorDataset.Helper.computeRelativeMeanColor(this.getElement(r, c), min, max, mean, this.fGraphMode, this.fColorScheme, false) : ColorDataset.Helper.computeRelativeMedianColor(this.getElement(r, c), min, max, median, this.fGraphMode, this.fColorScheme);
                }
                continue;
            }
            for (int r = 0; r < this.getNumRow(); ++r) {
                this.fColors[r][c] = ColorDataset.Helper.computeAbsoluteColor(this.getElement(r, c), this.fGraphMode, this.fColorScheme);
            }
        }
        this.log.info("Finished caching Colors: {}", this.getClass());
    }

    @Override
    public Color getColor(int row, int col) {
        return this.fColors[row][col];
    }
}

