/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.models;

import edu.mit.broad.genome.objects.Template;
import javax.swing.table.AbstractTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateModel
extends AbstractTableModel {
    private final Template fTemplate;
    private static final String[] kColNames = new String[]{"Class Name", "Class Id", "Class Count"};
    private final Logger log = LoggerFactory.getLogger(TemplateModel.class);

    public TemplateModel(Template template) {
        this.fTemplate = template;
    }

    @Override
    public int getColumnCount() {
        return kColNames.length;
    }

    @Override
    public int getRowCount() {
        return this.fTemplate.getNumClasses();
    }

    @Override
    public String getColumnName(int col) {
        return kColNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (col == 0) {
            return this.fTemplate.getClassName(row);
        }
        if (col == 1) {
            return this.fTemplate.getClass(row).getItem(0).getId();
        }
        if (col == 2) {
            return Integer.toString(this.fTemplate.getClass(row).getSize());
        }
        this.log.warn("Unexpectedly i was asked for coln={}", (Object)col);
        return null;
    }

    public Class getColumnClass(int col) {
        return String.class;
    }

    public boolean isEditable() {
        return false;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }
}

