/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.math;

import edu.mit.broad.genome.math.DoubleElement;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.RandomSeedGenerator;
import edu.mit.broad.genome.math.ScoreMode;
import edu.mit.broad.genome.math.Vector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMath {
    private static final Logger klog = LoggerFactory.getLogger(XMath.class);

    private XMath() {
    }

    public static boolean isAscending(int[] ints) {
        for (int i = 0; i < ints.length - 1; ++i) {
            int nextValue = ints[i + 1];
            int thisValue = ints[i];
            if (nextValue >= thisValue) continue;
            return false;
        }
        return true;
    }

    public static float getFWERTwoTailed(float realScore, Matrix rndScores) {
        if (XMath.isPositive(realScore)) {
            return XMath.getFWER(realScore, rndScores, true);
        }
        return XMath.getFWERLessThan(realScore, rndScores);
    }

    public static float getFWER(float realScore, Matrix rndScores, boolean pos) {
        Vector best_of_each_perm = pos ? rndScores.getColumnMaxes() : rndScores.getColumnMins();
        double fwer = pos ? XMath.getPValue(realScore, best_of_each_perm) : XMath.getPValueLessThan(realScore, best_of_each_perm);
        return (float)fwer;
    }

    public static float getFWERLessThan(float realScore, Matrix rndScores) {
        Vector lowest_of_each_perm = new Vector(rndScores.getNumCol());
        for (int c = 0; c < rndScores.getNumCol(); ++c) {
            lowest_of_each_perm.setElement(c, rndScores.getColumnV(c).min());
        }
        return (float)XMath.getPValueLessThan(realScore, lowest_of_each_perm);
    }

    public static double log2(double d) {
        return Math.log(d) / Math.log(2.0);
    }

    public static boolean isSameSign(float a, float b) {
        if (a < 0.0f && b < 0.0f) {
            return true;
        }
        if (a > 0.0f && b > 0.0f) {
            return true;
        }
        return a == 0.0f && b == 0.0f;
    }

    public static boolean isPositive(float x) {
        return x >= 0.0f;
    }

    public static boolean isNegative(float x) {
        return x <= 0.0f;
    }

    private static int[] toIndices(int maxIndex) {
        if (maxIndex <= 0) {
            throw new IllegalArgumentException("Specified max for indices must be more than 0, got: " + maxIndex);
        }
        int[] inds = new int[maxIndex];
        for (int i = 0; i < maxIndex; ++i) {
            inds[i] = i;
        }
        return inds;
    }

    public static int[] randomizeWithoutReplacement(int num, RandomSeedGenerator rsgen) {
        Random rnd = rsgen.getRandom();
        ArrayList<Integer> seen = new ArrayList<Integer>(num);
        int[] inds = new int[num];
        int cnt = 0;
        int i = 0;
        while (i < num) {
            int r = rnd.nextInt(num);
            if (seen.contains(r)) continue;
            seen.add(r);
            inds[cnt++] = r;
            if (cnt != num) continue;
            break;
        }
        return inds;
    }

    public static int[] randomlySampleWithoutReplacement(int numRndNeeded, int highestrandomnumExclusive, RandomSeedGenerator rsgen) {
        Random rnd = rsgen.getRandom();
        if (highestrandomnumExclusive == numRndNeeded) {
            return XMath.toIndices(highestrandomnumExclusive);
        }
        if (numRndNeeded > highestrandomnumExclusive) {
            throw new IllegalArgumentException("Cannot pick more numbers (no replacement) numRndNeeded: " + numRndNeeded + " than max possible number maxRndNumExclusive: " + highestrandomnumExclusive);
        }
        ArrayList<Integer> seen = new ArrayList<Integer>(numRndNeeded);
        int[] inds = new int[numRndNeeded];
        int cnt = 0;
        int i = 0;
        while (i < numRndNeeded) {
            int r = rnd.nextInt(highestrandomnumExclusive);
            if (seen.contains(r)) continue;
            seen.add(r);
            inds[cnt++] = r;
            if (cnt != numRndNeeded) continue;
            break;
        }
        return inds;
    }

    public static double getPValue(float score, Vector values) {
        float[] values1 = values.elementData;
        int cntmore = 0;
        for (int i = 0; i < values1.length; ++i) {
            if (!(values1[i] > score)) continue;
            ++cntmore;
        }
        return (double)cntmore / (double)values1.length;
    }

    public static double getPValueLessThan(float score, Vector values) {
        float[] values1 = values.elementData;
        int cntless = 0;
        for (int i = 0; i < values1.length; ++i) {
            if (!(values1[i] < score)) continue;
            ++cntless;
        }
        return (double)cntless / (double)values1.length;
    }

    public static float getPValueTwoTailed_pos_neg_seperate(float realEs, Vector rndEs) {
        Vector ex = rndEs.extract(realEs, ScoreMode.POS_AND_NEG_SEPERATELY);
        float score = realEs;
        Vector values = ex;
        float[] values1 = values.elementData;
        int cnt = 0;
        if (score >= 0.0f) {
            for (int i = 0; i < values1.length; ++i) {
                if (!(values1[i] > score)) continue;
                ++cnt;
            }
        } else {
            for (int i = 0; i < values1.length; ++i) {
                if (!(values1[i] < score)) continue;
                ++cnt;
            }
        }
        return (float)((double)cnt / (double)values1.length);
    }

    private static void enforceEqualSize(Vector[] vss) {
        if (vss.length == 0) {
            return;
        }
        int size = vss[0].getSize();
        for (int i = 0; i < vss.length; ++i) {
            if (vss[i].getSize() == size) continue;
            throw new IllegalArgumentException("Vector lengths not equal first=" + size + " and y=" + vss[i].getSize() + " at index " + i);
        }
    }

    public static double euclidean(Vector x, Vector y) {
        y = x.synchVectorNaNless(y);
        x = x.toVectorNaNless();
        int size = x.getSize();
        float sum = 0.0f;
        for (int i = 0; i < size; ++i) {
            float xVal = x.getElement(i);
            float yVal = y.getElement(i);
            float diff = xVal - yVal;
            sum += diff * diff;
        }
        return Math.sqrt(sum);
    }

    public static double manhattan(Vector x, Vector y) {
        y = x.synchVectorNaNless(y);
        x = x.toVectorNaNless();
        int size = x.getSize();
        double sum = 0.0;
        for (int i = 0; i < size; ++i) {
            float xVal = x.getElement(i);
            float yVal = y.getElement(i);
            sum += (double)Math.abs(xVal - yVal);
        }
        return sum;
    }

    public static double meanOrMedianRatio(Vector x, Vector y, boolean useMean) {
        return x.meanOrMedian(useMean) / y.meanOrMedian(useMean);
    }

    public static double meanOrMedianDiff(Vector x, Vector y, boolean useMean) {
        return x.meanOrMedian(useMean) - y.meanOrMedian(useMean);
    }

    public static Vector medianVector(Vector[] vss) {
        XMath.enforceEqualSize(vss);
        int size = vss[0].getSize();
        float[] medians = new float[size];
        for (int i = 0; i < size; ++i) {
            float[] v1 = new float[vss.length];
            for (int c = 0; c < vss.length; ++c) {
                v1[c] = vss[c].getElement(i);
            }
            medians[i] = XMath.median(v1);
        }
        return new Vector(medians);
    }

    public static Vector meanVector(Vector[] vss) {
        XMath.enforceEqualSize(vss);
        int size = vss[0].getSize();
        float[] means = new float[size];
        for (int i = 0; i < size; ++i) {
            int nonMissingSize = vss.length;
            float runningSum = 0.0f;
            for (int c = 0; c < vss.length; ++c) {
                float value = vss[c].getElement(i);
                if (!Float.isNaN(value)) {
                    runningSum += value;
                    continue;
                }
                --nonMissingSize;
            }
            means[i] = nonMissingSize == 0 ? Float.NaN : runningSum / (float)nonMissingSize;
        }
        return new Vector(means);
    }

    public static Vector abs_maxVector(Vector[] vss) {
        XMath.enforceEqualSize(vss);
        int size = vss[0].getSize();
        float[] maxs = new float[size];
        for (int i = 0; i < size; ++i) {
            int nonMissingSize = vss.length;
            float max = Float.NEGATIVE_INFINITY;
            float abs_max = Float.NEGATIVE_INFINITY;
            for (int c = 0; c < vss.length; ++c) {
                float value = vss[c].getElement(i);
                float absValue = Math.abs(value);
                if (Float.isNaN(value)) {
                    --nonMissingSize;
                    continue;
                }
                if (!(abs_max < absValue)) continue;
                max = value;
                abs_max = absValue;
            }
            maxs[i] = nonMissingSize == 0 ? Float.NaN : max;
        }
        return new Vector(maxs);
    }

    public static Vector maxVector(Vector[] vss) {
        XMath.enforceEqualSize(vss);
        int size = vss[0].getSize();
        float[] maxs = new float[size];
        for (int i = 0; i < size; ++i) {
            int nonMissingSize = vss.length;
            float max = Float.NEGATIVE_INFINITY;
            for (int c = 0; c < vss.length; ++c) {
                float value = vss[c].getElement(i);
                if (Float.isNaN(value)) {
                    --nonMissingSize;
                    continue;
                }
                if (!(max < value)) continue;
                max = value;
            }
            maxs[i] = nonMissingSize == 0 ? Float.NaN : max;
        }
        return new Vector(maxs);
    }

    public static Vector sumVector(Vector[] vss) {
        XMath.enforceEqualSize(vss);
        int size = vss[0].getSize();
        float[] sums = new float[size];
        for (int i = 0; i < size; ++i) {
            int nonMissingSize = vss.length;
            float runningSum = 0.0f;
            for (int c = 0; c < vss.length; ++c) {
                float value = vss[c].getElement(i);
                if (!Float.isNaN(value)) {
                    runningSum += value;
                    continue;
                }
                --nonMissingSize;
            }
            sums[i] = nonMissingSize == 0 ? Float.NaN : runningSum;
        }
        return new Vector(sums);
    }

    public static float abs_max(float[] values) {
        if (values.length == 0) {
            klog.warn("FIX ME Zero length array");
            throw new IllegalArgumentException("Zero length array not allowed");
        }
        int nonMissingSize = values.length;
        int maxIndex = 0;
        float max = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < values.length; ++i) {
            if (Float.isNaN(values[i])) {
                --nonMissingSize;
                continue;
            }
            float absVal = Math.abs(values[i]);
            if (!(max < absVal)) continue;
            max = absVal;
            maxIndex = i;
        }
        return nonMissingSize == 0 ? Float.NaN : values[maxIndex];
    }

    public static float max(float[] values) {
        if (values.length == 0) {
            klog.warn("FIX ME Zero length array");
            throw new IllegalArgumentException("Zero length array not allowed");
        }
        int nonMissingSize = values.length;
        float max = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < values.length; ++i) {
            if (Float.isNaN(values[i])) {
                --nonMissingSize;
                continue;
            }
            if (!(max < values[i])) continue;
            max = values[i];
        }
        return nonMissingSize == 0 ? Float.NaN : max;
    }

    public static float median(float[] x) {
        if (x.length == 0) {
            return Float.NaN;
        }
        int size = x.length;
        float[] v1 = new float[size];
        int nonMissingCount = size;
        for (int i = 0; i < size; ++i) {
            if (!Float.isNaN(x[i])) {
                v1[i] = x[i];
                continue;
            }
            v1[i] = Float.POSITIVE_INFINITY;
            --nonMissingCount;
        }
        if (nonMissingCount == 0) {
            return Float.NaN;
        }
        Arrays.parallelSort(v1);
        switch (nonMissingCount) {
            case 1: {
                return v1[0];
            }
            case 2: {
                return (v1[0] + v1[1]) / 2.0f;
            }
            case 3: {
                return v1[1];
            }
            case 4: {
                return (v1[1] + v1[2]) / 2.0f;
            }
            case 5: {
                return v1[2];
            }
        }
        int in1 = (nonMissingCount - 1) / 2;
        int in2 = nonMissingCount / 2;
        return in1 == in2 ? v1[in1] : (v1[in1] + v1[in2]) / 2.0f;
    }

    public static float mean(float[] x) {
        if (x.length == 0) {
            return Float.NaN;
        }
        int nonMissingSize = x.length;
        float runningSum = 0.0f;
        for (int i = 0; i < x.length; ++i) {
            if (!Float.isNaN(x[i])) {
                runningSum += x[i];
                continue;
            }
            --nonMissingSize;
        }
        return nonMissingSize == 0 ? Float.NaN : runningSum / (float)nonMissingSize;
    }

    public static float sum(float[] x) {
        if (x.length == 0) {
            return Float.NaN;
        }
        int nonMissingSize = x.length;
        float runningSum = 0.0f;
        for (int i = 0; i < x.length; ++i) {
            if (!Float.isNaN(x[i])) {
                runningSum += x[i];
                continue;
            }
            --nonMissingSize;
        }
        return nonMissingSize == 0 ? Float.NaN : runningSum;
    }

    public static double pearson(Vector x, Vector y) {
        y = x.synchVectorNaNless(y);
        x = x.toVectorNaNless();
        return XMath.pearson_core(x, y);
    }

    private static final double pearson_core(Vector x, Vector y) {
        int N = x.getSize();
        if (N <= 1) {
            return Double.NaN;
        }
        double xSum = x.sum();
        double ySum = y.sum();
        double numr = x.sumprod(y) - xSum * ySum / (double)N;
        double denr = (x.squaresum() - xSum * xSum / (double)N) * (y.squaresum() - ySum * ySum / (double)N);
        denr = Math.sqrt(denr);
        return numr / denr;
    }

    public static double spearman(Vector x, Vector y) {
        y = x.synchVectorNaNless(y);
        int N = (x = x.toVectorNaNless()).getSize();
        if (N <= 1) {
            return Double.NaN;
        }
        DoubleElement.DoubleElementNaNlessComparator doubleElementComparator = new DoubleElement.DoubleElementNaNlessComparator(false);
        TreeSet<DoubleElement> xSorted = XMath.sortAndCheckTies(x, doubleElementComparator);
        TreeSet<DoubleElement> ySorted = XMath.sortAndCheckTies(y, doubleElementComparator);
        if (doubleElementComparator.isTiesDetected()) {
            double[] xRanks = XMath.computeRanks_withTies(xSorted);
            double[] yRanks = XMath.computeRanks_withTies(ySorted);
            return XMath.pearson_core(new Vector(xRanks), new Vector(yRanks));
        }
        int[] xRanks = XMath.computeRanks_noTies(xSorted);
        int[] yRanks = XMath.computeRanks_noTies(ySorted);
        int d = XMath.sumOfDiffsSquared(xRanks, yRanks);
        int numr = 6 * d;
        int denr = N * (N * N - 1);
        return 1.0 - (double)numr / (double)denr;
    }

    private static final TreeSet<DoubleElement> sortAndCheckTies(Vector vector, DoubleElement.DoubleElementNaNlessComparator doubleElementComparator) {
        TreeSet<DoubleElement> sorted = new TreeSet<DoubleElement>(doubleElementComparator);
        for (int i = 0; i < vector.getSize(); ++i) {
            sorted.add(new DoubleElement(i, vector.elementData[i]));
        }
        return sorted;
    }

    private static final int[] computeRanks_noTies(TreeSet<DoubleElement> sorted) {
        int rank = 1;
        int[] ranks = new int[sorted.size()];
        for (DoubleElement doubleElement : sorted) {
            ranks[doubleElement.fIndex] = rank++;
        }
        return ranks;
    }

    private static final double[] computeRanks_withTies(TreeSet<DoubleElement> sorted) {
        int currRank = 1;
        int rankSum = 0;
        double[] ranks = new double[sorted.size()];
        DoubleElement curr = sorted.first();
        ArrayList<DoubleElement> ties = new ArrayList<DoubleElement>();
        for (DoubleElement next : sorted.tailSet(curr, false)) {
            rankSum = XMath.accumRanks(curr, next, ties, ranks, currRank++, rankSum);
            curr = next;
        }
        XMath.accumRanks(curr, null, ties, ranks, currRank, rankSum);
        return ranks;
    }

    private static final int accumRanks(DoubleElement curr, DoubleElement next, List<DoubleElement> ties, double[] ranks, int currRank, int rankSum) {
        if (next != null && curr.fValue == next.fValue) {
            ties.add(curr);
            return rankSum + currRank;
        }
        if (ties.isEmpty()) {
            ranks[curr.fIndex] = currRank;
        } else {
            ties.add(curr);
            double avgRank = ((double)rankSum + (double)currRank) / (double)ties.size();
            for (DoubleElement tie : ties) {
                ranks[tie.fIndex] = avgRank;
            }
            ties.clear();
        }
        return 0;
    }

    private static final int sumOfDiffsSquared(int[] x, int[] y) {
        int accumulator = 0;
        for (int i = 0; i < x.length; ++i) {
            int value = x[i] - y[i];
            accumulator += value * value;
        }
        return accumulator;
    }

    public static double cosine(Vector x, Vector y) {
        y = x.synchVectorNaNless(y);
        x = x.toVectorNaNless();
        float[] x1 = x.elementData;
        float[] y1 = y.elementData;
        double mag_x = 0.0;
        double mag_y = 0.0;
        double sump = 0.0;
        for (int i = 0; i < x1.length; ++i) {
            mag_x += (double)(x1[i] * x1[i]);
            mag_y += (double)(y1[i] * y1[i]);
            sump += (double)(x1[i] * y1[i]);
        }
        return 1.0 - sump / Math.sqrt(mag_x * mag_y);
    }

    public static double s2n(Vector x, Vector y, boolean usebiased, boolean usemedian, boolean fixlow) {
        double s2n = usemedian ? (x.median() - y.median()) / (x.stddev(usebiased, fixlow) + y.stddev(usebiased, fixlow)) : (x.mean() - y.mean()) / (x.stddev(usebiased, fixlow) + y.stddev(usebiased, fixlow));
        return s2n;
    }

    public static double tTest(Vector x, Vector y, boolean usebiased, boolean usemedian, boolean fixlow) {
        double numr = usemedian ? x.median() - y.median() : x.mean() - y.mean();
        double denr = usebiased ? Math.sqrt(x.var(usebiased, fixlow) / (double)(x.getSize() - 1) + y.var(usebiased, fixlow) / (double)(y.getSize() - 1)) : Math.sqrt(x.var(usebiased, fixlow) / (double)x.getSize() + y.var(usebiased, fixlow) / (double)y.getSize());
        return numr / denr;
    }

    public static double mannWhitney(int[] hitIndices, int totSize) {
        double sr = 0.0;
        for (int i = 0; i < hitIndices.length; ++i) {
            sr += (double)hitIndices[i];
        }
        double N = hitIndices.length;
        double term1 = sr / N;
        double st = totSize * (totSize - 1) / 2;
        double d = totSize;
        double term2 = (st - sr) / (d - N);
        double mw = term1 - term2;
        return -1.0 * mw;
    }

    public static int getMoreThanCount(float value, Vector sorted_pos_to_neg) {
        int cnt = 0;
        for (int i = 0; i < sorted_pos_to_neg.getSize() && !(value > sorted_pos_to_neg.getElement(i)); ++i) {
            ++cnt;
        }
        return cnt;
    }

    public static int getLessThanCount(float value, Vector sorted_low_to_high) {
        int cnt = 0;
        for (int i = 0; i < sorted_low_to_high.getSize() && !(value < sorted_low_to_high.getElement(i)); ++i) {
            ++cnt;
        }
        return cnt;
    }

    public static boolean isNearlyZero(double d) {
        return Math.abs(d) <= 1.0E-9;
    }
}

