/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.math;

import edu.mit.broad.genome.math.ColorValue;
import java.awt.Color;

public class ColorSchemes {

    public static class BroadCancerBlue
    extends ColorScheme {
        private static final int[] MIT_BLUE_COLORS_SCHEME = new int[]{4522157, 2556113, 7035119, 0x8888FF, 13091327, 0xD5D5FF};
        private static final String[] MIT_BLUE_COLORS_LABELS = new String[]{"-3.0", "-2.5", "-2.0", "-1.5", "-1.0", "-0.5"};

        public BroadCancerBlue() {
            super("MIT_BLUE", MIT_BLUE_COLORS_SCHEME, MIT_BLUE_COLORS_LABELS);
        }
    }

    public static class BroadCancerRed
    extends ColorScheme {
        private static final int[] MIT_RED_COLORS_SCHEME = new int[]{16761061, 0xFF8989, 16740480, 0xFF5A5A, 15679552, 14027776};
        private static final String[] MIT_RED_COLORS_LABELS = new String[]{"+0.5", "+1.0", "+1.5", "+2.0", "+2.5", "+3.0"};

        public BroadCancerRed() {
            super("MIT_RED", MIT_RED_COLORS_SCHEME, MIT_RED_COLORS_LABELS);
        }
    }

    public static class BroadCancer
    extends ColorScheme {
        private static final int[] MIT_COLORS_SCHEME = new int[]{4522157, 2556113, 7035119, 0x8888FF, 13091327, 0xD5D5FF, 16761061, 0xFF8989, 16740480, 0xFF5A5A, 15679552, 14027776};
        private static final String[] MIT_COLORS_LABELS = new String[]{"-3.0", "-2.5", "-2.0", "-1.5", "-1.0", "-0.5", "+0.5", "+1.0", "+1.5", "+2.0", "+2.5", "+3.0"};

        public BroadCancer() {
            super("MIT", MIT_COLORS_SCHEME, MIT_COLORS_LABELS);
        }
    }

    public static class ColorScheme {
        private final String fName;
        private final ColorValue[] fColorValues;

        public ColorScheme(String type, int[] colors, String[] colorlabels) {
            this.fName = type;
            this.fColorValues = new ColorValue[colors.length];
            for (int i = 0; i < colors.length; ++i) {
                this.fColorValues[i] = new ColorValue(new Color(colors[i]), colorlabels[i]);
            }
        }

        public Color getMinColor() {
            return this.fColorValues[0].color;
        }

        public int getNumColors() {
            return this.fColorValues.length;
        }

        public Color getColor(int pos) {
            return this.fColorValues[pos].color;
        }

        public String getValue(int pos) {
            return this.fColorValues[pos].value;
        }

        public String toString() {
            return this.fName;
        }

        public boolean equals(Object obj) {
            return obj instanceof ColorScheme && ((ColorScheme)obj).fName.equals(this.fName);
        }

        public int hashCode() {
            return this.fName.hashCode();
        }
    }
}

