/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.charts;

import edu.mit.broad.genome.charts.XChart;
import edu.mit.broad.genome.charts.XChartUtils;
import java.io.File;
import java.io.IOException;
import org.jfree.chart.ChartUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Plot;

public class XChartImpl
implements XChart {
    private JFreeChart fFreeChart;
    private String fName;
    private String fCaption;

    public XChartImpl(String name, String caption, JFreeChart chart) {
        this.init(name, caption, chart);
    }

    public XChartImpl(String name, String plotTitle, String caption, Plot plot) {
        if (plot == null) {
            throw new IllegalArgumentException("Param chart cannot be null");
        }
        this.init(name, caption, new JFreeChart(plotTitle, JFreeChart.DEFAULT_TITLE_FONT, plot, false));
    }

    private void init(String name, String caption, JFreeChart jfc) {
        if (jfc == null) {
            throw new IllegalArgumentException("Param jfc cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Param name cannot be null");
        }
        this.fCaption = caption == null ? "na" : caption;
        this.fName = name;
        this.fFreeChart = jfc;
    }

    @Override
    public JFreeChart getFreeChart() {
        return this.fFreeChart;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public String getTitle() {
        return this.fFreeChart.getTitle().getText();
    }

    @Override
    public String getCaption() {
        return this.fCaption;
    }

    @Override
    public void saveAsPNG(File inFile, int width, int height) throws IOException {
        ChartUtils.saveChartAsPNG((File)inFile, (JFreeChart)this.fFreeChart, (int)width, (int)height);
    }

    @Override
    public void saveAsSVG(File toFile, int width, int height) throws IOException {
        XChartUtils.saveAsSVG(this, toFile, width, height, true);
    }
}

