/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg.gsea;

import edu.mit.broad.genome.MismatchedSizeException;
import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.alg.DatasetMetrics;
import edu.mit.broad.genome.alg.DatasetStatsCore;
import edu.mit.broad.genome.alg.GeneSetGenerators;
import edu.mit.broad.genome.alg.Metric;
import edu.mit.broad.genome.alg.Metrics;
import edu.mit.broad.genome.alg.gsea.GeneSetCohort;
import edu.mit.broad.genome.alg.gsea.KSCore;
import edu.mit.broad.genome.alg.markers.PermutationTest;
import edu.mit.broad.genome.math.AddressedVector;
import edu.mit.broad.genome.math.DoubleElement;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.RandomSeedGenerator;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.ScoredDataset;
import edu.mit.broad.genome.objects.ScoredDatasetImpl;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.TemplateFactoryRandomizer;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentDb;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentResult;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentScore;
import edu.mit.broad.genome.objects.strucs.DatasetTemplate;
import edu.mit.broad.genome.objects.strucs.TemplateRandomizerType;
import edu.mit.broad.vdb.chip.Chip;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtools.api.param.BadParamException;

public class KSTests {
    private final Logger log = LoggerFactory.getLogger(KSTests.class);
    private final KSCore core;
    private static final int LOG_FREQ = 5;
    private PrintStream sout;

    public KSTests(PrintStream os) {
        this.sout = os;
        this.core = new KSCore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnrichmentDb executeGsea(DatasetTemplate dt, GeneSet[] origGeneSets, int nperm, Metric metric, SortMode sort, Order order, RandomSeedGenerator rst, TemplateRandomizerType rt, Map<String, Boolean> mps, GeneSetCohort.Generator gcohgen, boolean permuteTemplate, int numMarkers, List<RankedList> store_rnd_ranked_lists_here_opt) throws Exception {
        boolean filterFeaturesWithMissingValues;
        Dataset ds = dt.getDataset(false);
        Template t = dt.getTemplate();
        this.log.debug("!!!! Executing for: {} # samples: {}", (Object)ds.getName(), (Object)ds.getNumCol());
        HashMap<String, DatasetStatsCore.TwoClassMarkerStats> markerScores = new HashMap<String, DatasetStatsCore.TwoClassMarkerStats>();
        boolean bl = filterFeaturesWithMissingValues = t.isCategorical() && new DatasetStatsCore().calc2ClassCategoricalMetricMarkerScores(ds, t, metric, mps, markerScores);
        if (t.isContinuous() && ds.getNumCol() < 3) {
            throw new BadParamException("Too few samples in the dataset to use this metric", 1006);
        }
        if (!filterFeaturesWithMissingValues) {
            markerScores = null;
        }
        try {
            if (permuteTemplate) {
                EnrichmentDb enrichmentDb = this.shuffleTemplate(nperm, metric, sort, order, mps, ds, t, origGeneSets, gcohgen, rt, rst, numMarkers, store_rnd_ranked_lists_here_opt, markerScores);
                return enrichmentDb;
            }
            EnrichmentDb enrichmentDb = this.shuffleGeneSet(nperm, metric, sort, order, mps, ds, t, origGeneSets, gcohgen, rst, markerScores);
            return enrichmentDb;
        }
        finally {
            this.log.info("Finished permutations ... creating reports");
        }
    }

    public EnrichmentDb executeGsea(RankedList rl_real, GeneSet[] origGeneSets, int nperm, RandomSeedGenerator rst, Chip chip, GeneSetCohort.Generator gcohgen) throws Exception {
        this.log.debug("!!!! Executing for: {} # features: {}", (Object)rl_real.getName(), (Object)rl_real.getSize());
        GeneSet[] gsets = gcohgen.filterGeneSetsByMembersAndSize(rl_real, origGeneSets);
        EnrichmentResult[] results = this.shuffleGeneSet_precannedRankedList(nperm, rl_real, null, gsets, chip, gcohgen, rst);
        return new EnrichmentDb(rl_real.getName(), rl_real, null, null, results, Metrics.NONE_METRIC, new HashMap<String, Boolean>(), SortMode.REAL, Order.DESCENDING, nperm, null, null);
    }

    private EnrichmentDb shuffleTemplate(int nperm, Metric metric, SortMode sort, Order order, Map<String, Boolean> metricParams, Dataset ds, Template template, GeneSet[] origGeneSets, GeneSetCohort.Generator gcohgen, TemplateRandomizerType rt, RandomSeedGenerator rst, int numMarkers, List<RankedList> store_rnd_ranked_lists_here_opt, Map<String, DatasetStatsCore.TwoClassMarkerStats> markerScores) throws Exception {
        Template[] rndTemplates = TemplateFactoryRandomizer.createRandomTemplates(nperm, template, rt, rst);
        this.log.debug("Done generating rnd templates: {}", (Object)rndTemplates.length);
        String dstName = NamingConventions.generateName(ds, template, true);
        Chip chip = ds.getAnnot().getChip();
        DatasetMetrics dm = new DatasetMetrics();
        PermutationTest ptest = new PermutationTest(dstName, numMarkers, rndTemplates.length, metric, sort, order, metricParams, ds, template, null, template.isCategorical());
        ScoredDataset rlReal = dm.scoreDataset(metric, sort, order, metricParams, ds, template);
        int origSize = rlReal.getSize();
        if (origSize != ds.getNumRow()) {
            throw new MismatchedSizeException();
        }
        rlReal = this.filterRankedListIfNecessary(rlReal, ds, markerScores);
        boolean warnGeneRankingValues = this.checkRankedListForInfinityOrNaN(rlReal);
        GeneSet[] gsets = gcohgen.filterGeneSetsByMembersAndSize(rlReal, origGeneSets);
        this.log.debug("shuffleTemplate with -- nperm: {} Order: {} Sort: {} gsets: {}", new Object[]{rndTemplates.length, order, sort, gsets.length});
        GeneSetCohort gcoh = gcohgen.createGeneSetCohort(rlReal, gsets, true);
        EnrichmentScore[] realScores = this.core.calculateKSScore(gcoh, true);
        Vector[] rndEss = new Vector[gsets.length];
        for (int g = 0; g < gsets.length; ++g) {
            rndEss[g] = new Vector(rndTemplates.length);
        }
        boolean warnPermutationValues = false;
        for (int c = 0; c < rndTemplates.length; ++c) {
            ScoredDataset rndRl = dm.scoreDataset(metric, sort, order, metricParams, ds, rndTemplates[c]);
            rndRl = this.filterRankedListIfNecessary(rndRl, ds, markerScores);
            if (!warnPermutationValues) {
                warnPermutationValues = this.checkRankedListForInfinityOrNaN(rndRl);
            }
            if (store_rnd_ranked_lists_here_opt != null) {
                store_rnd_ranked_lists_here_opt.add(rndRl);
            }
            if (c % 5 == 0) {
                StringBuffer ib = new StringBuffer("Iteration: ").append(c + 1).append('/').append(rndTemplates.length);
                ib.append(" for ").append(dstName);
                System.out.println(ib.toString());
            }
            GeneSetCohort gcohRnd = gcohgen.createGeneSetCohort(rndRl, gsets, false);
            EnrichmentScore[] rndScores = this.core.calculateKSScore(gcohRnd, false);
            for (int g = 0; g < gsets.length; ++g) {
                rndEss[g].setElement(c, rndScores[g].getES());
            }
            ptest.addRnd(rndTemplates[c], rndRl);
        }
        EnrichmentResult[] results = new EnrichmentResult[gsets.length];
        for (int g = 0; g < gsets.length; ++g) {
            results[g] = new EnrichmentResult(rlReal, template, gsets[g], chip, realScores[g], rndEss[g], null);
        }
        ptest.doCalc();
        EnrichmentDb enrichmentDb = new EnrichmentDb(dstName, rlReal, ds, template, results, metric, metricParams, sort, order, rndTemplates.length, null, ptest);
        int rowsNotMeetingMetricSize = origSize - rlReal.getSize();
        if (rowsNotMeetingMetricSize > 0) {
            enrichmentDb.addWarning("There were " + rowsNotMeetingMetricSize + " row(s) of this dataset where one of the classes has too few samples to use the chosen metric.  See the log for more details.");
        }
        if (warnGeneRankingValues) {
            enrichmentDb.addWarning("Infinite or NaN value(s) detected during gene rank computations. These will be scored using a value of 0.01 to reduce their impact. This may affect enrichment score calculations and report plotting.");
        }
        if (warnPermutationValues) {
            enrichmentDb.addWarning("Infinite or NaN value(s) detected during permutation computations. These will be scored using a value of 0.01 to reduce their impact. This may affect enrichment score calculations and report plotting.");
        }
        return enrichmentDb;
    }

    private EnrichmentResult[] shuffleGeneSet_precannedRankedList(int nperm, RankedList rlReal, Template t_opt, GeneSet[] gsetsReal, Chip chip_opt, GeneSetCohort.Generator gcohgen, RandomSeedGenerator rst) {
        EnrichmentResult[] results = new EnrichmentResult[gsetsReal.length];
        GeneSetCohort gcohReal = gcohgen.createGeneSetCohort(rlReal, gsetsReal, true);
        EnrichmentScore[] real_scores = this.core.calculateKSScore(gcohReal, true);
        for (int g = 0; g < gsetsReal.length; ++g) {
            Vector rndEss;
            if (g % 5 == 0) {
                this.sout.println("shuffleGeneSet for GeneSet " + (g + 1) + "/" + gsetsReal.length + " nperm: " + nperm);
            }
            if (nperm > 0) {
                GeneSet[] rndgsets = GeneSetGenerators.createRandomGeneSetsFixedSize(nperm, rlReal, gsetsReal[g], rst);
                GeneSetCohort gcohRnd = gcohReal.clone(rndgsets);
                rndEss = new Vector(rndgsets.length);
                EnrichmentScore[] rnds = this.core.calculateKSScore(gcohRnd, false);
                for (int r = 0; r < rndgsets.length; ++r) {
                    rndEss.setElement(r, rnds[r].getES());
                }
            } else {
                rndEss = new Vector(0);
            }
            results[g] = new EnrichmentResult(rlReal, t_opt, gsetsReal[g], chip_opt, real_scores[g], rndEss, null);
        }
        return results;
    }

    private EnrichmentDb shuffleGeneSet(int nperm, Metric metric, SortMode sort, Order order, Map<String, Boolean> metricParams, Dataset ds, Template template, GeneSet[] origGeneSets, GeneSetCohort.Generator gen, RandomSeedGenerator rst, Map<String, DatasetStatsCore.TwoClassMarkerStats> markerScores) throws Exception {
        if (ds == null) {
            throw new IllegalArgumentException("Param ds cannot be null");
        }
        DatasetMetrics dm = new DatasetMetrics();
        ScoredDataset rlReal = dm.scoreDataset(metric, sort, order, metricParams, ds, template);
        int origSize = rlReal.getSize();
        rlReal = this.filterRankedListIfNecessary(rlReal, ds, markerScores);
        boolean warnGeneRankingValues = this.checkRankedListForInfinityOrNaN(rlReal);
        GeneSet[] gsets = gen.filterGeneSetsByMembersAndSize(rlReal, origGeneSets);
        Chip chip = ds.getAnnot().getChip();
        EnrichmentResult[] results = this.shuffleGeneSet_precannedRankedList(nperm, rlReal, template, gsets, chip, gen, rst);
        String name = NamingConventions.generateName(ds, template, true);
        EnrichmentDb enrichmentDb = new EnrichmentDb(name, rlReal, ds, template, results, metric, metricParams, sort, order, nperm, null, null);
        int rowsNotMeetingMetricSize = origSize - rlReal.getSize();
        if (rowsNotMeetingMetricSize > 0) {
            enrichmentDb.addWarning("There were " + rowsNotMeetingMetricSize + " row(s) of this dataset where one of the classes has too few samples to use the chosen metric.  See the log for more details.");
        }
        if (warnGeneRankingValues) {
            enrichmentDb.addWarning("Infinite or NaN value(s) detected during gene rank computations. These will be scored using a value of 0.01 to reduce their impact. This may affect enrichment score calculations and report plotting.");
        }
        return enrichmentDb;
    }

    private ScoredDataset filterRankedListIfNecessary(ScoredDataset rankedList, Dataset ds, Map<String, DatasetStatsCore.TwoClassMarkerStats> markerScores) {
        if (markerScores == null || markerScores.isEmpty()) {
            return rankedList;
        }
        ArrayList<DoubleElement> dels = new ArrayList<DoubleElement>(rankedList.getSize());
        for (String feature : rankedList.getRankedNames()) {
            DatasetStatsCore.TwoClassMarkerStats markerScore = markerScores.get(feature);
            if (markerScore.omit) continue;
            dels.add(new DoubleElement(ds.getRowIndex(feature), rankedList.getScore(feature)));
        }
        ScoredDatasetImpl filtered = new ScoredDatasetImpl(new AddressedVector(dels), ds);
        if (!rankedList.getWarnings().isEmpty()) {
            for (String warning : rankedList.getWarnings()) {
                filtered.addWarning(warning);
            }
        }
        return filtered;
    }

    private boolean checkRankedListForInfinityOrNaN(ScoredDataset rankedList) {
        if (!Float.isFinite(rankedList.getScore(0))) {
            return true;
        }
        int end = rankedList.getNumRow() - 1;
        return !Float.isFinite(rankedList.getScore(end));
    }
}

