/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg.gsea;

import edu.mit.broad.genome.alg.gsea.GeneSetCohort;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentScore;
import gnu.trove.TFloatArrayList;
import java.util.Arrays;

public class KSCore {
    public EnrichmentScore[] calculateKSScore(GeneSetCohort gcoh, boolean storeDeep) {
        EnrichmentScoreCohort[] cohorts = this.calculateKSScore_all_modes(gcoh, storeDeep);
        EnrichmentScore[] ess = new EnrichmentScore[cohorts.length];
        for (int i = 0; i < ess.length; ++i) {
            ess[i] = cohorts[i].es_maxdev_style;
        }
        return ess;
    }

    private EnrichmentScoreCohort[] calculateKSScore_all_modes(GeneSetCohort gcoh, boolean storeDeep) {
        if (gcoh == null) {
            throw new IllegalArgumentException("Param gcoh cannot be null");
        }
        TFloatArrayList[] scoresAtEachHitIndex = null;
        int numGeneSets = gcoh.getNumGeneSets();
        int[] rankAtMaxEs = new int[numGeneSets];
        float[] scoresAtMaxEs = new float[numGeneSets];
        if (storeDeep) {
            scoresAtEachHitIndex = new TFloatArrayList[numGeneSets];
            for (int g = 0; g < numGeneSets; ++g) {
                scoresAtEachHitIndex[g] = new TFloatArrayList();
            }
        }
        Vector[] scoresAtEachPoint = new Vector[numGeneSets];
        int numLabels = gcoh.getNumLabels();
        for (int g = 0; g < numGeneSets; ++g) {
            scoresAtEachPoint[g] = new Vector(numLabels);
        }
        HitIndices[] hitIndices = new HitIndices[numGeneSets];
        for (int g = 0; g < numGeneSets; ++g) {
            hitIndices[g] = new HitIndices(gcoh.getNumTrue(g));
        }
        float[] ess_maxdev = new float[numGeneSets];
        double[] runningScores = new double[numGeneSets];
        int[] hitCnt = new int[numGeneSets];
        float[] ess_pos_list = new float[numGeneSets];
        int[] rankAtMaxEs_pos_list = new int[numGeneSets];
        float[] scoresAtMaxEs_pos_list = new float[numGeneSets];
        float[] ess_pos_list_maxdev = new float[numGeneSets];
        int[] rankAtMaxEs_pos_list_maxdev = new int[numGeneSets];
        float[] scoresAtMaxEs_pos_list_maxdev = new float[numGeneSets];
        float[] ess_neg_list = new float[numGeneSets];
        int[] rankAtMaxEs_neg_list = new int[numGeneSets];
        float[] scoresAtMaxEs_neg_list = new float[numGeneSets];
        float[] ess_neg_list_maxdev = new float[numGeneSets];
        int[] rankAtMaxEs_neg_list_maxdev = new int[numGeneSets];
        float[] scoresAtMaxEs_neg_list_maxdev = new float[numGeneSets];
        int[] genesetJumps = new int[numGeneSets];
        Arrays.fill(genesetJumps, -1);
        RankedList rl = gcoh.getRankedList();
        int rlSize = rl.getSize();
        for (int r = 0; r < rlSize; ++r) {
            int i;
            boolean isLastRun = r == rlSize - 1;
            String rowName = rl.getRankName(r);
            float corr = rl.getScore(r);
            boolean posList = XMath.isPositive(corr);
            int[] genesetIndices = null;
            if (isLastRun) {
                genesetIndices = new int[numGeneSets];
                for (i = 0; i < genesetIndices.length; ++i) {
                    genesetIndices[i] = i;
                }
            } else {
                genesetIndices = gcoh.genesetIndicesForGene(rowName);
            }
            if (genesetIndices == null) continue;
            for (i = 0; i < genesetIndices.length; ++i) {
                int g = genesetIndices[i];
                int gap = r - genesetJumps[g] - 1;
                if (gap > 0) {
                    double missPoints = gcoh.getMissPoints(g, rowName);
                    double trun = runningScores[g];
                    for (int j = genesetJumps[g] + 1; j < r; ++j) {
                        scoresAtEachPoint[g].setElement(j, trun -= missPoints);
                    }
                    int n = g;
                    runningScores[n] = runningScores[n] - (double)gap * missPoints;
                    if ((double)Math.abs(ess_maxdev[g]) < Math.abs(runningScores[g])) {
                        ess_maxdev[g] = (float)runningScores[g];
                        rankAtMaxEs[g] = r - 1;
                        scoresAtMaxEs[g] = rl.getScore(r - 1);
                    }
                }
                if (isLastRun && !gcoh.isMember(i, rowName)) {
                    int n = g;
                    runningScores[n] = runningScores[n] - gcoh.getMissPoints(g, rowName);
                } else {
                    genesetJumps[g] = r;
                    double sr = gcoh.getHitPoints(g, rowName);
                    int n = g;
                    runningScores[n] = runningScores[n] + sr;
                    int n2 = g;
                    int n3 = hitCnt[n2];
                    hitCnt[n2] = n3 + 1;
                    hitIndices[g].hitsIndices[n3] = r;
                    if (storeDeep) {
                        scoresAtEachHitIndex[g].add((float)runningScores[g]);
                    }
                }
                scoresAtEachPoint[g].setElement(r, (float)runningScores[g]);
                if ((double)Math.abs(ess_maxdev[g]) < Math.abs(runningScores[g])) {
                    ess_maxdev[g] = (float)runningScores[g];
                    rankAtMaxEs[g] = r;
                    scoresAtMaxEs[g] = corr;
                }
                if (posList) {
                    if ((double)ess_pos_list[g] < runningScores[g]) {
                        ess_pos_list[g] = (float)runningScores[g];
                        rankAtMaxEs_pos_list[g] = r;
                        scoresAtMaxEs_pos_list[g] = corr;
                    }
                    if (!((double)Math.abs(ess_pos_list_maxdev[g]) < Math.abs(runningScores[g]))) continue;
                    ess_pos_list_maxdev[g] = (float)runningScores[g];
                    rankAtMaxEs_pos_list_maxdev[g] = r;
                    scoresAtMaxEs_pos_list_maxdev[g] = corr;
                    continue;
                }
                if ((double)ess_neg_list[g] > runningScores[g]) {
                    ess_neg_list[g] = (float)runningScores[g];
                    rankAtMaxEs_neg_list[g] = r;
                    scoresAtMaxEs_neg_list[g] = corr;
                }
                if (!((double)Math.abs(ess_neg_list_maxdev[g]) < Math.abs(runningScores[g]))) continue;
                ess_neg_list_maxdev[g] = (float)runningScores[g];
                rankAtMaxEs_neg_list_maxdev[g] = r;
                scoresAtMaxEs_neg_list_maxdev[g] = corr;
            }
        }
        EnrichmentScoreCohort[] cohorts = new EnrichmentScoreCohort[numGeneSets];
        for (int g = 0; g < numGeneSets; ++g) {
            float mw = (float)XMath.mannWhitney(hitIndices[g].hitsIndices, rlSize);
            cohorts[g] = new EnrichmentScoreCohort();
            cohorts[g].es_maxdev_style = new EnrichmentScoreImplSlim(ess_maxdev[g], rankAtMaxEs[g], scoresAtMaxEs[g], cohorts[g]);
            cohorts[g].es_on_pos_list = new EnrichmentScoreImplSlim(ess_pos_list[g], rankAtMaxEs_pos_list[g], scoresAtMaxEs_pos_list[g], cohorts[g]);
            cohorts[g].es_on_pos_list_maxdev = new EnrichmentScoreImplSlim(ess_pos_list_maxdev[g], rankAtMaxEs_pos_list_maxdev[g], scoresAtMaxEs_pos_list_maxdev[g], cohorts[g]);
            cohorts[g].es_on_neg_list = new EnrichmentScoreImplSlim(ess_neg_list[g], rankAtMaxEs_neg_list[g], scoresAtMaxEs_neg_list[g], cohorts[g]);
            cohorts[g].es_on_neg_list_maxdev = new EnrichmentScoreImplSlim(ess_neg_list_maxdev[g], rankAtMaxEs_neg_list_maxdev[g], scoresAtMaxEs_neg_list_maxdev[g], cohorts[g]);
            cohorts[g].mw = mw;
            cohorts[g].numHits = gcoh.getNumTrue(g);
            if (storeDeep) {
                EnrichmentScoreCohort.access$802(cohorts[g], hitIndices[g].hitsIndices);
                cohorts[g].scoresAtEachHitIndex_opt = new Vector(scoresAtEachHitIndex[g]);
            }
            cohorts[g].scoresAtEachPoint_opt = scoresAtEachPoint[g];
        }
        return cohorts;
    }

    static class EnrichmentScoreImplSlim
    implements EnrichmentScore {
        private float fES;
        private int fRankAtES;
        private float fRankScoreAtES;
        private EnrichmentScoreCohort fScoreCoh;

        EnrichmentScoreImplSlim(float es, int rankAtEs, float corrAtEs, EnrichmentScoreCohort coh) {
            this.fES = es;
            this.fRankAtES = rankAtEs;
            this.fRankScoreAtES = corrAtEs;
            this.fScoreCoh = coh;
        }

        @Override
        public float getES() {
            return this.fES;
        }

        @Override
        public int getRankAtES() {
            return this.fRankAtES;
        }

        @Override
        public float getRankScoreAtES() {
            return this.fRankScoreAtES;
        }

        @Override
        public float getNES() {
            return Float.NaN;
        }

        @Override
        public float getNP() {
            return Float.NaN;
        }

        @Override
        public float getFWER() {
            return Float.NaN;
        }

        @Override
        public float getFDR() {
            return Float.NaN;
        }

        @Override
        public Vector getESProfile() {
            return this.fScoreCoh.getESProfile();
        }

        @Override
        public Vector getESProfile_point_by_point_opt() {
            return this.fScoreCoh.getESProfile_full();
        }

        @Override
        public int getNumHits() {
            return this.fScoreCoh.getNumHits();
        }

        @Override
        public int[] getHitIndices() {
            return this.fScoreCoh.getHitIndices();
        }
    }

    private static class EnrichmentScoreCohort {
        private EnrichmentScore es_maxdev_style;
        private EnrichmentScore es_on_pos_list_maxdev;
        private EnrichmentScore es_on_pos_list;
        private EnrichmentScore es_on_neg_list;
        private EnrichmentScore es_on_neg_list_maxdev;
        private float mw;
        private int numHits;
        private int[] fHitIndices_opt;
        private Vector scoresAtEachHitIndex_opt;
        private Vector scoresAtEachPoint_opt;

        private EnrichmentScoreCohort() {
        }

        private boolean hasDeepInfo() {
            return this.scoresAtEachHitIndex_opt != null;
        }

        private Vector getESProfile() {
            this.ensureDeep();
            this.scoresAtEachHitIndex_opt.setImmutable();
            return this.scoresAtEachHitIndex_opt;
        }

        private Vector getESProfile_full() {
            this.ensureDeep();
            this.scoresAtEachPoint_opt.setImmutable();
            return this.scoresAtEachPoint_opt;
        }

        private int getNumHits() {
            return this.numHits;
        }

        private int[] getHitIndices() {
            this.ensureDeep();
            return this.fHitIndices_opt;
        }

        private void ensureDeep() {
            if (!this.hasDeepInfo()) {
                throw new IllegalStateException("EnrichmentScore was NOT consructed in deep mode -- info not available");
            }
        }

        static /* synthetic */ int[] access$802(EnrichmentScoreCohort x0, int[] x1) {
            x0.fHitIndices_opt = x1;
            return x1;
        }
    }

    protected static class HitIndices {
        int[] hitsIndices;

        HitIndices(int len) {
            this.hitsIndices = new int[len];
        }
    }
}

